/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.internal.runtime.InternalExecutionResult;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

public class ExecutionResult
implements ResourceIterable<Map<String, Object>>,
Result {
    private final InternalExecutionResult inner;
    private ResourceIterator<Map<String, Object>> innerIterator;

    public ExecutionResult(InternalExecutionResult projection) {
        this.inner = Objects.requireNonNull(projection);
        if (projection.executionType().queryType() == QueryExecutionType.QueryType.WRITE) {
            this.innerIterator();
        }
    }

    public <T> ResourceIterator<T> columnAs(String n) {
        try {
            return new ExceptionConversion(this.inner.javaColumnAs(n));
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    public QueryExecutionType getQueryExecutionType() {
        try {
            return this.inner.executionType();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    public List<String> columns() {
        try {
            return this.inner.javaColumns();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    public String toString() {
        return this.inner.toString();
    }

    public String dumpToString() {
        return this.inner.dumpToString();
    }

    public QueryStatistics getQueryStatistics() {
        try {
            return this.inner.queryStatistics();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    public void toString(PrintWriter writer) {
        this.inner.dumpToString(writer);
        for (Notification notification : JavaConversions.asJavaIterable((Iterable)this.inner.notifications())) {
            writer.println(notification.getDescription());
        }
    }

    public ResourceIterator<Map<String, Object>> iterator() {
        return this.innerIterator();
    }

    public Stream<Map<String, Object>> stream() {
        return this.iterator().stream();
    }

    public boolean hasNext() {
        try {
            return this.innerIterator().hasNext();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    public Map<String, Object> next() {
        try {
            return (Map)this.innerIterator().next();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    public void close() {
        try {
            if (this.innerIterator != null) {
                this.innerIterator.close();
            }
            this.inner.close();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    public ExecutionPlanDescription getExecutionPlanDescription() {
        try {
            return this.inner.executionPlanDescription();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    public String resultAsString() {
        try {
            return this.dumpToString();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    public void writeAsStringTo(PrintWriter writer) {
        try {
            this.toString(writer);
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public <VisitationException extends Exception> void accept(Result.ResultVisitor<VisitationException> visitor) throws VisitationException {
        this.inner.accept(visitor);
    }

    public java.lang.Iterable<Notification> getNotifications() {
        return JavaConversions.asJavaIterable((Iterable)this.inner.notifications());
    }

    private ResourceIterator<Map<String, Object>> innerIterator() {
        if (this.innerIterator == null) {
            this.innerIterator = this.inner.javaIterator();
        }
        return this.innerIterator;
    }

    public InternalExecutionResult internalExecutionResult() {
        return this.inner;
    }

    public QueryResult queryResult() {
        return this.inner;
    }

    private static QueryExecutionException converted(CypherException e) {
        return new QueryExecutionKernelException((Throwable)e).asUserException();
    }

    private static class ExceptionConversion<T>
    implements ResourceIterator<T> {
        private final ResourceIterator<T> inner;

        ExceptionConversion(ResourceIterator<T> inner) {
            this.inner = inner;
        }

        public void close() {
            try {
                this.inner.close();
            }
            catch (CypherException e) {
                throw ExecutionResult.converted(e);
            }
        }

        public boolean hasNext() {
            try {
                return this.inner.hasNext();
            }
            catch (CypherException e) {
                throw ExecutionResult.converted(e);
            }
        }

        public T next() {
            try {
                return (T)this.inner.next();
            }
            catch (CypherException e) {
                throw ExecutionResult.converted(e);
            }
        }

        public void remove() {
            try {
                this.inner.remove();
            }
            catch (CypherException e) {
                throw ExecutionResult.converted(e);
            }
        }
    }
}

