/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.neo4j.cypher.internal.CommunityCompatibilityFactory;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.cypher.internal.javacompat.GraphDatabaseCypherService;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class CommunityCypherEngineProvider
extends QueryEngineProvider {
    public CommunityCypherEngineProvider() {
        super("cypher");
    }

    protected int enginePriority() {
        return 42;
    }

    protected QueryExecutionEngine createEngine(Dependencies deps, GraphDatabaseAPI graphAPI) {
        GraphDatabaseCypherService queryService = new GraphDatabaseCypherService((GraphDatabaseService)graphAPI);
        deps.satisfyDependency((Object)queryService);
        DependencyResolver resolver = graphAPI.getDependencyResolver();
        LogService logService = (LogService)resolver.resolveDependency(LogService.class);
        Monitors monitors = (Monitors)resolver.resolveDependency(Monitors.class);
        LogProvider logProvider = logService.getInternalLogProvider();
        CommunityCompatibilityFactory compatibilityFactory = new CommunityCompatibilityFactory((GraphDatabaseQueryService)queryService, monitors, logProvider);
        deps.satisfyDependencies(new Object[]{compatibilityFactory});
        return new ExecutionEngine((GraphDatabaseQueryService)queryService, logProvider, compatibilityFactory);
    }
}

