/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.tracing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.cypher.internal.frontend.v3_4.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.tracing.CompilationTracer;

public class TimingCompilationTracer
implements CompilationTracer {
    private final Clock clock;
    private final EventListener listener;

    public TimingCompilationTracer(EventListener listener) {
        this(Clock.SYSTEM, listener);
    }

    TimingCompilationTracer(Clock clock, EventListener listener) {
        this.clock = clock;
        this.listener = listener;
    }

    @Override
    public CompilationTracer.QueryCompilationEvent compileQuery(String query) {
        return new Query(this.clock, query, this.listener);
    }

    private static class Phase
    extends Event
    implements PhaseEvent,
    CompilationPhaseTracer.CompilationPhaseEvent {
        private final CompilationPhaseTracer.CompilationPhase phase;

        Phase(Clock clock, CompilationPhaseTracer.CompilationPhase phase) {
            super(clock);
            this.phase = phase;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.phase + "]";
        }

        @Override
        public CompilationPhaseTracer.CompilationPhase phase() {
            return this.phase;
        }

        @Override
        void done() {
        }
    }

    private static class Query
    extends Event
    implements QueryEvent,
    CompilationTracer.QueryCompilationEvent {
        private final String query;
        private final EventListener listener;
        private final List<Phase> phases = new ArrayList<Phase>();

        Query(Clock clock, String query, EventListener listener) {
            super(clock);
            this.query = query;
            this.listener = listener;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.query + "]";
        }

        public CompilationPhaseTracer.CompilationPhaseEvent beginPhase(CompilationPhaseTracer.CompilationPhase phase) {
            Phase event = new Phase(this.clock(), phase);
            this.phases.add(event);
            return event;
        }

        @Override
        void done() {
            this.listener.queryCompiled(this);
        }

        @Override
        public String query() {
            return this.query;
        }

        @Override
        public List<PhaseEvent> phases() {
            return Collections.unmodifiableList(this.phases);
        }
    }

    private static abstract class Event
    implements AutoCloseable {
        private Clock clock;
        private long time;

        Event(Clock clock) {
            this.clock = clock;
            this.time = clock.nanoTime();
        }

        @Override
        public final void close() {
            if (this.clock != null) {
                this.time = this.clock.nanoTime() - this.time;
                this.clock = null;
                this.done();
            }
        }

        public final long nanoTime() {
            return this.time;
        }

        abstract void done();

        final Clock clock() {
            if (this.clock == null) {
                throw new IllegalStateException(this + " has been closed");
            }
            return this.clock;
        }
    }

    static interface Clock {
        public static final Clock SYSTEM = () -> System.nanoTime();

        public long nanoTime();
    }

    public static interface PhaseEvent {
        public CompilationPhaseTracer.CompilationPhase phase();

        public long nanoTime();
    }

    public static interface QueryEvent {
        public String query();

        public long nanoTime();

        public List<PhaseEvent> phases();
    }

    public static interface EventListener {
        public void queryCompiled(QueryEvent var1);
    }
}

