/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public final class CompiledCursorUtils {
    private CompiledCursorUtils() {
        throw new UnsupportedOperationException();
    }

    public static Value nodeGetProperty(Read read, NodeCursor nodeCursor, long node, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, node);
        }
        nodeCursor.properties(propertyCursor);
        while (propertyCursor.next()) {
            if (propertyCursor.propertyKey() != prop) continue;
            return propertyCursor.propertyValue();
        }
        return Values.NO_VALUE;
    }

    public static boolean nodeHasLabel(Read read, NodeCursor nodeCursor, long node, int label) throws EntityNotFoundException {
        if (label == -1) {
            return false;
        }
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, node);
        }
        return nodeCursor.labels().contains(label);
    }
}

