/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.neo4j.cypher.internal.CommunityCompatibilityFactory;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.cypher.internal.javacompat.SnapshotExecutionEngine;
import org.neo4j.cypher.javacompat.internal.GraphDatabaseCypherService;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class CommunityCypherEngineProvider
extends QueryEngineProvider {
    public CommunityCypherEngineProvider() {
        super("cypher");
    }

    protected int enginePriority() {
        return 42;
    }

    protected QueryExecutionEngine createEngine(Dependencies deps, GraphDatabaseAPI graphAPI) {
        GraphDatabaseCypherService queryService = new GraphDatabaseCypherService((GraphDatabaseService)graphAPI);
        deps.satisfyDependency((Object)queryService);
        DependencyResolver resolver = graphAPI.getDependencyResolver();
        LogService logService = (LogService)resolver.resolveDependency(LogService.class);
        KernelAPI kernelAPI = (KernelAPI)resolver.resolveDependency(KernelAPI.class);
        Monitors monitors = (Monitors)resolver.resolveDependency(Monitors.class);
        Config config = (Config)resolver.resolveDependency(Config.class);
        LogProvider logProvider = logService.getInternalLogProvider();
        CommunityCompatibilityFactory compatibilityFactory = new CommunityCompatibilityFactory(queryService, kernelAPI, monitors, logProvider);
        deps.satisfyDependencies(new Object[]{compatibilityFactory});
        return this.createEngine(queryService, config, logProvider, compatibilityFactory);
    }

    private QueryExecutionEngine createEngine(GraphDatabaseCypherService queryService, Config config, LogProvider logProvider, CommunityCompatibilityFactory compatibilityFactory) {
        return (Boolean)config.get(GraphDatabaseSettings.snapshot_query) != false ? this.snapshotEngine(queryService, config, logProvider, compatibilityFactory) : this.standardEngine(queryService, logProvider, compatibilityFactory);
    }

    private SnapshotExecutionEngine snapshotEngine(GraphDatabaseCypherService queryService, Config config, LogProvider logProvider, CommunityCompatibilityFactory compatibilityFactory) {
        return new SnapshotExecutionEngine(queryService, config, logProvider, compatibilityFactory);
    }

    private ExecutionEngine standardEngine(GraphDatabaseCypherService queryService, LogProvider logProvider, CommunityCompatibilityFactory compatibilityFactory) {
        return new ExecutionEngine(queryService, logProvider, compatibilityFactory);
    }
}

