/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions;

import java.util.List;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.CRS$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.DistanceCalculator;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.DistanceCalculator$class;
import org.neo4j.graphdb.spatial.Point;
import scala.Option;
import scala.Predef$;

public final class HaversinCalculator$
implements DistanceCalculator {
    public static final HaversinCalculator$ MODULE$;
    private final double EARTH_RADIUS_METERS;

    static {
        new HaversinCalculator$();
    }

    @Override
    public Option<Object> apply(Point p1, Point p2) {
        return DistanceCalculator$class.apply(this, p1, p2);
    }

    private double EARTH_RADIUS_METERS() {
        return this.EARTH_RADIUS_METERS;
    }

    @Override
    public boolean isDefinedAt(Point p1, Point p2) {
        return p1.getCRS().getCode() == CRS$.MODULE$.WGS84().code() && p2.getCRS().getCode() == CRS$.MODULE$.WGS84().code();
    }

    @Override
    public double calculateDistance(Point p1, Point p2) {
        List c1Coord = p1.getCoordinate().getCoordinate();
        List c2Coord = p2.getCoordinate().getCoordinate();
        double[] c1 = new double[]{Math.toRadians(Predef$.MODULE$.Double2double((Double)c1Coord.get(0))), Math.toRadians(Predef$.MODULE$.Double2double((Double)c1Coord.get(1)))};
        double[] c2 = new double[]{Math.toRadians(Predef$.MODULE$.Double2double((Double)c2Coord.get(0))), Math.toRadians(Predef$.MODULE$.Double2double((Double)c2Coord.get(1)))};
        double dx = c2[0] - c1[0];
        double dy = c2[1] - c1[1];
        double a = Math.pow(Math.sin(dy / (double)2), 2.0) + Math.cos(c1[1]) * Math.cos(c2[1]) * Math.pow(Math.sin(dx / 2.0), 2.0);
        double greatCircleDistance = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return this.EARTH_RADIUS_METERS() * greatCircleDistance;
    }

    private HaversinCalculator$() {
        MODULE$ = this;
        DistanceCalculator$class.$init$(this);
        this.EARTH_RADIUS_METERS = 6378140.0;
    }
}

