/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.LongStream;
import org.neo4j.cypher.internal.codegen.NodeIdWrapperImpl;
import org.neo4j.cypher.internal.codegen.PrimitiveEntityStream;
import org.neo4j.cypher.internal.compiler.v3_3.spi.NodeIdWrapper;
import org.neo4j.graphdb.Node;

public class PrimitiveNodeStream
extends PrimitiveEntityStream<NodeIdWrapper> {
    private static final PrimitiveNodeStream empty = new PrimitiveNodeStream(LongStream.empty());

    public PrimitiveNodeStream(LongStream inner) {
        super(inner);
    }

    public static PrimitiveNodeStream of(long[] array) {
        return new PrimitiveNodeStream(LongStream.of(array));
    }

    public static PrimitiveNodeStream of(Object list) {
        if (list == null) {
            return empty;
        }
        if (list instanceof List) {
            return new PrimitiveNodeStream(((List)list).stream().mapToLong(Node::getId));
        }
        if (list instanceof Node[]) {
            return new PrimitiveNodeStream(Arrays.stream((Node[])list).mapToLong(Node::getId));
        }
        throw new IllegalArgumentException(String.format("Can not convert to stream: %s", list.getClass().getName()));
    }

    @Override
    public Iterator<NodeIdWrapper> iterator() {
        return this.inner.mapToObj(NodeIdWrapperImpl::new).iterator();
    }
}

