/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.cypher.ProfilerStatisticsNotReadyException;
import org.neo4j.cypher.internal.PlanDescription;
import org.neo4j.cypher.internal.javacompat.ProfilerStatistics;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.helpers.Exceptions;
import scala.collection.JavaConversions;

class Description
implements ExecutionPlanDescription {
    private final PlanDescription description;

    Description(PlanDescription description) {
        this.description = description;
    }

    public String toString() {
        return this.description.toString();
    }

    public String getName() {
        return this.description.name();
    }

    public List<ExecutionPlanDescription> getChildren() {
        ArrayList<ExecutionPlanDescription> result = new ArrayList<ExecutionPlanDescription>();
        for (PlanDescription child : JavaConversions.asJavaIterable(this.description.children())) {
            result.add(new Description(child));
        }
        return result;
    }

    public Map<String, Object> getArguments() {
        return JavaConversions.mapAsJavaMap(this.description.arguments());
    }

    public Set<String> getIdentifiers() {
        if (this.description != null) {
            return JavaConversions.setAsJavaSet(this.description.identifiers());
        }
        return Collections.emptySet();
    }

    public boolean hasProfilerStatistics() {
        return this.description.hasProfilerStatistics();
    }

    public ExecutionPlanDescription.ProfilerStatistics getProfilerStatistics() {
        ProfilerStatistics statistics2;
        try {
            statistics2 = this.description.asJava().getProfilerStatistics();
        }
        catch (ProfilerStatisticsNotReadyException e) {
            throw (NoSuchElementException)Exceptions.withCause((Throwable)new NoSuchElementException(e.getMessage()), (Throwable)e);
        }
        return new ExecutionPlanDescription.ProfilerStatistics(){

            public long getRows() {
                return statistics2.getRows();
            }

            public long getDbHits() {
                return statistics2.getDbHits();
            }

            public long getPageCacheHits() {
                return statistics2.getPageCacheHits();
            }

            public long getPageCacheMisses() {
                return statistics2.getPageCacheMisses();
            }

            public String toString() {
                return statistics2.toString();
            }
        };
    }
}

