/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.util.Map;
import org.neo4j.cypher.internal.CompatibilityFactory;
import org.neo4j.cypher.internal.javacompat.EagerResult;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.cypher.internal.javacompat.UnstableSnapshotException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.LogProvider;

public class SnapshotExecutionEngine
extends ExecutionEngine {
    private final int maxQueryExecutionAttempts;

    SnapshotExecutionEngine(GraphDatabaseQueryService queryService, Config config, LogProvider logProvider, CompatibilityFactory compatibilityFactory) {
        super(queryService, logProvider, compatibilityFactory);
        this.maxQueryExecutionAttempts = (Integer)config.get(GraphDatabaseSettings.snapshot_query_retries);
    }

    @Override
    public Result executeQuery(String query, Map<String, Object> parameters, TransactionalContext context) throws QueryExecutionKernelException {
        return this.executeWithRetries(query, parameters, context, (x$0, x$1, x$2) -> super.executeQuery(x$0, x$1, x$2));
    }

    @Override
    public Result profileQuery(String query, Map<String, Object> parameters, TransactionalContext context) throws QueryExecutionKernelException {
        return this.executeWithRetries(query, parameters, context, (x$0, x$1, x$2) -> super.profileQuery(x$0, x$1, x$2));
    }

    protected Result executeWithRetries(String query, Map<String, Object> parameters, TransactionalContext context, QueryExecutor executor) throws QueryExecutionKernelException {
        EagerResult eagerResult;
        boolean dirtySnapshot;
        VersionContext versionContext = SnapshotExecutionEngine.getCursorContext(context);
        int attempt = 0;
        do {
            if (attempt == this.maxQueryExecutionAttempts) {
                return this.throwQueryExecutionException("Unable to get clean data snapshot for query '%s' after %d attempts.", query, attempt);
            }
            ++attempt;
            versionContext.initRead();
            Result result = executor.execute(query, parameters, context);
            eagerResult = new EagerResult(result, versionContext);
            eagerResult.consume();
            dirtySnapshot = versionContext.isDirty();
            if (!dirtySnapshot || !result.getQueryStatistics().containsUpdates()) continue;
            return this.throwQueryExecutionException("Unable to get clean data snapshot for query '%s' that perform updates.", query, attempt);
        } while (dirtySnapshot);
        return eagerResult;
    }

    private Result throwQueryExecutionException(String message, Object ... parameters) throws QueryExecutionKernelException {
        throw new QueryExecutionKernelException((Throwable)((Object)new UnstableSnapshotException(message, parameters)));
    }

    private static VersionContext getCursorContext(TransactionalContext context) {
        return ((KernelStatement)context.statement()).getVersionContext();
    }

    @FunctionalInterface
    protected static interface QueryExecutor {
        public Result execute(String var1, Map<String, Object> var2, TransactionalContext var3) throws QueryExecutionKernelException;
    }
}

