/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.cypher.internal.frontend.v3_2.ArithmeticException;
import org.neo4j.cypher.internal.frontend.v3_2.CypherTypeException;

public final class CompiledMathHelper {
    private static final double EPSILON = Math.pow(1.0, -10.0);

    private CompiledMathHelper() {
    }

    public static Object add(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (lhs instanceof String || rhs instanceof String) {
            return String.valueOf(lhs) + String.valueOf(rhs);
        }
        if (lhs instanceof List && rhs instanceof List) {
            List lhsList = (List)lhs;
            List rhsList = (List)rhs;
            ArrayList result = new ArrayList(lhsList.size() + rhsList.size());
            result.addAll(lhsList);
            result.addAll(rhsList);
            return result;
        }
        if (lhs instanceof List) {
            List lhsList = (List)lhs;
            ArrayList<Object> result = new ArrayList<Object>(lhsList.size() + 1);
            result.addAll(lhsList);
            result.add(rhs);
            return result;
        }
        if (rhs instanceof List) {
            List rhsList = (List)rhs;
            ArrayList<Object> result = new ArrayList<Object>(rhsList.size() + 1);
            result.add(lhs);
            result.addAll(rhsList);
            return result;
        }
        Class<?> lhsClass = lhs.getClass();
        Class<?> rhsClass = rhs.getClass();
        if (lhsClass.isArray() && rhsClass.isArray()) {
            return CompiledMathHelper.addArrays(lhs, rhs);
        }
        if (lhsClass.isArray()) {
            return CompiledMathHelper.addArrayWithObject(lhs, rhs);
        }
        if (rhsClass.isArray()) {
            return CompiledMathHelper.addObjectWithArray(lhs, rhs);
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof Float || rhs instanceof Float) {
                return ((Number)lhs).doubleValue() + ((Number)rhs).doubleValue();
            }
            if (lhs instanceof Long || rhs instanceof Long || lhs instanceof Integer || rhs instanceof Integer || lhs instanceof Short || rhs instanceof Short || lhs instanceof Byte || rhs instanceof Byte) {
                try {
                    return Math.addExact(((Number)lhs).longValue(), ((Number)rhs).longValue());
                }
                catch (java.lang.ArithmeticException e) {
                    throw new ArithmeticException(String.format("result of %d + %d cannot be represented as an integer", ((Number)lhs).longValue(), ((Number)rhs).longValue()), (Throwable)e);
                }
            }
        }
        throw new CypherTypeException("Cannot add " + lhs.getClass().getSimpleName() + " and " + rhs.getClass().getSimpleName(), null);
    }

    public static Object subtract(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof Float || rhs instanceof Float) {
                return ((Number)lhs).doubleValue() - ((Number)rhs).doubleValue();
            }
            if (lhs instanceof Long || rhs instanceof Long || lhs instanceof Integer || rhs instanceof Integer || lhs instanceof Short || rhs instanceof Short || lhs instanceof Byte || rhs instanceof Byte) {
                try {
                    return Math.subtractExact(((Number)lhs).longValue(), ((Number)rhs).longValue());
                }
                catch (java.lang.ArithmeticException e) {
                    throw new ArithmeticException(String.format("result of %d - %d cannot be represented as an integer", ((Number)lhs).longValue(), ((Number)rhs).longValue()), (Throwable)e);
                }
            }
        }
        throw new CypherTypeException("Cannot add " + lhs.getClass().getSimpleName() + " and " + rhs.getClass().getSimpleName(), null);
    }

    public static Object multiply(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof Float || rhs instanceof Float) {
                return ((Number)lhs).doubleValue() * ((Number)rhs).doubleValue();
            }
            if (lhs instanceof Long || rhs instanceof Long || lhs instanceof Integer || rhs instanceof Integer || lhs instanceof Short || rhs instanceof Short || lhs instanceof Byte || rhs instanceof Byte) {
                try {
                    return Math.multiplyExact(((Number)lhs).longValue(), ((Number)rhs).longValue());
                }
                catch (java.lang.ArithmeticException e) {
                    throw new ArithmeticException(String.format("result of %d * %d cannot be represented as an integer", ((Number)lhs).longValue(), ((Number)rhs).longValue()), (Throwable)e);
                }
            }
        }
        throw new CypherTypeException("Cannot multiply " + lhs.getClass().getSimpleName() + " and " + rhs.getClass().getSimpleName(), null);
    }

    public static Object divide(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof Float || rhs instanceof Float) {
                double left = ((Number)lhs).doubleValue();
                double right = ((Number)rhs).doubleValue();
                if (Math.abs(right) < EPSILON) {
                    throw new ArithmeticException("/ by zero", null);
                }
                return left / right;
            }
            if (lhs instanceof Long || rhs instanceof Long || lhs instanceof Integer || rhs instanceof Integer || lhs instanceof Short || rhs instanceof Short || lhs instanceof Byte || rhs instanceof Byte) {
                long left = ((Number)lhs).longValue();
                long right = ((Number)rhs).longValue();
                if (right == 0L) {
                    throw new ArithmeticException("/ by zero", null);
                }
                return left / right;
            }
        }
        throw new CypherTypeException("Cannot divide " + lhs.getClass().getSimpleName() + " and " + rhs.getClass().getSimpleName(), null);
    }

    public static Object modulo(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            if (lhs instanceof Double || rhs instanceof Double) {
                return ((Number)lhs).doubleValue() % ((Number)rhs).doubleValue();
            }
            if (lhs instanceof Float || rhs instanceof Float) {
                return Float.valueOf(((Number)lhs).floatValue() % ((Number)rhs).floatValue());
            }
            return ((Number)lhs).longValue() % ((Number)rhs).longValue();
        }
        throw new CypherTypeException("Cannot modulo " + lhs.getClass().getSimpleName() + " and " + rhs.getClass().getSimpleName(), null);
    }

    public static int transformToInt(Object value) {
        if (value == null) {
            throw new CypherTypeException("Expected a numeric value but got null", null);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (number.longValue() > Integer.MAX_VALUE) {
                throw new CypherTypeException(value.toString() + " is too large to cast to an int32", null);
            }
            return number.intValue();
        }
        throw new CypherTypeException(String.format("Expected a numeric value but got %s", value.toString()), null);
    }

    public static long transformToLong(Object value) {
        if (value == null) {
            throw new CypherTypeException("Expected a numeric value but got null", null);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        throw new CypherTypeException(String.format("Expected a numeric value but got %s", value.toString()), null);
    }

    private static Object addArrays(Object a1, Object a2) {
        int i;
        int l1 = Array.getLength(a1);
        int l2 = Array.getLength(a2);
        Object[] ret = new Object[l1 + l2];
        for (i = 0; i < l1; ++i) {
            ret[i] = Array.get(a1, i);
        }
        for (i = 0; i < l2; ++i) {
            ret[l1 + i] = Array.get(a2, i);
        }
        return ret;
    }

    private static Object addArrayWithObject(Object array, Object object) {
        int l = Array.getLength(array);
        Object[] ret = new Object[l + 1];
        for (int i = 0; i < l; ++i) {
            ret[i] = Array.get(array, i);
        }
        ret[i] = object;
        return ret;
    }

    private static Object addObjectWithArray(Object object, Object array) {
        int l = Array.getLength(array);
        Object[] ret = new Object[l + 1];
        ret[0] = object;
        for (int i = 1; i < ret.length; ++i) {
            ret[i] = Array.get(array, i);
        }
        return ret;
    }
}

