/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.cypher.internal.codegen.CompiledEquivalenceUtils;
import org.neo4j.cypher.internal.codegen.NodeIdWrapper;
import org.neo4j.cypher.internal.codegen.RelationshipIdWrapper;
import org.neo4j.cypher.internal.frontend.v3_2.CypherTypeException;
import org.neo4j.cypher.internal.frontend.v3_2.IncomparableValuesException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public abstract class CompiledConversionUtils {
    public static boolean coerceToPredicate(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) > 0;
        }
        throw new CypherTypeException("Don't know how to treat that as a predicate: " + value.toString(), null);
    }

    public static Collection<?> toCollection(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        throw new CypherTypeException("Don't know how to create an iterable out of " + value.getClass().getSimpleName(), null);
    }

    public static CompositeKey compositeKey(long ... keys) {
        return new CompositeKey(keys);
    }

    public static Boolean equals(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (lhs instanceof NodeIdWrapper && !(rhs instanceof NodeIdWrapper) || rhs instanceof NodeIdWrapper && !(lhs instanceof NodeIdWrapper) || lhs instanceof RelationshipIdWrapper && !(rhs instanceof RelationshipIdWrapper) || rhs instanceof RelationshipIdWrapper && !(lhs instanceof RelationshipIdWrapper)) {
            throw new IncomparableValuesException(lhs.getClass().getSimpleName(), rhs.getClass().getSimpleName());
        }
        return CompiledEquivalenceUtils.equals(lhs, rhs);
    }

    public static Boolean or(Object lhs, Object rhs) {
        if (lhs == null && rhs == null) {
            return null;
        }
        if (lhs == null && rhs instanceof Boolean) {
            return (Boolean)rhs != false ? Boolean.valueOf(true) : null;
        }
        if (rhs == null && lhs instanceof Boolean) {
            return (Boolean)lhs != false ? Boolean.valueOf(true) : null;
        }
        if (lhs instanceof Boolean && rhs instanceof Boolean) {
            return (Boolean)lhs != false || (Boolean)rhs != false;
        }
        throw new CypherTypeException("Don't know how to do or on: " + (lhs != null ? lhs.toString() : null) + " and " + (rhs != null ? rhs.toString() : null), null);
    }

    public static Boolean not(Object predicate) {
        if (predicate == null) {
            return null;
        }
        if (predicate instanceof Boolean) {
            return (Boolean)predicate == false;
        }
        throw new CypherTypeException("Don't know how to treat that as a boolean: " + predicate.toString(), null);
    }

    public static Object loadParameter(Object value) {
        if (value instanceof Node) {
            return new NodeIdWrapper(((Node)value).getId());
        }
        if (value instanceof Relationship) {
            return new RelationshipIdWrapper(((Relationship)value).getId());
        }
        return value;
    }

    public static class CompositeKey {
        private final long[] key;

        private CompositeKey(long[] key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeKey that = (CompositeKey)o;
            return Arrays.equals(this.key, that.key);
        }

        public int hashCode() {
            return Arrays.hashCode(this.key);
        }
    }
}

