/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;

public class DatabaseSubGraph
implements SubGraph {
    private final GraphDatabaseService gdb;

    public DatabaseSubGraph(GraphDatabaseService gdb) {
        this.gdb = gdb;
    }

    public static SubGraph from(GraphDatabaseService gdb) {
        return new DatabaseSubGraph(gdb);
    }

    @Override
    public Iterable<Node> getNodes() {
        return this.gdb.getAllNodes();
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.gdb.getAllRelationships();
    }

    @Override
    public boolean contains(Relationship relationship) {
        return relationship.getGraphDatabase().equals(this.gdb);
    }

    @Override
    public Iterable<IndexDefinition> getIndexes() {
        return this.gdb.schema().getIndexes();
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        return this.gdb.schema().getConstraints();
    }
}

