/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.util.Map;
import java.util.function.Function;
import org.neo4j.cypher.CypherPlanner;
import org.neo4j.cypher.CypherPlanner$;
import org.neo4j.cypher.CypherPlanner$default$;
import org.neo4j.cypher.CypherPlanner$dp$;
import org.neo4j.cypher.CypherPlanner$greedy$;
import org.neo4j.cypher.CypherPlanner$idp$;
import org.neo4j.cypher.CypherRuntime;
import org.neo4j.cypher.CypherRuntime$;
import org.neo4j.cypher.CypherRuntime$default$;
import org.neo4j.cypher.CypherVersion;
import org.neo4j.cypher.CypherVersion$;
import org.neo4j.cypher.CypherVersion$v2_3$;
import org.neo4j.cypher.CypherVersion$v3_0$;
import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.internal.CypherCompiler;
import org.neo4j.cypher.internal.CypherExecutionMode;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.ExtendedExecutionResult;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.Neo4jTransactionContext;
import org.neo4j.cypher.internal.ParsedQuery;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreparedPlanExecution;
import org.neo4j.cypher.internal.StringCacheMonitor;
import org.neo4j.cypher.internal.TransactionContextFactory$;
import org.neo4j.cypher.internal.compiler.v3_0.CompilationPhaseTracer;
import org.neo4j.cypher.internal.compiler.v3_0.CypherCacheFlushingMonitor;
import org.neo4j.cypher.internal.compiler.v3_0.CypherCacheHitMonitor;
import org.neo4j.cypher.internal.compiler.v3_0.LRUCache;
import org.neo4j.cypher.internal.compiler.v3_0.MonitoringCacheAccessor;
import org.neo4j.cypher.internal.compiler.v3_0.QueryCache;
import org.neo4j.cypher.internal.compiler.v3_0.helpers.JavaResultValueConverter;
import org.neo4j.cypher.internal.compiler.v3_0.prettifier.Prettifier$;
import org.neo4j.cypher.internal.isGraphKernelResultValue$;
import org.neo4j.cypher.internal.spi.ExtendedTransactionalContext;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.tracing.TimingCompilationTracer;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySession;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tug\u0001B\u0001\u0003\u0001-\u0011q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\taaY=qQ\u0016\u0014(BA\u0004\t\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001B\u0001B\u0003%A#A\u0003he\u0006\u0004\b\u000e\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u000511.\u001a:oK2L!!\u0007\f\u00033\u001d\u0013\u0018\r\u001d5ECR\f'-Y:f#V,'/_*feZL7-\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005YAn\\4Qe>4\u0018\u000eZ3s!\ti\u0002%D\u0001\u001f\u0015\tyb!A\u0004m_\u001e<\u0017N\\4\n\u0005\u0005r\"a\u0003'pOB\u0013xN^5eKJDQa\t\u0001\u0005\u0002\u0011\na\u0001P5oSRtDcA\u0013(QA\u0011a\u0005A\u0007\u0002\u0005!)1C\ta\u0001)!91D\tI\u0001\u0002\u0004a\u0002b\u0002\u0016\u0001\u0005\u0004%\tbK\u0001\tSN\u001cVM\u001d<feV\tA\u0006\u0005\u0002\u000e[%\u0011aF\u0004\u0002\b\u0005>|G.Z1o\u0011\u0019\u0001\u0004\u0001)A\u0005Y\u0005I\u0011n]*feZ,'\u000f\t\u0005\b/\u0001\u0011\r\u0011\"\u00053+\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0017\u0003\r\t\u0007/[\u0005\u0003qU\u0012\u0011bS3s]\u0016d\u0017\tU%\t\ri\u0002\u0001\u0015!\u00034\u0003\u001dYWM\u001d8fY\u0002Bq\u0001\u0010\u0001C\u0002\u0013%Q(A\tmCN$8i\\7nSR$X\r\u001a+y\u0013\u0012,\u0012A\u0010\t\u0003M}J!\u0001\u0011\u0002\u000331\u000b7\u000f^\"p[6LG\u000f^3e)bLE\r\u0015:pm&$WM\u001d\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002 \u0002%1\f7\u000f^\"p[6LG\u000f^3e)bLE\r\t\u0005\b\t\u0002\u0011\r\u0011\"\u0005F\u00039YWM\u001d8fY6{g.\u001b;peN,\u0012A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013Z\t!\"\\8oSR|'/\u001b8h\u0013\tY\u0005J\u0001\u0005N_:LGo\u001c:t\u0011\u0019i\u0005\u0001)A\u0005\r\u0006y1.\u001a:oK2luN\\5u_J\u001c\b\u0005C\u0004P\u0001\t\u0007I\u0011\u0002)\u0002#\r|W\u000e]5mCRLwN\u001c+sC\u000e,'/F\u0001R!\t\u0011V+D\u0001T\u0015\t!&!A\u0004ue\u0006\u001c\u0017N\\4\n\u0005Y\u001b&!E\"p[BLG.\u0019;j_:$&/Y2fe\"1\u0001\f\u0001Q\u0001\nE\u000b!cY8na&d\u0017\r^5p]R\u0013\u0018mY3sA!9!\f\u0001b\u0001\n#Y\u0016\u0001C2p[BLG.\u001a:\u0016\u0003q\u0003\"AJ/\n\u0005y\u0013!AD\"za\",'oQ8na&dWM\u001d\u0005\u0007A\u0002\u0001\u000b\u0011\u0002/\u0002\u0013\r|W\u000e]5mKJ\u0004\u0003b\u00022\u0001\u0005\u0004%IaY\u0001\u0004Y><W#\u00013\u0011\u0005u)\u0017B\u00014\u001f\u0005\raun\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011\u00023\u0002\t1|w\r\t\u0005\bU\u0002\u0011\r\u0011\"\u0003l\u00031\u0019\u0017m\u00195f\u001b>t\u0017\u000e^8s+\u0005a\u0007C\u0001\u0014n\u0013\tq'A\u0001\nTiJLgnZ\"bG\",Wj\u001c8ji>\u0014\bB\u00029\u0001A\u0003%A.A\u0007dC\u000eDW-T8oSR|'\u000f\t\u0005\be\u0002\u0011\r\u0011\"\u0003t\u0003A)\u00070Z2vi&|g.T8oSR|'/F\u0001u!\t)(0D\u0001w\u0015\t9\b0A\u0003rk\u0016\u0014\u0018P\u0003\u0002z-\u0005!\u0011.\u001c9m\u0013\tYhOA\u000bRk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8N_:LGo\u001c:\t\ru\u0004\u0001\u0015!\u0003u\u0003E)\u00070Z2vi&|g.T8oSR|'\u000f\t\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002\u0005i1-Y2iK\u0006\u001b7-Z:t_J,\"!a\u0001\u0011\u0011\u0005\u0015\u0011QBA\t\u0003?i!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0005mNz\u0006G\u0003\u0002[\u0005%!\u0011qBA\u0004\u0005]iuN\\5u_JLgnZ\"bG\",\u0017iY2fgN|'\u000f\u0005\u0003\u0002\u0014\u0005eabA\u0007\u0002\u0016%\u0019\u0011q\u0003\b\u0002\rA\u0013X\rZ3g\u0013\u0011\tY\"!\b\u0003\rM#(/\u001b8h\u0015\r\t9B\u0004\t\b\u001b\u0005\u0005\u0012QEA\u0016\u0013\r\t\u0019C\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\u0019\n9#C\u0002\u0002*\t\u0011Q\"\u0012=fGV$\u0018n\u001c8QY\u0006t\u0007\u0003CA\n\u0003[\t\t\"!\r\n\t\u0005=\u0012Q\u0004\u0002\u0004\u001b\u0006\u0004\bcA\u0007\u00024%\u0019\u0011Q\u0007\b\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002:\u0001\u0001\u000b\u0011BA\u0002\u00039\u0019\u0017m\u00195f\u0003\u000e\u001cWm]:pe\u0002B\u0011\"!\u0010\u0001\u0005\u0004%I!a\u0010\u0002!A\u0014X\rU1sg\u0016$\u0017+^3sS\u0016\u001cXCAA!!!\t)!a\u0011\u0002\u0012\u0005\u001d\u0013\u0002BA#\u0003\u000f\u0011\u0001\u0002\u0014*V\u0007\u0006\u001c\u0007.\u001a\t\u0004M\u0005%\u0013bAA&\u0005\tq\u0001K]3QCJ\u001cX\rZ)vKJL\b\u0002CA(\u0001\u0001\u0006I!!\u0011\u0002#A\u0014X\rU1sg\u0016$\u0017+^3sS\u0016\u001c\b\u0005C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002V\u0005i\u0001/\u0019:tK\u0012\fV/\u001a:jKN,\"!a\u0016\u0011\u0011\u0005\u0015\u00111IA\t\u00033\u00022AJA.\u0013\r\tiF\u0001\u0002\f!\u0006\u00148/\u001a3Rk\u0016\u0014\u0018\u0010\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA,\u00039\u0001\u0018M]:fIF+XM]5fg\u0002B\u0011\"!\u001a\u0001\u0005\u0004%I!a\u001a\u0002\u0015)\fg/\u0019,bYV,7/\u0006\u0002\u0002jA!\u00111NA9\u001b\t\tiG\u0003\u0003\u0002p\u0005\u001d\u0011a\u00025fYB,'o]\u0005\u0005\u0003g\niG\u0001\rKCZ\f'+Z:vYR4\u0016\r\\;f\u0007>tg/\u001a:uKJD\u0001\"a\u001e\u0001A\u0003%\u0011\u0011N\u0001\fU\u00064\u0018MV1mk\u0016\u001c\b\u0005C\u0004\u0002|\u0001!\t!! \u0002\u000fA\u0014xNZ5mKRA\u0011qPAC\u0003\u000f\u000bI\nE\u0002'\u0003\u0003K1!a!\u0003\u0005])\u0005\u0010^3oI\u0016$W\t_3dkRLwN\u001c*fgVdG\u000fC\u0004x\u0003s\u0002\r!!\u0005\t\u0011\u0005%\u0015\u0011\u0010a\u0001\u0003\u0017\u000ba\u0001]1sC6\u001c\b\u0003CAG\u0003/\u000b\t\"!\r\u000e\u0005\u0005=%\u0002BAI\u0003'\u000bA!\u001e;jY*\u0011\u0011QS\u0001\u0005U\u00064\u0018-\u0003\u0003\u00020\u0005=\u0005\u0002CAN\u0003s\u0002\r!!(\u0002\u000fM,7o]5p]B\u0019Q/a(\n\u0007\u0005\u0005fO\u0001\u0007Rk\u0016\u0014\u0018pU3tg&|g\u000e\u000b\u0004\u0002z\u0005\u0015\u00161\u0017\t\u0006\u001b\u0005\u001d\u00161V\u0005\u0004\u0003Ss!A\u0002;ie><8\u000f\u0005\u0003\u0002.\u0006=V\"\u0001\u0003\n\u0007\u0005EFAA\bTs:$\u0018\r_#yG\u0016\u0004H/[8oG\t\tY\u000bC\u0004\u0002|\u0001!\t!a.\u0015\u0011\u0005}\u0014\u0011XA^\u0003{Cqa^A[\u0001\u0004\t\t\u0002\u0003\u0005\u0002\n\u0006U\u0006\u0019AA\u0016\u0011!\tY*!.A\u0002\u0005u\u0005FBA[\u0003K\u000b\u0019\fC\u0004\u0002D\u0002!\t!!2\u0002\u000f\u0015DXmY;uKRA\u0011qPAd\u0003\u0013\fY\rC\u0004x\u0003\u0003\u0004\r!!\u0005\t\u0011\u0005%\u0015\u0011\u0019a\u0001\u0003\u0017C\u0001\"a'\u0002B\u0002\u0007\u0011Q\u0014\u0015\u0007\u0003\u0003\f)+a-\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002RRA\u0011qPAj\u0003+\f9\u000eC\u0004x\u0003\u001f\u0004\r!!\u0005\t\u0011\u0005%\u0015q\u001aa\u0001\u0003WA\u0001\"a'\u0002P\u0002\u0007\u0011Q\u0014\u0015\u0007\u0003\u001f\f)+a-\t\u000f\u0005u\u0007\u0001\"\u0005\u0002`\u0006Q\u0001/\u0019:tKF+XM]=\u0015\t\u0005e\u0013\u0011\u001d\u0005\t\u0003G\fY\u000e1\u0001\u0002\u0012\u0005I\u0011/^3ssR+\u0007\u0010\u001e\u0015\u0007\u00037\f)+a-\t\u000f\u0005%\b\u0001\"\u0003\u0002l\u0006\u0019\u0002/\u0019:tKB\u0013X\rU1sg\u0016$\u0017+^3ssR1\u0011\u0011LAw\u0003cD\u0001\"a<\u0002h\u0002\u0007\u0011qI\u0001\u000faJ,\u0007+\u0019:tK\u0012\fV/\u001a:z\u0011!\t\u00190a:A\u0002\u0005U\u0018A\u0002;sC\u000e,'\u000f\u0005\u0003\u0002\u0006\u0005]\u0018\u0002BA}\u0003\u000f\u0011acQ8na&d\u0017\r^5p]BC\u0017m]3Ue\u0006\u001cWM\u001d\u0015\u0007\u0003O\f)+a-\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002\u0005i\u0001O]3QCJ\u001cX-U;fef$B!a\u0012\u0003\u0004!A\u00111]A\u007f\u0001\u0004\t\t\u0002\u000b\u0004\u0002~\u0006\u0015\u00161\u0017\u0005\b\u0005\u0013\u0001A\u0011\u0003B\u0006\u0003%\u0001H.\u00198Rk\u0016\u0014\u0018\u0010\u0006\u0003\u0003\u000e\t\u0005\u0002cB\u0007\u0002\"\t=!Q\u0003\t\u0004M\tE\u0011b\u0001B\n\u0005\t)\u0002K]3qCJ,G\r\u00157b]\u0016CXmY;uS>t\u0007\u0003\u0002B\f\u0005;i!A!\u0007\u000b\u0007\tm!!A\u0002ta&LAAa\b\u0003\u001a\taR\t\u001f;f]\u0012,G\r\u0016:b]N\f7\r^5p]\u0006d7i\u001c8uKb$\b\u0002CAr\u0005\u000f\u0001\r!!\u0005)\r\t\u001d\u0011QUAZ\u0011%\u00119\u0003\u0001b\u0001\n\u0013\u0011I#\u0001\u0005uq\n\u0013\u0018\u000eZ4f+\t\u0011Y\u0003\u0005\u0003\u0003.\tMRB\u0001B\u0018\u0015\r\u0011\t\u0004_\u0001\u0005G>\u0014X-\u0003\u0003\u00036\t=\"A\b+ie\u0016\fG\rV8Ti\u0006$X-\\3oi\u000e{g\u000e^3yi\n\u0013\u0018\u000eZ4f\u0011!\u0011I\u0004\u0001Q\u0001\n\t-\u0012!\u0003;y\u0005JLGmZ3!\u0011\u001d\u0011i\u0004\u0001C\u0005\u0005\u007f\t!dZ3u\u001fJ\u001c%/Z1uK\u001a\u0013x.\\*dQ\u0016l\u0017m\u0015;bi\u0016,BA!\u0011\u0003HQ1!1\tB*\u0005;\u0002BA!\u0012\u0003H1\u0001A\u0001\u0003B%\u0005w\u0011\rAa\u0013\u0003\u0003Y\u000bBA!\u0014\u00022A\u0019QBa\u0014\n\u0007\tEcBA\u0004O_RD\u0017N\\4\t\u0011\tU#1\ba\u0001\u0005/\n!b\u001c9fe\u0006$\u0018n\u001c8t!\r!$\u0011L\u0005\u0004\u00057*$A\u0004*fC\u0012|\u0005/\u001a:bi&|gn\u001d\u0005\n\u0005?\u0012Y\u0004\"a\u0001\u0005C\nqa\u0019:fCR|'\u000fE\u0003\u000e\u0005G\u0012\u0019%C\u0002\u0003f9\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0005S\u0002A\u0011\u0001B6\u0003!\u0001(/\u001a;uS\u001aLH\u0003BA\t\u0005[Bqa\u001eB4\u0001\u0004\t\t\u0002C\u0004\u0003r\u0001!\tAa\u001d\u0002!%\u001c\b+\u001a:j_\u0012L7mQ8n[&$Hc\u0001\u0017\u0003v!9qOa\u001cA\u0002\u0005E\u0001B\u0002B=\u0001\u0011%1,\u0001\bde\u0016\fG/Z\"p[BLG.\u001a:\t\u000f\tu\u0004\u0001\"\u0003\u0003\u0000\u0005\u0001r-\u001a;QY\u0006t7)Y2iKNK'0Z\u000b\u0003\u0005\u0003\u00032!\u0004BB\u0013\r\u0011)I\u0004\u0002\u0004\u0013:$\bb\u0002BE\u0001\u0011%!1R\u0001\u0010_B$xI]1qQN+G\u000f^5oOV!!Q\u0012BI)!\u0011yIa%\u0003\u0016\n%\u0006\u0003\u0002B#\u0005##\u0001B!\u0013\u0003\b\n\u0007!1\n\u0005\u0007'\t\u001d\u0005\u0019\u0001\u000b\t\u0011\t]%q\u0011a\u0001\u00053\u000bqa]3ui&tw\r\u0005\u0004\u0003\u001c\n\u0015&qR\u0007\u0003\u0005;SAAa(\u0003\"\u000611m\u001c8gS\u001eT1Aa)\u0007\u0003\u001d9'/\u00199iI\nLAAa*\u0003\u001e\n91+\u001a;uS:<\u0007\u0002\u0003BV\u0005\u000f\u0003\rAa$\u0002\u0019\u0011,g-Y;miZ\u000bG.^3\b\u000f\t=&\u0001#\u0001\u00032\u0006yQ\t_3dkRLwN\\#oO&tW\rE\u0002'\u0005g3a!\u0001\u0002\t\u0002\tU6c\u0001BZ\u0019!91Ea-\u0005\u0002\teFC\u0001BY\u0011)\u0011iLa-C\u0002\u0013\u0005!qP\u0001\u0014!2\u000bej\u0018\"V\u00132#\u0015JT$`)JKUi\u0015\u0005\n\u0005\u0003\u0014\u0019\f)A\u0005\u0005\u0003\u000bA\u0003\u0015'B\u001d~\u0013U+\u0013'E\u0013:;u\f\u0016*J\u000bN\u0003\u0003B\u0003Bc\u0005g\u000b\n\u0011\"\u0001\u0003H\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"A!3+\u0007q\u0011Ym\u000b\u0002\u0003NB!!q\u001aBm\u001b\t\u0011\tN\u0003\u0003\u0003T\nU\u0017!C;oG\",7m[3e\u0015\r\u00119ND\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bn\u0005#\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ExecutionEngine {
    private final GraphDatabaseQueryService graph;
    private final LogProvider logProvider;
    private final boolean isServer;
    private final KernelAPI kernel;
    private final LastCommittedTxIdProvider lastCommittedTxId;
    private final Monitors kernelMonitors;
    private final CompilationTracer compilationTracer;
    private final CypherCompiler compiler;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final StringCacheMonitor org$neo4j$cypher$internal$ExecutionEngine$$cacheMonitor;
    private final QueryExecutionMonitor executionMonitor;
    private final MonitoringCacheAccessor<String, Tuple2<ExecutionPlan, scala.collection.immutable.Map<String, Object>>> org$neo4j$cypher$internal$ExecutionEngine$$cacheAccessor;
    private final LRUCache<String, PreParsedQuery> preParsedQueries;
    private final LRUCache<String, ParsedQuery> org$neo4j$cypher$internal$ExecutionEngine$$parsedQueries;
    private final JavaResultValueConverter javaValues;
    private final ThreadToStatementContextBridge txBridge;

    public static LogProvider $lessinit$greater$default$2() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$2();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public boolean isServer() {
        return this.isServer;
    }

    public KernelAPI kernel() {
        return this.kernel;
    }

    private LastCommittedTxIdProvider lastCommittedTxId() {
        return this.lastCommittedTxId;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    private CompilationTracer compilationTracer() {
        return this.compilationTracer;
    }

    public CypherCompiler compiler() {
        return this.compiler;
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    public StringCacheMonitor org$neo4j$cypher$internal$ExecutionEngine$$cacheMonitor() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$cacheMonitor;
    }

    private QueryExecutionMonitor executionMonitor() {
        return this.executionMonitor;
    }

    public MonitoringCacheAccessor<String, Tuple2<ExecutionPlan, scala.collection.immutable.Map<String, Object>>> org$neo4j$cypher$internal$ExecutionEngine$$cacheAccessor() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$cacheAccessor;
    }

    private LRUCache<String, PreParsedQuery> preParsedQueries() {
        return this.preParsedQueries;
    }

    public LRUCache<String, ParsedQuery> org$neo4j$cypher$internal$ExecutionEngine$$parsedQueries() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$parsedQueries;
    }

    private JavaResultValueConverter javaValues() {
        return this.javaValues;
    }

    public ExtendedExecutionResult profile(String query, Map<String, Object> params, QuerySession session) throws SyntaxException {
        return this.profile(query, (scala.collection.immutable.Map<String, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(params).asScala()).toMap(Predef$.MODULE$.$conforms()), session);
    }

    public ExtendedExecutionResult profile(String query, scala.collection.immutable.Map<String, Object> params, QuerySession session) throws SyntaxException {
        Map javaParams = this.javaValues().asDeepJavaResultMap(params);
        this.executionMonitor().startQueryExecution(session, query, javaParams);
        Tuple2<PreparedPlanExecution, ExtendedTransactionalContext> tuple2 = this.planQuery(query);
        if (tuple2 != null) {
            Tuple2 tuple22;
            PreparedPlanExecution preparedPlanExecution = (PreparedPlanExecution)tuple2._1();
            ExtendedTransactionalContext transactionalContext = (ExtendedTransactionalContext)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)preparedPlanExecution, (Object)transactionalContext);
            PreparedPlanExecution preparedPlanExecution2 = (PreparedPlanExecution)tuple23._1();
            ExtendedTransactionalContext transactionalContext2 = (ExtendedTransactionalContext)tuple23._2();
            return preparedPlanExecution2.profile(transactionalContext2, params, session);
        }
        throw new MatchError(tuple2);
    }

    public ExtendedExecutionResult execute(String query, Map<String, Object> params, QuerySession session) throws SyntaxException {
        return this.execute(query, (scala.collection.immutable.Map<String, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(params).asScala()).toMap(Predef$.MODULE$.$conforms()), session);
    }

    public ExtendedExecutionResult execute(String query, scala.collection.immutable.Map<String, Object> params, QuerySession session) throws SyntaxException {
        Map javaParams = this.javaValues().asDeepJavaResultMap(params);
        this.executionMonitor().startQueryExecution(session, query, javaParams);
        Tuple2<PreparedPlanExecution, ExtendedTransactionalContext> tuple2 = this.planQuery(query);
        if (tuple2 != null) {
            Tuple2 tuple22;
            PreparedPlanExecution preparedPlanExecution = (PreparedPlanExecution)tuple2._1();
            ExtendedTransactionalContext transactionalContext = (ExtendedTransactionalContext)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)preparedPlanExecution, (Object)transactionalContext);
            PreparedPlanExecution preparedPlanExecution2 = (PreparedPlanExecution)tuple23._1();
            ExtendedTransactionalContext transactionalContext2 = (ExtendedTransactionalContext)tuple23._2();
            return preparedPlanExecution2.execute(transactionalContext2, params, session);
        }
        throw new MatchError(tuple2);
    }

    public ParsedQuery parseQuery(String queryText) throws SyntaxException {
        return this.parsePreParsedQuery(this.preParseQuery(queryText), CompilationPhaseTracer.NO_TRACING);
    }

    private ParsedQuery parsePreParsedQuery(PreParsedQuery preParsedQuery, CompilationPhaseTracer tracer) throws SyntaxException {
        return (ParsedQuery)this.org$neo4j$cypher$internal$ExecutionEngine$$parsedQueries().get((Object)preParsedQuery.statementWithVersionAndPlanner()).getOrElse((Function0)new Serializable(this, preParsedQuery, tracer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;
            private final PreParsedQuery preParsedQuery$1;
            private final CompilationPhaseTracer tracer$1;

            /*
             * WARNING - void declaration
             */
            public final ParsedQuery apply() {
                void var1_1;
                ParsedQuery parsedQuery = this.$outer.compiler().parseQuery(this.preParsedQuery$1, this.tracer$1);
                Object object = parsedQuery.hasErrors() ? BoxedUnit.UNIT : this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$parsedQueries().put((Object)this.preParsedQuery$1.statementWithVersionAndPlanner(), (Object)parsedQuery);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.preParsedQuery$1 = preParsedQuery$1;
                this.tracer$1 = tracer$1;
            }
        });
    }

    private PreParsedQuery preParseQuery(String queryText) throws SyntaxException {
        return (PreParsedQuery)this.preParsedQueries().getOrElseUpdate((Object)queryText, (Function0)new Serializable(this, queryText){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;
            private final String queryText$2;

            public final PreParsedQuery apply() {
                return this.$outer.compiler().preParseQuery(this.queryText$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queryText$2 = queryText$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<PreparedPlanExecution, ExtendedTransactionalContext> planQuery(String queryText) throws SyntaxException {
        CompilationTracer.QueryCompilationEvent phaseTracer = this.compilationTracer().compileQuery(queryText);
        try {
            PreParsedQuery preParsedQuery = this.preParseQuery(queryText);
            CypherExecutionMode executionMode = preParsedQuery.executionMode();
            String cacheKey = preParsedQuery.statementWithVersionAndPlanner();
            for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                Neo4jTransactionContext tc = TransactionContextFactory$.MODULE$.open(this.graph, this.txBridge());
                Tuple2 tuple2 = this.liftedTree1$1(queryText, phaseTracer, preParsedQuery, cacheKey, tc);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    boolean touched = tuple2._2$mcZ$sp();
                    if (tuple22 != null) {
                        ExecutionPlan plan2 = (ExecutionPlan)tuple22._1();
                        scala.collection.immutable.Map extractedParameters = (scala.collection.immutable.Map)tuple22._2();
                        if (plan2 != null) {
                            void var18_17;
                            void var17_16;
                            void var8_7;
                            Tuple3 tuple3;
                            ExecutionPlan executionPlan = plan2;
                            Tuple3 tuple32 = tuple3 = new Tuple3((Object)executionPlan, (Object)extractedParameters, (Object)BoxesRunTime.boxToBoolean((boolean)touched));
                            ExecutionPlan plan3 = (ExecutionPlan)tuple32._1();
                            scala.collection.immutable.Map extractedParameters2 = (scala.collection.immutable.Map)tuple32._2();
                            boolean touched2 = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
                            if (touched2) {
                                tc.close(true);
                                continue;
                            }
                            var8_7.cleanForReuse();
                            return new Tuple2((Object)new PreparedPlanExecution((ExecutionPlan)var17_16, executionMode, (scala.collection.immutable.Map<String, Object>)var18_17), (Object)var8_7);
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            throw new IllegalStateException("Could not execute query due to insanely frequent schema changes");
        }
        finally {
            phaseTracer.close();
        }
    }

    private ThreadToStatementContextBridge txBridge() {
        return this.txBridge;
    }

    private <V> V getOrCreateFromSchemaState(ReadOperations operations, Function0<V> creator) {
        Function javaCreator = new Function<ExecutionEngine, V>(this, creator){
            private final Function0 creator$1;

            public V apply(ExecutionEngine key) {
                return (V)this.creator$1.apply();
            }
            {
                this.creator$1 = creator$1;
            }
        };
        return (V)operations.schemaStateGetOrCreate((Object)this, javaCreator);
    }

    public String prettify(String query) {
        return Prettifier$.MODULE$.apply(query);
    }

    public boolean isPeriodicCommit(String query) {
        return this.parseQuery(query).isPeriodicCommit();
    }

    private CypherCompiler createCompiler() {
        Boolean errorIfShortestPathFallbackUsedAtRuntime;
        long idpIterationDuration;
        int idpMaxTableSize;
        Boolean useErrorsOverWarnings;
        CypherRuntime runtime;
        CypherPlanner planner;
        CypherVersion version;
        block3: {
            block4: {
                block2: {
                    version = (CypherVersion)CypherVersion$.MODULE$.apply(this.optGraphSetting(this.graph, GraphDatabaseSettings.cypher_parser_version, CypherVersion$.MODULE$.default().name()));
                    planner = (CypherPlanner)CypherPlanner$.MODULE$.apply(this.optGraphSetting(this.graph, GraphDatabaseSettings.cypher_planner, CypherPlanner$default$.MODULE$.name()));
                    runtime = (CypherRuntime)CypherRuntime$.MODULE$.apply(this.optGraphSetting(this.graph, GraphDatabaseSettings.cypher_runtime, CypherRuntime$default$.MODULE$.name()));
                    useErrorsOverWarnings = this.optGraphSetting(this.graph, GraphDatabaseSettings.cypher_hints_error, Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(GraphDatabaseSettings.cypher_hints_error.getDefaultValue())).toBoolean()));
                    idpMaxTableSize = Predef$.MODULE$.Integer2int(this.optGraphSetting(this.graph, GraphDatabaseSettings.cypher_idp_solver_table_threshold, Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(GraphDatabaseSettings.cypher_idp_solver_table_threshold.getDefaultValue())).toInt())));
                    idpIterationDuration = Predef$.MODULE$.Long2long(this.optGraphSetting(this.graph, GraphDatabaseSettings.cypher_idp_solver_duration_threshold, Predef$.MODULE$.long2Long(new StringOps(Predef$.MODULE$.augmentString(GraphDatabaseSettings.cypher_idp_solver_duration_threshold.getDefaultValue())).toLong())));
                    errorIfShortestPathFallbackUsedAtRuntime = this.optGraphSetting(this.graph, GraphDatabaseSettings.forbid_exhaustive_shortestpath, Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(GraphDatabaseSettings.forbid_exhaustive_shortestpath.getDefaultValue())).toBoolean()));
                    CypherVersion cypherVersion = version;
                    CypherVersion$v2_3$ cypherVersion$v2_3$ = CypherVersion$v2_3$.MODULE$;
                    if (cypherVersion != null ? !cypherVersion.equals(cypherVersion$v2_3$) : cypherVersion$v2_3$ != null) break block2;
                    CypherVersion cypherVersion2 = version;
                    CypherVersion$v3_0$ cypherVersion$v3_0$ = CypherVersion$v3_0$.MODULE$;
                    if (!(cypherVersion2 == null ? cypherVersion$v3_0$ != null : !cypherVersion2.equals(cypherVersion$v3_0$))) break block3;
                }
                CypherPlanner cypherPlanner = planner;
                CypherPlanner$greedy$ cypherPlanner$greedy$ = CypherPlanner$greedy$.MODULE$;
                if (!(cypherPlanner == null ? cypherPlanner$greedy$ != null : !cypherPlanner.equals(cypherPlanner$greedy$))) break block4;
                CypherPlanner cypherPlanner2 = planner;
                CypherPlanner$idp$ cypherPlanner$idp$ = CypherPlanner$idp$.MODULE$;
                if (!(cypherPlanner2 == null ? cypherPlanner$idp$ != null : !cypherPlanner2.equals(cypherPlanner$idp$))) break block4;
                CypherPlanner cypherPlanner3 = planner;
                CypherPlanner$dp$ cypherPlanner$dp$ = CypherPlanner$dp$.MODULE$;
                if (cypherPlanner3 != null ? !cypherPlanner3.equals(cypherPlanner$dp$) : cypherPlanner$dp$ != null) break block3;
            }
            String message = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot combine configurations: ", "=", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GraphDatabaseSettings.cypher_parser_version.name(), version.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with ", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GraphDatabaseSettings.cypher_planner.name(), planner.name()}))).toString();
            this.org$neo4j$cypher$internal$ExecutionEngine$$log().error(message);
            throw new IllegalStateException(message);
        }
        return new CypherCompiler(this.graph, this.kernel(), this.kernelMonitors(), version, planner, runtime, Predef$.MODULE$.Boolean2boolean(useErrorsOverWarnings), idpMaxTableSize, idpIterationDuration, Predef$.MODULE$.Boolean2boolean(errorIfShortestPathFallbackUsedAtRuntime), this.logProvider);
    }

    public int org$neo4j$cypher$internal$ExecutionEngine$$getPlanCacheSize() {
        return Predef$.MODULE$.Integer2int(this.optGraphSetting(this.graph, GraphDatabaseSettings.query_cache_size, Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(GraphDatabaseSettings.query_cache_size.getDefaultValue())).toInt())));
    }

    private <V> V optGraphSetting(GraphDatabaseQueryService graph, Setting<V> setting, V defaultValue) {
        Config config = (Config)graph.getDependencyResolver().resolveDependency(Config.class);
        return (V)Option$.MODULE$.apply(config.get(setting)).getOrElse((Function0)new Serializable(this, defaultValue){
            public static final long serialVersionUID = 0L;
            private final Object defaultValue$1;

            public final V apply() {
                return (V)this.defaultValue$1;
            }
            {
                this.defaultValue$1 = defaultValue$1;
            }
        });
    }

    public final boolean org$neo4j$cypher$internal$ExecutionEngine$$isStale$1(ExecutionPlan plan2, scala.collection.immutable.Map ignored, Neo4jTransactionContext tc$1) {
        return plan2.isStale(this.lastCommittedTxId(), tc$1);
    }

    public final Tuple2 org$neo4j$cypher$internal$ExecutionEngine$$producePlan$1(CompilationTracer.QueryCompilationEvent phaseTracer$1, PreParsedQuery preParsedQuery$2, Neo4jTransactionContext tc$1) {
        ParsedQuery parsedQuery = this.parsePreParsedQuery(preParsedQuery$2, phaseTracer$1);
        return parsedQuery.plan(tc$1, phaseTracer$1);
    }

    private final Tuple2 liftedTree1$1(String queryText$1, CompilationTracer.QueryCompilationEvent phaseTracer$1, PreParsedQuery preParsedQuery$2, String cacheKey$1, Neo4jTransactionContext tc$1) {
        try {
            QueryCache cache = (QueryCache)this.getOrCreateFromSchemaState(tc$1.readOperations(), (Function0)new Serializable(this, tc$1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExecutionEngine $outer;
                private final Neo4jTransactionContext tc$1;

                public final QueryCache<String, Tuple2<ExecutionPlan, scala.collection.immutable.Map<String, Object>>> apply() {
                    this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$cacheMonitor().cacheFlushDetected(this.tc$1.statement());
                    LRUCache lruCache = new LRUCache(this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$getPlanCacheSize());
                    return new QueryCache(this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$cacheAccessor(), lruCache);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tc$1 = tc$1;
                }
            });
            return cache.getOrElseUpdate((Object)cacheKey$1, queryText$1, new Serializable(this, tc$1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExecutionEngine $outer;
                private final Neo4jTransactionContext tc$1;

                public final boolean apply(ExecutionPlan plan2, scala.collection.immutable.Map<String, Object> ignored) {
                    return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$isStale$1(plan2, ignored, this.tc$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tc$1 = tc$1;
                }
            }.tupled(), (Function0)new Serializable(this, phaseTracer$1, preParsedQuery$2, tc$1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExecutionEngine $outer;
                private final CompilationTracer.QueryCompilationEvent phaseTracer$1;
                private final PreParsedQuery preParsedQuery$2;
                private final Neo4jTransactionContext tc$1;

                public final Tuple2<ExecutionPlan, scala.collection.immutable.Map<String, Object>> apply() {
                    return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$producePlan$1(this.phaseTracer$1, this.preParsedQuery$2, this.tc$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.phaseTracer$1 = phaseTracer$1;
                    this.preParsedQuery$2 = preParsedQuery$2;
                    this.tc$1 = tc$1;
                }
            });
        }
        catch (Throwable throwable) {
            tc$1.close(false);
            throw throwable;
        }
    }

    public ExecutionEngine(GraphDatabaseQueryService graph, LogProvider logProvider) {
        this.graph = graph;
        this.logProvider = logProvider;
        Predef$.MODULE$.require(graph != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't work with a null graph database";
            }
        });
        this.isServer = false;
        this.kernel = (KernelAPI)graph.getDependencyResolver().resolveDependency(KernelAPI.class);
        this.lastCommittedTxId = new LastCommittedTxIdProvider(graph);
        this.kernelMonitors = (Monitors)graph.getDependencyResolver().resolveDependency(Monitors.class);
        this.compilationTracer = Predef$.MODULE$.Boolean2boolean(this.optGraphSetting(graph, GraphDatabaseSettings.cypher_compiler_tracing, Boolean.FALSE)) ? new TimingCompilationTracer((TimingCompilationTracer.EventListener)this.kernelMonitors().newMonitor(TimingCompilationTracer.EventListener.class, new String[0])) : CompilationTracer.NO_COMPILATION_TRACING;
        this.compiler = this.createCompiler();
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        this.org$neo4j$cypher$internal$ExecutionEngine$$cacheMonitor = (StringCacheMonitor)this.kernelMonitors().newMonitor(StringCacheMonitor.class, new String[0]);
        this.kernelMonitors().addMonitorListener((Object)new StringCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(Object justBeforeKey) {
                CypherCacheFlushingMonitor.class.cacheFlushDetected((CypherCacheFlushingMonitor)this, (Object)justBeforeKey);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor.class.cacheHit((CypherCacheHitMonitor)this, (Object)key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor.class.cacheMiss((CypherCacheHitMonitor)this, (Object)key);
            }

            public void cacheDiscard(String ignored, String query) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Discarded stale query from the query cache: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor.class.$init$((CypherCacheHitMonitor)this);
                CypherCacheFlushingMonitor.class.$init$((CypherCacheFlushingMonitor)this);
            }
        }, new String[0]);
        this.executionMonitor = (QueryExecutionMonitor)this.kernelMonitors().newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.org$neo4j$cypher$internal$ExecutionEngine$$cacheAccessor = new MonitoringCacheAccessor((CypherCacheHitMonitor)this.org$neo4j$cypher$internal$ExecutionEngine$$cacheMonitor());
        this.preParsedQueries = new LRUCache(this.org$neo4j$cypher$internal$ExecutionEngine$$getPlanCacheSize());
        this.org$neo4j$cypher$internal$ExecutionEngine$$parsedQueries = new LRUCache(this.org$neo4j$cypher$internal$ExecutionEngine$$getPlanCacheSize());
        this.javaValues = new JavaResultValueConverter((Function1)isGraphKernelResultValue$.MODULE$);
        this.txBridge = (ThreadToStatementContextBridge)graph.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }
}

