/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import org.neo4j.cypher.internal.CypherRuntime;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.ExecutionPlanWithNotifications;
import org.neo4j.cypher.internal.LogicalQuery;
import org.neo4j.cypher.internal.RuntimeContext;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.UnknownRuntime;
import org.neo4j.cypher.internal.options.CypherRuntimeOption;
import org.neo4j.cypher.internal.options.CypherRuntimeOption$default$;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.exceptions.CantCompileQueryException;
import org.neo4j.exceptions.RuntimeUnsupportedException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.notifications.RuntimeUnsupportedNotification;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001B\u0005\u000b\u0001MA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\to\u0001\u0011\t\u0011)A\u0005q!)a\b\u0001C\u0001\u007f!)1\t\u0001C!\t\")Q\n\u0001C!\u001d\")!\u000b\u0001C\u0005'\")A\f\u0001C!;\"9\u00111\u0001\u0001\u0005\n\u0005\u0015!a\u0004$bY2\u0014\u0017mY6Sk:$\u0018.\\3\u000b\u0005-a\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00055q\u0011AB2za\",'O\u0003\u0002\u0010!\u0005)a.Z85U*\t\u0011#A\u0002pe\u001e\u001c\u0001!\u0006\u0002\u0015CM\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\raRdH\u0007\u0002\u0015%\u0011aD\u0003\u0002\u000e\u0007f\u0004\b.\u001a:Sk:$\u0018.\\3\u0011\u0005\u0001\nC\u0002\u0001\u0003\u0006E\u0001\u0011\ra\t\u0002\b\u0007>sE+\u0012-U#\t!s\u0005\u0005\u0002\u0017K%\u0011ae\u0006\u0002\b\u001d>$\b.\u001b8h!\ta\u0002&\u0003\u0002*\u0015\tq!+\u001e8uS6,7i\u001c8uKb$\u0018\u0001\u0003:v]RLW.Z:\u0011\u00071\"4D\u0004\u0002.e9\u0011a&M\u0007\u0002_)\u0011\u0001GE\u0001\u0007yI|w\u000e\u001e \n\u0003aI!aM\f\u0002\u000fA\f7m[1hK&\u0011QG\u000e\u0002\u000b\u0013:$W\r_3e'\u0016\f(BA\u001a\u0018\u0003A\u0011X-];fgR,GMU;oi&lW\r\u0005\u0002:y5\t!H\u0003\u0002<\u0015\u00059q\u000e\u001d;j_:\u001c\u0018BA\u001f;\u0005M\u0019\u0015\u0010\u001d5feJ+h\u000e^5nK>\u0003H/[8o\u0003\u0019a\u0014N\\5u}Q\u0019\u0001)\u0011\"\u0011\u0007q\u0001q\u0004C\u0003+\u0007\u0001\u00071\u0006C\u00038\u0007\u0001\u0007\u0001(\u0001\u0003oC6,W#A#\u0011\u0005\u0019SeBA$I!\tqs#\u0003\u0002J/\u00051\u0001K]3eK\u001aL!a\u0013'\u0003\rM#(/\u001b8h\u0015\tIu#\u0001\u000ed_J\u0014Xm\u001d9p]\u0012Lgn\u001a*v]RLW.Z(qi&|g.F\u0001P!\r1\u0002\u000bO\u0005\u0003#^\u0011aa\u00149uS>t\u0017a\u00059vE2L7mQ1o]>$8i\\7qS2,GC\u0001\u0013U\u0011\u0015)f\u00011\u0001W\u0003Ey'/[4j]\u0006dW\t_2faRLwN\u001c\t\u0003/jk\u0011\u0001\u0017\u0006\u00033:\t!\"\u001a=dKB$\u0018n\u001c8t\u0013\tY\u0006LA\rDC:$8i\\7qS2,\u0017+^3ss\u0016C8-\u001a9uS>t\u0017aE2p[BLG.\u001a+p\u000bb,7-\u001e;bE2,G\u0003\u00020bM\"\u0004\"\u0001H0\n\u0005\u0001T!!D#yK\u000e,H/[8o!2\fg\u000eC\u0003c\u000f\u0001\u00071-\u0001\u0007m_\u001eL7-\u00197Rk\u0016\u0014\u0018\u0010\u0005\u0002\u001dI&\u0011QM\u0003\u0002\r\u0019><\u0017nY1m#V,'/\u001f\u0005\u0006O\u001e\u0001\raH\u0001\bG>tG/\u001a=u\u0011\u0015Iw\u00011\u0001k\u00031!\u0017\r^1cCN,Wj\u001c3f!\tYgP\u0004\u0002mw:\u0011Q\u000e\u001f\b\u0003]Vt!a\\:\u000f\u0005A\u0014hB\u0001\u0018r\u0013\u0005\t\u0012BA\b\u0011\u0013\t!h\"\u0001\u0004lKJtW\r\\\u0005\u0003m^\fA![7qY*\u0011AOD\u0005\u0003sj\fQ!];fefT!A^<\n\u0005ql\u0018\u0001\u0006+sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DHO\u0003\u0002zu&\u0019q0!\u0001\u0003\u0019\u0011\u000bG/\u00192bg\u0016lu\u000eZ3\u000b\u0005ql\u0018a\u0003:v]RLW.Z\"p]\u001a$2!RA\u0004\u0011\u0019\tI\u0001\u0003a\u00017\u00059!/\u001e8uS6,\u0007")
public class FallbackRuntime<CONTEXT extends RuntimeContext>
implements CypherRuntime<CONTEXT> {
    private final IndexedSeq<CypherRuntime<CONTEXT>> runtimes;
    private final CypherRuntimeOption requestedRuntime;

    @Override
    public String name() {
        return "fallback";
    }

    @Override
    public Option<CypherRuntimeOption> correspondingRuntimeOption() {
        return this.runtimes.collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends CypherRuntime<CONTEXT>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.correspondingRuntimeOption().isDefined()) {
                    return (B1)A1.correspondingRuntimeOption().get();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(CypherRuntime<CONTEXT> x1) {
                CypherRuntime<CONTEXT> cypherRuntime = x1;
                return cypherRuntime.correspondingRuntimeOption().isDefined();
            }
        });
    }

    private Nothing$ publicCannotCompile(CantCompileQueryException originalException) {
        throw RuntimeUnsupportedException.wrapError((CantCompileQueryException)originalException);
    }

    @Override
    public ExecutionPlan compileToExecutable(LogicalQuery logicalQuery, CONTEXT context, TransactionalContext.DatabaseMode databaseMode) {
        RecordingNotificationLogger logger = new RecordingNotificationLogger();
        Tuple2 failedAttempt = null;
        Throwable lastException = null;
        for (int i = 0; i < this.runtimes.length(); ++i) {
            CypherRuntime runtime = (CypherRuntime)this.runtimes.apply(i);
            if (failedAttempt != null) {
                CypherRuntime cypherRuntime = runtime;
                SchemaCommandRuntime$ schemaCommandRuntime$ = SchemaCommandRuntime$.MODULE$;
                if (cypherRuntime == null ? schemaCommandRuntime$ != null : !cypherRuntime.equals(schemaCommandRuntime$)) {
                    Tuple2 tuple2 = failedAttempt;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    CypherRuntime failingRuntime = (CypherRuntime)tuple2._1();
                    String message = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)failingRuntime, (Object)message);
                    CypherRuntime failingRuntime2 = (CypherRuntime)tuple22._1();
                    String message2 = (String)tuple22._2();
                    logger.log((InternalNotification)new RuntimeUnsupportedNotification(this.runtimeConf(failingRuntime2), this.runtimeConf(runtime), message2));
                    failedAttempt = null;
                }
            }
            try {
                ExecutionPlan plan = runtime.compileToExecutable(logicalQuery, context, databaseMode);
                Set notifications = logger.notifications();
                ExecutionPlan notifiedPlan = notifications.isEmpty() ? plan : new ExecutionPlanWithNotifications(plan, (Set<InternalNotification>)notifications);
                return notifiedPlan;
            }
            catch (CantCompileQueryException e) {
                lastException = e;
                CypherRuntime cypherRuntime = runtime;
                SchemaCommandRuntime$ schemaCommandRuntime$ = SchemaCommandRuntime$.MODULE$;
                if (!(cypherRuntime == null ? schemaCommandRuntime$ != null : !cypherRuntime.equals(schemaCommandRuntime$))) continue;
                CypherRuntimeOption cypherRuntimeOption = this.requestedRuntime;
                CypherRuntimeOption$default$ cypherRuntimeOption$default$ = CypherRuntimeOption$default$.MODULE$;
                if (!(cypherRuntimeOption == null ? cypherRuntimeOption$default$ != null : !cypherRuntimeOption.equals(cypherRuntimeOption$default$)) || i >= this.runtimes.length() - 1) continue;
                failedAttempt = new Tuple2((Object)runtime, (Object)e.getMessage());
                continue;
            }
            catch (RuntimeUnsupportedException e) {
                throw e;
            }
            catch (Exception e) {
                lastException = e;
                ((RuntimeContext)context).log().debug("Runtime " + runtime.getClass().getSimpleName() + " failed to compile query " + logicalQuery.queryText(), (Throwable)e);
            }
        }
        Throwable throwable = lastException;
        if (throwable instanceof CantCompileQueryException) {
            CantCompileQueryException cantCompileQueryException = (CantCompileQueryException)throwable;
            throw this.publicCannotCompile(cantCompileQueryException);
        }
        throw throwable;
    }

    private String runtimeConf(CypherRuntime<CONTEXT> runtime) {
        CypherRuntime cypherRuntime = runtime;
        if (cypherRuntime instanceof UnknownRuntime) {
            UnknownRuntime unknownRuntime = (UnknownRuntime)cypherRuntime;
            String requestedRuntime = unknownRuntime.requestedRuntime();
            return "runtime=" + requestedRuntime;
        }
        return (String)runtime.correspondingRuntimeOption().map((Function1 & Serializable)x$2 -> x$2.renderExplicit()).getOrElse((Function0 & Serializable)() -> "runtime=" + runtime.name());
    }

    public FallbackRuntime(IndexedSeq<CypherRuntime<CONTEXT>> runtimes, CypherRuntimeOption requestedRuntime) {
        this.runtimes = runtimes;
        this.requestedRuntime = requestedRuntime;
    }
}

