/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.frontend.phases.ProcedureSignature;
import org.neo4j.cypher.internal.frontend.phases.QualifiedName;
import org.neo4j.cypher.internal.frontend.phases.QueryLanguage;
import org.neo4j.cypher.internal.frontend.phases.QueryLanguage$;
import org.neo4j.cypher.internal.frontend.phases.UserFunctionSignature;
import org.neo4j.cypher.internal.logical.plans.CanGetValue$;
import org.neo4j.cypher.internal.logical.plans.DoNotGetValue$;
import org.neo4j.cypher.internal.logical.plans.GetValueFromIndexBehavior;
import org.neo4j.cypher.internal.planner.spi.DatabaseMode$;
import org.neo4j.cypher.internal.planner.spi.EventuallyConsistent$;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.IndexOrderCapability;
import org.neo4j.cypher.internal.planner.spi.InstrumentedGraphStatistics;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.planner.spi.TokenIndexDescriptor;
import org.neo4j.cypher.internal.runtime.QueryTransactionalContext;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundReadTokenContext;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionalContextWrapper;
import org.neo4j.cypher.internal.spi.IndexDescriptorCompatibility;
import org.neo4j.cypher.internal.spi.TransactionBoundPlanContext$;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.cypher.internal.util.PropertyKeyId$;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLog;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r}u!B!C\u0011\u0003ie!B(C\u0011\u0003\u0001\u0006\"B,\u0002\t\u0003A\u0006\"B-\u0002\t\u0003Q\u0006b\u0002Bu\u0003\u0011\u000511\u0010\u0005\b\u0007\u000f\tA\u0011ABL\r\u0011y%\t\u0001/\t\u0011=4!\u0011!Q\u0001\nAD\u0001b\u001d\u0004\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\tu\u001a\u0011\t\u0011)A\u0005w\"AaP\u0002B\u0001B\u0003%q\u0010\u0003\u0004X\r\u0011\u0005\u0011q\u0001\u0005\b\u0003#1A\u0011IA\n\u0011\u001d\tiD\u0002C!\u0003\u007fAq!!\u0012\u0007\t\u0003\n9\u0005C\u0004\u0002L\u0019!\t%!\u0014\t\u000f\u0005Ec\u0001\"\u0011\u0002T!9\u0011q\u000b\u0004\u0005B\u0005e\u0003bBA/\r\u0011%\u0011q\f\u0005\b\u0003w2A\u0011BA?\u0011\u001d\t\u0019I\u0002C!\u0003\u000bCq!a\"\u0007\t\u0003\nI\tC\u0004\u0002\u0014\u001a!\t%!&\t\u000f\u0005ee\u0001\"\u0011\u0002\u001c\"9\u0011Q\u0018\u0004\u0005B\u0005}\u0006bBAc\r\u0011\u0005\u0013q\u0019\u0005\b\u0003\u001b4A\u0011IAh\u0011\u001d\t9N\u0002C!\u00033Dq!a8\u0007\t\u0003\n\t\u000fC\u0004\u0002h\u001a!I!!;\t\u000f\u0005Eh\u0001\"\u0003\u0002t\"9\u00111 \u0004\u0005\n\u0005u\bb\u0002B\u0007\r\u0011\u0005#q\u0002\u0005\b\u0005/1A\u0011\tB\r\u0011\u001d\u0011yB\u0002C!\u0005CAqAa\n\u0007\t\u0003\u0012I\u0003C\u0004\u00030\u0019!\tE!\r\t\u000f\t]b\u0001\"\u0011\u0003:!9!q\b\u0004\u0005\n\t\u0005\u0003b\u0002B&\r\u0011%!Q\n\u0005\b\u0005O2A\u0011\tB5\u0011\u001d\u0011YG\u0002C!\u0005SBqA!\u001c\u0007\t\u0003\u0012y\u0007C\u0004\u0003v\u0019!\tEa\u001e\t\u000f\t\u0005e\u0001\"\u0003\u0003\u0004\"9!\u0011\u0013\u0004\u0005B\tM\u0005b\u0002BM\r\u0011\u0005#1\u0014\u0005\b\u0005?3A\u0011\tBQ\u0011\u001d\u0011\u0019K\u0002C!\u0005KCqA!/\u0007\t\u0003\u0012Y\fC\u0004\u0003H\u001a!\tE!3\t\u000f\tEg\u0001\"\u0011\u0003T\"I!q\u001b\u0004C\u0002\u0013\u0005#\u0011\u001c\u0005\b\u000574\u0001\u0015!\u0003|\u0011%\u0011iN\u0002b\u0001\n\u0003\u0012y\u000e\u0003\u0005\u0003h\u001a\u0001\u000b\u0011\u0002Bq\u0011\u001d\u0011IO\u0002C!\u0005WDqaa\u0002\u0007\t\u0003\u001aI\u0001C\u0004\u0004\u0016\u0019!\tea\u0006\t\u000f\rea\u0001\"\u0011\u0004\u001c!91Q\u0004\u0004\u0005B\r}\u0001bBB\u0014\r\u0011\u00053\u0011\u0006\u0005\b\u0007[1A\u0011IB\u0018\u0011\u001d\u00199F\u0002C!\u00073Bqaa\u0017\u0007\t\u0003\u001ai&A\u000eUe\u0006t7/Y2uS>t'i\\;oIBc\u0017M\\\"p]R,\u0007\u0010\u001e\u0006\u0003\u0007\u0012\u000b1a\u001d9j\u0015\t)e)\u0001\u0005j]R,'O\\1m\u0015\t9\u0005*\u0001\u0004dsBDWM\u001d\u0006\u0003\u0013*\u000bQA\\3pi)T\u0011aS\u0001\u0004_J<7\u0001\u0001\t\u0003\u001d\u0006i\u0011A\u0011\u0002\u001c)J\fgn]1di&|gNQ8v]\u0012\u0004F.\u00198D_:$X\r\u001f;\u0014\u0005\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u001b\u0006)\u0011\r\u001d9msRI1l!\u001a\u0004h\r%4\u0011\u0010\t\u0003\u001d\u001a\u0019BAB/fYB\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\fS:$XM\u001d9sKR,GM\u0003\u0002c\t\u00069!/\u001e8uS6,\u0017B\u00013`\u0005\u0001\"&/\u00198tC\u000e$\u0018n\u001c8C_VtGMU3bIR{7.\u001a8D_:$X\r\u001f;\u0011\u0005\u0019TW\"A4\u000b\u0005\rC'BA5E\u0003\u001d\u0001H.\u00198oKJL!a[4\u0003\u0017Ac\u0017M\\\"p]R,\u0007\u0010\u001e\t\u0003\u001d6L!A\u001c\"\u00039%sG-\u001a=EKN\u001c'/\u001b9u_J\u001cu.\u001c9bi&\u0014\u0017\u000e\\5us\u0006\u0011Ao\u0019\t\u0003=FL!A]0\u00037Q\u0013\u0018M\\:bGRLwN\\1m\u0007>tG/\u001a=u/J\f\u0007\u000f]3s\u0003\u0019awnZ4feB\u0011Q\u000f_\u0007\u0002m*\u0011q\u000fR\u0001\u0005kRLG.\u0003\u0002zm\nQ\u0012J\u001c;fe:\fGNT8uS\u001aL7-\u0019;j_:dunZ4fe\u0006yqM]1qQN#\u0018\r^5ti&\u001c7\u000f\u0005\u0002gy&\u0011Qp\u001a\u0002\u001c\u0013:\u001cHO];nK:$X\rZ$sCBD7\u000b^1uSN$\u0018nY:\u0002\u001b\rL\b\u000f[3s-\u0016\u00148/[8o!\u0011\t\t!a\u0001\u000e\u0003\u0011K1!!\u0002E\u00055\u0019\u0015\u0010\u001d5feZ+'o]5p]RI1,!\u0003\u0002\f\u00055\u0011q\u0002\u0005\u0006_.\u0001\r\u0001\u001d\u0005\u0006g.\u0001\r\u0001\u001e\u0005\u0006u.\u0001\ra\u001f\u0005\u0006}.\u0001\ra`\u0001\u0018e\u0006tw-Z%oI\u0016DXm]$fi\u001a{'\u000fT1cK2$B!!\u0006\u00024A1\u0011qCA\u0014\u0003[qA!!\u0007\u0002$9!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 1\u000ba\u0001\u0010:p_Rt\u0014\"\u0001+\n\u0007\u0005\u00152+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00121\u0006\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011QE*\u0011\u0007\u0019\fy#C\u0002\u00022\u001d\u0014q\"\u00138eKb$Um]2sSB$xN\u001d\u0005\b\u0003ka\u0001\u0019AA\u001c\u0003\u001da\u0017MY3m\u0013\u0012\u00042AUA\u001d\u0013\r\tYd\u0015\u0002\u0004\u0013:$\u0018!\u0007:b]\u001e,\u0017J\u001c3fq\u0016\u001cx)\u001a;G_J\u0014V\r\u001c+za\u0016$B!!\u0006\u0002B!9\u00111I\u0007A\u0002\u0005]\u0012!\u0003:fYRK\b/Z%e\u0003Y!X\r\u001f;J]\u0012,\u00070Z:HKR4uN\u001d'bE\u0016dG\u0003BA\u000b\u0003\u0013Bq!!\u000e\u000f\u0001\u0004\t9$\u0001\ruKb$\u0018J\u001c3fq\u0016\u001cx)\u001a;G_J\u0014V\r\u001c+za\u0016$B!!\u0006\u0002P!9\u00111I\bA\u0002\u0005]\u0012a\u00069pS:$\u0018J\u001c3fq\u0016\u001cx)\u001a;G_Jd\u0015MY3m)\u0011\t)\"!\u0016\t\u000f\u0005U\u0002\u00031\u0001\u00028\u0005I\u0002o\\5oi&sG-\u001a=fg\u001e+GOR8s%\u0016dG+\u001f9f)\u0011\t)\"a\u0017\t\u000f\u0005\r\u0013\u00031\u0001\u00028\u0005\u0011\u0012N\u001c3fq\u0016\u001cx)\u001a;G_Jd\u0015MY3m)\u0019\t)\"!\u0019\u0002d!9\u0011Q\u0007\nA\u0002\u0005]\u0002bBA3%\u0001\u0007\u0011qM\u0001\nS:$W\r\u001f+za\u0016\u0004RAUA5\u0003[J1!a\u001bT\u0005\u0019y\u0005\u000f^5p]B!\u0011qNA<\u001b\t\t\tH\u0003\u0003\u0002t\u0005U\u0014AB:dQ\u0016l\u0017M\u0003\u0002F\u0011&!\u0011\u0011PA9\u0005%Ie\u000eZ3y)f\u0004X-\u0001\u000bj]\u0012,\u00070Z:HKR4uN\u001d*fYRK\b/\u001a\u000b\u0007\u0003+\ty(!!\t\u000f\u0005\r3\u00031\u0001\u00028!9\u0011QM\nA\u0002\u0005\u001d\u0014!\u00069s_B,'\u000f^=J]\u0012,\u00070Z:HKR\fE\u000e\u001c\u000b\u0003\u0003+\t1#\u001b8eKb,\u00050[:ug\u001a{'\u000fT1cK2$B!a#\u0002\u0012B\u0019!+!$\n\u0007\u0005=5KA\u0004C_>dW-\u00198\t\u000f\u0005UR\u00031\u0001\u00028\u0005)\u0012N\u001c3fq\u0016C\u0018n\u001d;t\r>\u0014(+\u001a7UsB,G\u0003BAF\u0003/Cq!a\u0011\u0017\u0001\u0004\t9$A\u0011uKb$\u0018J\u001c3fq\u001e+GOR8s\u0019\u0006\u0014W\r\\!oIB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002\u001e\u0006}\u00151\u0017\t\u0006%\u0006%\u0014Q\u0006\u0005\b\u0003C;\u0002\u0019AAR\u0003%a\u0017MY3m\u001d\u0006lW\r\u0005\u0003\u0002&\u00065f\u0002BAT\u0003S\u00032!a\u0007T\u0013\r\tYkU\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0016\u0011\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-6\u000bC\u0004\u00026^\u0001\r!a.\u0002\u0019A\u0014x\u000e]3sif\\U-_:\u0011\r\u0005]\u0011\u0011XAR\u0013\u0011\tY,a\u000b\u0003\u0007M+\u0017/\u0001\u0012sC:<W-\u00138eKb<U\r\u001e$pe2\u000b'-\u001a7B]\u0012\u0004&o\u001c9feRLWm\u001d\u000b\u0007\u0003;\u000b\t-a1\t\u000f\u0005\u0005\u0006\u00041\u0001\u0002$\"9\u0011Q\u0017\rA\u0002\u0005]\u0016A\t9pS:$\u0018J\u001c3fq\u001e+GOR8s\u0019\u0006\u0014W\r\\!oIB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002\u001e\u0006%\u00171\u001a\u0005\b\u0003CK\u0002\u0019AAR\u0011\u001d\t),\u0007a\u0001\u0003o\u000b1\u0005^3yi&sG-\u001a=HKR4uN\u001d*fYRK\b/Z!oIB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002\u001e\u0006E\u0017Q\u001b\u0005\b\u0003'T\u0002\u0019AAR\u0003-\u0011X\r\u001c+za\u0016t\u0015-\\3\t\u000f\u0005U&\u00041\u0001\u00028\u0006!#/\u00198hK&sG-\u001a=HKR4uN\u001d*fYRK\b/Z!oIB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002\u001e\u0006m\u0017Q\u001c\u0005\b\u0003'\\\u0002\u0019AAR\u0011\u001d\t)l\u0007a\u0001\u0003o\u000bA\u0005]8j]RLe\u000eZ3y\u000f\u0016$hi\u001c:SK2$\u0016\u0010]3B]\u0012\u0004&o\u001c9feRLWm\u001d\u000b\u0007\u0003;\u000b\u0019/!:\t\u000f\u0005MG\u00041\u0001\u0002$\"9\u0011Q\u0017\u000fA\u0002\u0005]\u0016!H5oI\u0016Dx)\u001a;G_Jd\u0015MY3m\u0003:$\u0007K]8qKJ$\u0018.Z:\u0015\u0011\u0005u\u00151^Aw\u0003_Dq!!\u001a\u001e\u0001\u0004\ti\u0007C\u0004\u0002\"v\u0001\r!a)\t\u000f\u0005UV\u00041\u0001\u00028\u0006y\u0012N\u001c3fq\u001e+GOR8s%\u0016dG+\u001f9f\u0003:$\u0007K]8qKJ$\u0018.Z:\u0015\u0011\u0005u\u0015Q_A|\u0003sDq!!\u001a\u001f\u0001\u0004\ti\u0007C\u0004\u0002Tz\u0001\r!a)\t\u000f\u0005Uf\u00041\u0001\u00028\u0006Y\u0012N\u001c3fq\u001e+GOR8s'\u000eDW-\\1EKN\u001c'/\u001b9u_J$B!a@\u0003\fQ!\u0011Q\u0014B\u0001\u0011\u001d\u0011\u0019a\ba\u0001\u0005\u000b\t!\u0002Z3tGJL\u0007\u000f^8s!\u0011\tyGa\u0002\n\t\t%\u0011\u0011\u000f\u0002\u0011'\u000eDW-\\1EKN\u001c'/\u001b9u_JDq!!\u001a \u0001\u0004\ti'\u0001\u0013uKb$\u0018J\u001c3fq\u0016C\u0018n\u001d;t\r>\u0014H*\u00192fY\u0006sG\r\u0015:pa\u0016\u0014H/[3t)\u0019\tYI!\u0005\u0003\u0014!9\u0011\u0011\u0015\u0011A\u0002\u0005\r\u0006b\u0002B\u000bA\u0001\u0007\u0011qW\u0001\faJ|\u0007/\u001a:us.+\u00170A\u0013sC:<W-\u00138eKb,\u00050[:ug\u001a{'\u000fT1cK2\fe\u000e\u001a)s_B,'\u000f^5fgR1\u00111\u0012B\u000e\u0005;Aq!!)\"\u0001\u0004\t\u0019\u000bC\u0004\u0003\u0016\u0005\u0002\r!a.\u0002KA|\u0017N\u001c;J]\u0012,\u00070\u0012=jgR\u001chi\u001c:MC\n,G.\u00118e!J|\u0007/\u001a:uS\u0016\u001cHCBAF\u0005G\u0011)\u0003C\u0004\u0002\"\n\u0002\r!a)\t\u000f\tU!\u00051\u0001\u00028\u00061C/\u001a=u\u0013:$W\r_#ySN$8OR8s%\u0016dG+\u001f9f\u0003:$\u0007K]8qKJ$\u0018.Z:\u0015\r\u0005-%1\u0006B\u0017\u0011\u001d\t\u0019n\ta\u0001\u0003GCqA!\u0006$\u0001\u0004\t9,A\u0014sC:<W-\u00138eKb,\u00050[:ug\u001a{'OU3m)f\u0004X-\u00118e!J|\u0007/\u001a:uS\u0016\u001cHCBAF\u0005g\u0011)\u0004C\u0004\u0002T\u0012\u0002\r!a)\t\u000f\tUA\u00051\u0001\u00028\u00069\u0003o\\5oi&sG-\u001a=Fq&\u001cHo\u001d$peJ+G\u000eV=qK\u0006sG\r\u0015:pa\u0016\u0014H/[3t)\u0019\tYIa\u000f\u0003>!9\u00111[\u0013A\u0002\u0005\r\u0006b\u0002B\u000bK\u0001\u0007\u0011qW\u0001\u000fO\u0016$xJ\u001c7j]\u0016Le\u000eZ3y)\u0011\tiJa\u0011\t\u000f\t\u0015c\u00051\u0001\u0003H\u0005I!/\u001a4fe\u0016t7-\u001a\t\u0005\u0003_\u0012I%\u0003\u0003\u00022\u0005E\u0014aF4fiR{7.\u001a8J]\u0012,\u0007\u0010R3tGJL\u0007\u000f^8s)\u0011\u0011yEa\u0016\u0011\u000bI\u000bIG!\u0015\u0011\u0007\u0019\u0014\u0019&C\u0002\u0003V\u001d\u0014A\u0003V8lK:Le\u000eZ3y\t\u0016\u001c8M]5qi>\u0014\bb\u0002B-O\u0001\u0007!1L\u0001\bS:$W\r_3t!\u0019\u0011iF!\u001a\u0003H5\u0011!q\f\u0006\u0004o\n\u0005$B\u0001B2\u0003\u0011Q\u0017M^1\n\t\u0005%\"qL\u0001\u000f]>$W\rV8lK:Le\u000eZ3y+\t\u0011y%\u0001\fsK2\fG/[8og\"L\u0007\u000fV8lK:Le\u000eZ3y\u0003\tB\u0017m\u001d(pI\u0016\u0004&o\u001c9feRLX\t_5ti\u0016t7-Z\"p]N$(/Y5oiR1\u00111\u0012B9\u0005gBq!!)+\u0001\u0004\t\u0019\u000bC\u0004\u0003\u0016)\u0002\r!a)\u0002Q\u001d,GOT8eKB\u0013x\u000e]3si&,7oV5uQ\u0016C\u0018n\u001d;f]\u000e,7i\u001c8tiJ\f\u0017N\u001c;\u0015\t\te$q\u0010\t\u0007\u0003K\u0013Y(a)\n\t\tu\u0014\u0011\u0017\u0002\u0004'\u0016$\bbBAQW\u0001\u0007\u00111U\u0001&O\u0016$\bK]8qKJ$\u0018.Z:Ge>lW\t_5ti\u0016t7-Z\"p]N$(/Y5oiN$BA!\u001f\u0003\u0006\"9!q\u0011\u0017A\u0002\t%\u0015aC2p]N$(/Y5oiN\u0004b!a\u0006\u0002(\t-\u0005\u0003BA8\u0005\u001bKAAa$\u0002r\t!2i\u001c8tiJ\f\u0017N\u001c;EKN\u001c'/\u001b9u_J\f!\u0006[1t%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d)s_B,'\u000f^=Fq&\u001cH/\u001a8dK\u000e{gn\u001d;sC&tG\u000f\u0006\u0004\u0002\f\nU%q\u0013\u0005\b\u0003'l\u0003\u0019AAR\u0011\u001d\u0011)\"\fa\u0001\u0003G\u000b\u0001gZ3u%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d)s_B,'\u000f^5fg^KG\u000f[#ySN$XM\\2f\u0007>t7\u000f\u001e:bS:$H\u0003\u0002B=\u0005;Cq!a5/\u0001\u0004\t\u0019+\u0001\u0013hKR\u0004&o\u001c9feRLWm],ji\",\u00050[:uK:\u001cWmQ8ogR\u0014\u0018-\u001b8u+\t\u0011I(A\u000fiCNtu\u000eZ3Qe>\u0004XM\u001d;z)f\u0004XmQ8ogR\u0014\u0018-\u001b8u)!\tYIa*\u0003*\n-\u0006bBAQa\u0001\u0007\u00111\u0015\u0005\b\u0005+\u0001\u0004\u0019AAR\u0011\u001d\u0011i\u000b\ra\u0001\u0005_\u000b!bY=qQ\u0016\u0014H+\u001f9f!\u0011\u0011\tL!.\u000e\u0005\tM&\u0002\u0002BD\u0003cJAAa.\u00034\ny1k\u00195f[\u00064\u0016\r\\;f)f\u0004X-A\u0012hKRtu\u000eZ3Qe>\u0004XM\u001d;jKN<\u0016\u000e\u001e5UsB,7i\u001c8tiJ\f\u0017N\u001c;\u0015\t\tu&Q\u0019\t\t\u0003K\u0013y,a)\u0003D&!!\u0011YAY\u0005\ri\u0015\r\u001d\t\u0007\u0003/\tILa,\t\u000f\u0005\u0005\u0016\u00071\u0001\u0002$\u0006)\u0003.Y:SK2\fG/[8og\"L\u0007\u000f\u0015:pa\u0016\u0014H/\u001f+za\u0016\u001cuN\\:ue\u0006Lg\u000e\u001e\u000b\t\u0003\u0017\u0013YM!4\u0003P\"9\u00111\u001b\u001aA\u0002\u0005\r\u0006b\u0002B\u000be\u0001\u0007\u00111\u0015\u0005\b\u0005[\u0013\u0004\u0019\u0001BX\u0003-:W\r\u001e*fY\u0006$\u0018n\u001c8tQ&\u0004\bK]8qKJ$\u0018.Z:XSRDG+\u001f9f\u0007>t7\u000f\u001e:bS:$H\u0003\u0002B_\u0005+Dq!a54\u0001\u0004\t\u0019+\u0001\u0006ti\u0006$\u0018n\u001d;jGN,\u0012a_\u0001\fgR\fG/[:uS\u000e\u001c\b%A\rmCN$8i\\7nSR$X\r\u001a+y\u0013\u0012\u0004&o\u001c<jI\u0016\u0014XC\u0001Bq!\u0011\t\tAa9\n\u0007\t\u0015HIA\rMCN$8i\\7nSR$X\r\u001a+y\u0013\u0012\u0004&o\u001c<jI\u0016\u0014\u0018A\u00077bgR\u001cu.\\7jiR,G\r\u0016=JIB\u0013xN^5eKJ\u0004\u0013A\u00059s_\u000e,G-\u001e:f'&<g.\u0019;ve\u0016$BA!<\u0003~B!!q\u001eB}\u001b\t\u0011\tP\u0003\u0003\u0003t\nU\u0018A\u00029iCN,7OC\u0002\u0003x\u0012\u000b\u0001B\u001a:p]R,g\u000eZ\u0005\u0005\u0005w\u0014\tP\u0001\nQe>\u001cW\rZ;sKNKwM\\1ukJ,\u0007b\u0002B\u0000q\u0001\u00071\u0011A\u0001\u0005]\u0006lW\r\u0005\u0003\u0003p\u000e\r\u0011\u0002BB\u0003\u0005c\u0014Q\"U;bY&4\u0017.\u001a3OC6,\u0017!\u00054v]\u000e$\u0018n\u001c8TS\u001et\u0017\r^;sKR!11BB\n!\u0015\u0011\u0016\u0011NB\u0007!\u0011\u0011yoa\u0004\n\t\rE!\u0011\u001f\u0002\u0016+N,'OR;oGRLwN\\*jO:\fG/\u001e:f\u0011\u001d\u0011y0\u000fa\u0001\u0007\u0003\t!C\\8uS\u001aL7-\u0019;j_:dunZ4feR\tA/A\tuqN#\u0018\r^3ICN\u001c\u0005.\u00198hKN$\"!a#\u00023A\u0014xnY3ekJ,7+[4oCR,(/\u001a,feNLwN\\\u000b\u0003\u0007C\u00012AUB\u0012\u0013\r\u0019)c\u0015\u0002\u0005\u0019>tw-\u0001\fxSRDgj\u001c;jM&\u001c\u0017\r^5p]2{wmZ3s)\r)71\u0006\u0005\u0007\u0007+i\u0004\u0019\u0001;\u0002\u0019\u0011\fG/\u00192bg\u0016lu\u000eZ3\u0016\u0005\rE\u0002\u0003BB\u001a\u0007#rAa!\u000e\u0004N9!1qGB&\u001d\u0011\u0019Id!\u0013\u000f\t\rm2q\t\b\u0005\u0007{\u0019)E\u0004\u0003\u0004@\r\rc\u0002BA\u000e\u0007\u0003J\u0011aS\u0005\u0003\u0013*K!a\u0012%\n\u0005\u00153\u0015BA5E\u0013\t\u0019\u0005.C\u0002\u0004P\u001d\fA\u0002R1uC\n\f7/Z'pI\u0016LAaa\u0015\u0004V\taA)\u0019;bE\u0006\u001cX-T8eK*\u00191qJ4\u00029M$xN]1hK\"\u000b7\u000f\u0015:pa\u0016\u0014H/_\"pY>\u001c\u0017\r^5p]V\u0011\u00111R\u0001\u000ecV,'/\u001f'b]\u001e,\u0018mZ3\u0016\u0005\r}\u0003\u0003\u0002Bx\u0007CJAaa\u0019\u0003r\ni\u0011+^3ss2\u000bgnZ;bO\u0016DQa\\\u0002A\u0002ADQa]\u0002A\u0002QDqaa\u001b\u0004\u0001\u0004\u0019i'A\u0002m_\u001e\u0004Baa\u001c\u0004v5\u00111\u0011\u000f\u0006\u0004\u0007gB\u0015a\u00027pO\u001eLgnZ\u0005\u0005\u0007o\u001a\tHA\u0006J]R,'O\\1m\u0019><\u0007\"\u0002@\u0004\u0001\u0004yH\u0003\u0003Bw\u0007{\u001a\tja%\t\u000f\r}D\u00011\u0001\u0004\u0002\u0006\u0011A\u000f\u001f\t\u0005\u0007\u0007\u001bi)\u0004\u0002\u0004\u0006*!1qQBE\u0003\r\t\u0007/\u001b\u0006\u0004\u0007\u0017C\u0015AB6fe:,G.\u0003\u0003\u0004\u0010\u000e\u0015%!E&fe:,G\u000e\u0016:b]N\f7\r^5p]\"9!q \u0003A\u0002\r\u0005\u0001BBBK\t\u0001\u0007q0A\u0004wKJ\u001c\u0018n\u001c8\u0015\u0011\r-1\u0011TBN\u0007;Cqaa \u0006\u0001\u0004\u0019\t\tC\u0004\u0003\u0000\u0016\u0001\ra!\u0001\t\r\rUU\u00011\u0001\u0000\u0001")
public class TransactionBoundPlanContext
extends TransactionBoundReadTokenContext
implements PlanContext,
IndexDescriptorCompatibility {
    private final TransactionalContextWrapper tc;
    private final InternalNotificationLogger logger;
    private final InstrumentedGraphStatistics graphStatistics;
    private final CypherVersion cypherVersion;
    private final InstrumentedGraphStatistics statistics;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;

    public static TransactionBoundPlanContext apply(TransactionalContextWrapper tc, InternalNotificationLogger logger, InternalLog log, CypherVersion cypherVersion) {
        return TransactionBoundPlanContext$.MODULE$.apply(tc, logger, log, cypherVersion);
    }

    @Override
    public org.neo4j.cypher.internal.planner.spi.IndexBehaviour kernelToCypher(IndexBehaviour behaviour) {
        return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, behaviour);
    }

    @Override
    public Option<IndexDescriptor.IndexType> kernelToCypher(IndexType indexType) {
        return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, indexType);
    }

    @Override
    public SchemaDescriptor cypherToKernelSchema(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
        return IndexDescriptorCompatibility.cypherToKernelSchema$(this, index);
    }

    @Override
    public IndexType cypherToKernel(IndexDescriptor.IndexType indexType) {
        return IndexDescriptorCompatibility.cypherToKernel$(this, indexType);
    }

    @Override
    public Option<LabelSchemaDescriptor> toLabelSchemaDescriptor(TransactionBoundReadTokenContext tc, String labelName, Seq<String> propertyKeys) {
        return IndexDescriptorCompatibility.toLabelSchemaDescriptor$(this, tc, labelName, propertyKeys);
    }

    @Override
    public Option<RelationTypeSchemaDescriptor> toRelTypeSchemaDescriptor(TransactionBoundReadTokenContext tc, String relTypeName, Seq<String> propertyKeys) {
        return IndexDescriptorCompatibility.toRelTypeSchemaDescriptor$(this, tc, relTypeName, propertyKeys);
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.RANGE));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.RANGE));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.TEXT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.TEXT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.POINT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.POINT));
    }

    private Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexesGetForLabel(int labelId, Option<IndexType> indexType) {
        Function1 & Serializable intersect;
        Option<IndexType> option = indexType;
        if (option instanceof Some) {
            Some some = (Some)option;
            IndexType it = (IndexType)some.value();
            intersect = (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForLabel$1(it, x$2));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForLabel$2(x$3));
        } else {
            throw new MatchError(option);
        }
        Function1 & Serializable selector = intersect;
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().getLabelIndexesNonLocking(labelId)).asScala().filter((Function1)selector).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    private Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexesGetForRelType(int relTypeId, Option<IndexType> indexType) {
        Function1 & Serializable intersect;
        Option<IndexType> option = indexType;
        if (option instanceof Some) {
            Some some = (Some)option;
            IndexType it = (IndexType)some.value();
            intersect = (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForRelType$1(it, x$4));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForRelType$2(x$5));
        } else {
            throw new MatchError(option);
        }
        Function1 & Serializable selector = intersect;
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().getRelTypeIndexesNonLocking(relTypeId)).asScala().filter((Function1)selector).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> propertyIndexesGetAll() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().indexesGetAllNonLocking()).asScala().flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    public boolean indexExistsForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)None$.MODULE$).nonEmpty();
    }

    public boolean indexExistsForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)None$.MODULE$).nonEmpty();
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.TEXT, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.RANGE, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.POINT, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.TEXT, relTypeName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.RANGE, relTypeName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.POINT, relTypeName, propertyKeys);
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForLabelAndProperties(IndexType indexType, String labelName, Seq<String> propertyKeys) {
        Option<LabelSchemaDescriptor> descriptor2 = this.toLabelSchemaDescriptor(this, labelName, propertyKeys);
        return descriptor2.flatMap((Function1 & Serializable)descriptor -> this.indexGetForSchemaDescriptor(indexType, (SchemaDescriptor)descriptor));
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForRelTypeAndProperties(IndexType indexType, String relTypeName, Seq<String> propertyKeys) {
        Option<RelationTypeSchemaDescriptor> descriptor2 = this.toRelTypeSchemaDescriptor(this, relTypeName, propertyKeys);
        return descriptor2.flatMap((Function1 & Serializable)descriptor -> this.indexGetForSchemaDescriptor(indexType, (SchemaDescriptor)descriptor));
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForSchemaDescriptor(IndexType indexType, SchemaDescriptor descriptor) {
        Iterator itr = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().indexForSchemaNonLocking(descriptor)).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexGetForSchemaDescriptor$1(indexType, x$6))).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
        if (itr.hasNext()) {
            return new Some(itr.next());
        }
        return None$.MODULE$;
    }

    public boolean textIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.textIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean rangeIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.rangeIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean pointIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.pointIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean textIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.textIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    public boolean rangeIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.rangeIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    public boolean pointIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.pointIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> getOnlineIndex(IndexDescriptor reference) {
        Object object;
        block7: {
            try {
                InternalIndexState internalIndexState = this.tc.schemaRead().indexGetStateNonLocking(reference);
                if (InternalIndexState.ONLINE.equals(internalIndexState) && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.intArrayOps(reference.schema().getPropertyIds()))) {
                    CanGetValue$ valueCapability;
                    IndexDescriptor.EntityType$.Node node;
                    int tokenId = reference.schema().getEntityTokenIds()[0];
                    EntityType entityType = reference.schema().entityType();
                    if (EntityType.NODE.equals(entityType)) {
                        node = new IndexDescriptor.EntityType$.Node(new LabelId(tokenId));
                    } else if (EntityType.RELATIONSHIP.equals(entityType)) {
                        node = new IndexDescriptor.EntityType$.Relationship(new RelTypeId(tokenId));
                    } else {
                        throw new MatchError((Object)entityType);
                    }
                    IndexDescriptor.EntityType$.Node entityType2 = node;
                    PropertyKeyId[] properties = (PropertyKeyId[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(reference.schema().getPropertyIds()), (Function1)PropertyKeyId$.MODULE$, ClassTag$.MODULE$.apply(PropertyKeyId.class));
                    boolean isUnique = reference.isUnique();
                    Set behaviours = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])reference.getCapability().behaviours()), (Function1 & Serializable)behaviour -> this.kernelToCypher((IndexBehaviour)behaviour), ClassTag$.MODULE$.apply(org.neo4j.cypher.internal.planner.spi.IndexBehaviour.class))).toSet();
                    IndexOrderCapability.BOTH$ orderCapability = reference.getCapability().supportsOrdering() ? IndexOrderCapability.BOTH$.MODULE$ : IndexOrderCapability.NONE$.MODULE$;
                    Object object2 = valueCapability = reference.getCapability().supportsReturningValues() ? CanGetValue$.MODULE$ : DoNotGetValue$.MODULE$;
                    object = behaviours.contains((Object)EventuallyConsistent$.MODULE$) ? None$.MODULE$ : (isUnique && this.tc.schemaRead().indexGetOwningUniquenessConstraintIdNonLocking(reference) == null ? None$.MODULE$ : this.kernelToCypher(reference.getIndexType()).map(arg_0 -> TransactionBoundPlanContext.$anonfun$getOnlineIndex$2((Product)entityType2, properties, behaviours, (Product)orderCapability, (Product)valueCapability, reference, isUnique, arg_0)));
                    break block7;
                }
                object = None$.MODULE$;
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                object = None$.MODULE$;
            }
        }
        return object;
    }

    private Option<TokenIndexDescriptor> getTokenIndexDescriptor(java.util.Iterator<IndexDescriptor> indexes) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(indexes).asScala().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$getTokenIndexDescriptor$1(this, x$7))).nextOption().map((Function1 & Serializable)kernelIndexDescriptor -> {
            EntityType typ = kernelIndexDescriptor.schema().entityType();
            IndexOrderCapability.BOTH$ orderCapability = kernelIndexDescriptor.getCapability().supportsOrdering() ? IndexOrderCapability.BOTH$.MODULE$ : IndexOrderCapability.NONE$.MODULE$;
            return new TokenIndexDescriptor(typ, (IndexOrderCapability)orderCapability);
        });
    }

    public Option<TokenIndexDescriptor> nodeTokenIndex() {
        return this.getTokenIndexDescriptor(this.tc.schemaRead().indexForSchemaNonTransactional((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_NODE_SCHEMA_DESCRIPTOR));
    }

    public Option<TokenIndexDescriptor> relationshipTokenIndex() {
        return this.getTokenIndexDescriptor(this.tc.schemaRead().indexForSchemaNonTransactional((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_RELATIONSHIP_SCHEMA_DESCRIPTOR));
    }

    public boolean hasNodePropertyExistenceConstraint(String labelName, String propertyKey) {
        boolean bl;
        try {
            int labelId = this.getLabelId(labelName);
            int propertyKeyId = this.getPropertyKeyId(propertyKey);
            bl = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForSchemaNonLocking((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId}))).asScala().filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence())).hasNext();
        }
        catch (KernelException kernelException) {
            bl = false;
        }
        return bl;
    }

    public Set<String> getNodePropertiesWithExistenceConstraint(String labelName) {
        Set<String> set;
        try {
            int labelId = this.getLabelId(labelName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForLabelNonLocking(labelId)).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    private Set<String> getPropertiesFromExistenceConstraints(Iterator<ConstraintDescriptor> constraints) {
        Iterator existsConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence()));
        Set distinctPropertyIds = existsConstraints.flatMap((Function1 & Serializable)x$8 -> Predef$.MODULE$.wrapIntArray(x$8.schema().getPropertyIds())).toSet();
        return (Set)distinctPropertyIds.map((Function1 & Serializable)id -> TransactionBoundPlanContext.$anonfun$getPropertiesFromExistenceConstraints$3(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public boolean hasRelationshipPropertyExistenceConstraint(String relTypeName, String propertyKey) {
        boolean bl;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            int propertyKeyId = this.getPropertyKeyId(propertyKey);
            bl = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForSchemaNonLocking((SchemaDescriptor)SchemaDescriptors.forRelType((int)relTypeId, (int[])new int[]{propertyKeyId}))).asScala().filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence())).hasNext();
        }
        catch (KernelException kernelException) {
            bl = false;
        }
        return bl;
    }

    public Set<String> getRelationshipPropertiesWithExistenceConstraint(String relTypeName) {
        Set<String> set;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForRelationshipTypeNonLocking(relTypeId)).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public Set<String> getPropertiesWithExistenceConstraint() {
        Set<String> set;
        try {
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetAllNonLocking()).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public boolean hasNodePropertyTypeConstraint(String labelName, String propertyKey, SchemaValueType cypherType) {
        SeqOps seqOps;
        Some some;
        Seq seq;
        Option option = this.getNodePropertiesWithTypeConstraint(labelName).get((Object)propertyKey);
        if (option instanceof Some && (seq = (Seq)(some = (Some)option).value()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            SchemaValueType schemaValueType = (SchemaValueType)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            SchemaValueType schemaValueType2 = cypherType;
            SchemaValueType schemaValueType3 = schemaValueType;
            if (!(schemaValueType2 != null ? !schemaValueType2.equals(schemaValueType3) : schemaValueType3 != null)) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Seq<SchemaValueType>> getNodePropertiesWithTypeConstraint(String labelName) {
        Map map;
        try {
            int labelId = this.getLabelId(labelName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForLabelNonLocking(labelId)).asScala();
            Iterator typeConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyType())).map((Function1 & Serializable)x$9 -> x$9.asPropertyTypeConstraint());
            map = typeConstraints.map((Function1 & Serializable)typeConstraint -> new Tuple2((Object)$this.tc.tokenRead().propertyKeyName(typeConstraint.schema().getPropertyId()), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])typeConstraint.propertyType().values())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (KernelException kernelException) {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public boolean hasRelationshipPropertyTypeConstraint(String relTypeName, String propertyKey, SchemaValueType cypherType) {
        SeqOps seqOps;
        Some some;
        Seq seq;
        Option option = this.getRelationshipPropertiesWithTypeConstraint(relTypeName).get((Object)propertyKey);
        if (option instanceof Some && (seq = (Seq)(some = (Some)option).value()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            SchemaValueType schemaValueType = (SchemaValueType)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            SchemaValueType schemaValueType2 = cypherType;
            SchemaValueType schemaValueType3 = schemaValueType;
            if (!(schemaValueType2 != null ? !schemaValueType2.equals(schemaValueType3) : schemaValueType3 != null)) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Seq<SchemaValueType>> getRelationshipPropertiesWithTypeConstraint(String relTypeName) {
        Map map;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForRelationshipTypeNonLocking(relTypeId)).asScala();
            Iterator typeConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyType())).map((Function1 & Serializable)x$10 -> x$10.asPropertyTypeConstraint());
            map = typeConstraints.map((Function1 & Serializable)typeConstraint -> new Tuple2((Object)$this.tc.tokenRead().propertyKeyName(typeConstraint.schema().getPropertyId()), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])typeConstraint.propertyType().values())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (KernelException kernelException) {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public InstrumentedGraphStatistics statistics() {
        return this.statistics;
    }

    public LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    public ProcedureSignature procedureSignature(QualifiedName name) {
        return TransactionBoundPlanContext$.MODULE$.procedureSignature(this.tc.kernelTransaction(), name, this.cypherVersion);
    }

    public Option<UserFunctionSignature> functionSignature(QualifiedName name) {
        return TransactionBoundPlanContext$.MODULE$.functionSignature(this.tc.kernelTransaction(), name, this.cypherVersion);
    }

    public InternalNotificationLogger notificationLogger() {
        return this.logger;
    }

    public boolean txStateHasChanges() {
        return this.tc.dataRead().transactionStateHasChanges();
    }

    public long procedureSignatureVersion() {
        return this.tc.procedures().signatureVersion();
    }

    public PlanContext withNotificationLogger(InternalNotificationLogger notificationLogger) {
        return new TransactionBoundPlanContext(this.tc, notificationLogger, this.graphStatistics, this.cypherVersion);
    }

    public Enumeration.Value databaseMode() {
        TransactionalContext.DatabaseMode databaseMode = this.tc.kernelTransactionalContext().databaseMode();
        if (TransactionalContext.DatabaseMode.SINGLE.equals(databaseMode)) {
            return DatabaseMode$.MODULE$.SINGLE();
        }
        if (TransactionalContext.DatabaseMode.COMPOSITE.equals(databaseMode)) {
            return DatabaseMode$.MODULE$.COMPOSITE();
        }
        if (TransactionalContext.DatabaseMode.SHARDED.equals(databaseMode)) {
            return DatabaseMode$.MODULE$.SHARDED();
        }
        throw new MatchError((Object)databaseMode);
    }

    public boolean storageHasPropertyColocation() {
        boolean bl;
        try {
            bl = this.tc.kernelTransaction().storageEngineCostCharacteristics().hasPropertyColocation();
        }
        catch (Neo4jException neo4jException) {
            bl = false;
        }
        return bl;
    }

    public QueryLanguage queryLanguage() {
        return QueryLanguage$.MODULE$.from(this.cypherVersion);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForLabel$1(IndexType it$1, IndexDescriptor x$2) {
        IndexType indexType = x$2.getIndexType();
        IndexType indexType2 = it$1;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForLabel$2(IndexDescriptor x$3) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForRelType$1(IndexType it$2, IndexDescriptor x$4) {
        IndexType indexType = x$4.getIndexType();
        IndexType indexType2 = it$2;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForRelType$2(IndexDescriptor x$5) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$indexGetForSchemaDescriptor$1(IndexType indexType$3, IndexDescriptor x$6) {
        IndexType indexType = x$6.getIndexType();
        IndexType indexType2 = indexType$3;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ org.neo4j.cypher.internal.planner.spi.IndexDescriptor $anonfun$getOnlineIndex$2(Product entityType$1, PropertyKeyId[] properties$1, Set behaviours$1, Product orderCapability$1, Product valueCapability$1, IndexDescriptor reference$1, boolean isUnique$1, IndexDescriptor.IndexType indexType) {
        return new org.neo4j.cypher.internal.planner.spi.IndexDescriptor(indexType, (IndexDescriptor.EntityType)entityType$1, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)properties$1), behaviours$1, (IndexOrderCapability)orderCapability$1, (GetValueFromIndexBehavior)valueCapability$1, (Option)new Some((Object)reference$1.getCapability()), isUnique$1);
    }

    public static final /* synthetic */ boolean $anonfun$getTokenIndexDescriptor$1(TransactionBoundPlanContext $this, IndexDescriptor x$7) {
        InternalIndexState internalIndexState = $this.tc.schemaRead().indexGetStateNonLocking(x$7);
        InternalIndexState internalIndexState2 = InternalIndexState.ONLINE;
        return !(internalIndexState != null ? !internalIndexState.equals(internalIndexState2) : internalIndexState2 != null);
    }

    public static final /* synthetic */ String $anonfun$getPropertiesFromExistenceConstraints$3(TransactionBoundPlanContext $this, int id) {
        return $this.tc.tokenRead().propertyKeyName(id);
    }

    public TransactionBoundPlanContext(TransactionalContextWrapper tc, InternalNotificationLogger logger, InstrumentedGraphStatistics graphStatistics, CypherVersion cypherVersion) {
        this.tc = tc;
        this.logger = logger;
        this.graphStatistics = graphStatistics;
        this.cypherVersion = cypherVersion;
        super((QueryTransactionalContext)tc);
        IndexDescriptorCompatibility.$init$(this);
        this.statistics = graphStatistics;
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(tc.graph());
    }
}

