/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi.v2_3;

import org.neo4j.cypher.internal.compiler.v2_3.LabelId;
import org.neo4j.cypher.internal.compiler.v2_3.NameId;
import org.neo4j.cypher.internal.compiler.v2_3.NameId$;
import org.neo4j.cypher.internal.compiler.v2_3.PropertyKeyId;
import org.neo4j.cypher.internal.compiler.v2_3.RelTypeId;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Cardinality;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Cardinality$;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Selectivity;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Selectivity$;
import org.neo4j.cypher.internal.compiler.v2_3.spi.GraphStatistics;
import org.neo4j.cypher.internal.compiler.v2_3.spi.StatisticsCompletingGraphStatistics;
import org.neo4j.cypher.internal.spi.v2_3.TransactionBoundGraphStatistics$;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u00015<Q!\u0001\u0002\t\u0002=\tq\u0004\u0016:b]N\f7\r^5p]\n{WO\u001c3He\u0006\u0004\bn\u0015;bi&\u001cH/[2t\u0015\t\u0019A!\u0001\u0003we}\u001b$BA\u0003\u0007\u0003\r\u0019\b/\u001b\u0006\u0003\u000f!\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u0013)\taaY=qQ\u0016\u0014(BA\u0006\r\u0003\u0015qWm\u001c\u001bk\u0015\u0005i\u0011aA8sO\u000e\u0001\u0001C\u0001\t\u0012\u001b\u0005\u0011a!\u0002\n\u0003\u0011\u0003\u0019\"a\b+sC:\u001c\u0018m\u0019;j_:\u0014u.\u001e8e\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dgN\u0011\u0011\u0003\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000bm\tB\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005y\u0001\"\u0002\u0010\u0012\t\u0003y\u0012!B1qa2LHC\u0001\u0011)!\t\tc%D\u0001#\u0015\t)1E\u0003\u0002\u0004I)\u0011QEB\u0001\tG>l\u0007/\u001b7fe&\u0011qE\t\u0002$'R\fG/[:uS\u000e\u001c8i\\7qY\u0016$\u0018N\\4He\u0006\u0004\bn\u0015;bi&\u001cH/[2t\u0011\u0015IS\u00041\u0001+\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0005\u0002,a5\tAF\u0003\u0002.]\u0005\u0019\u0011\r]5\u000b\u0005=R\u0011AB6fe:,G.\u0003\u00022Y\tI1\u000b^1uK6,g\u000e\u001e\u0004\u0005gE!AGA\u0012CCN,GK]1og\u0006\u001cG/[8o\u0005>,h\u000eZ$sCBD7\u000b^1uSN$\u0018nY:\u0014\u0007I\"R\u0007\u0005\u0002\"m%\u0011qG\t\u0002\u0010\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dg\"A\u0011F\rB\u0001B\u0003%!\u0006C\u0003\u001ce\u0011\u0005!\b\u0006\u0002<{A\u0011AHM\u0007\u0002#!)\u0011&\u000fa\u0001U!)qH\rC\u0001\u0001\u0006\u0001\u0012N\u001c3fqN+G.Z2uSZLG/\u001f\u000b\u0004\u00032\u0013\u0006cA\u000bC\t&\u00111I\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u0013\u000e\nq\u0001\u001d7b]:,'/\u0003\u0002L\r\nY1+\u001a7fGRLg/\u001b;z\u0011\u0015ie\b1\u0001O\u0003\u0015a\u0017MY3m!\ty\u0005+D\u0001$\u0013\t\t6EA\u0004MC\n,G.\u00133\t\u000bMs\u0004\u0019\u0001+\u0002\u0011A\u0014x\u000e]3sif\u0004\"aT+\n\u0005Y\u001b#!\u0004)s_B,'\u000f^=LKfLE\rC\u0003Ye\u0011\u0005\u0011,A\ro_\u0012,7oV5uQ2\u000b'-\u001a7DCJ$\u0017N\\1mSRLHC\u0001.^!\t)5,\u0003\u0002]\r\nY1)\u0019:eS:\fG.\u001b;z\u0011\u0015qv\u000b1\u0001`\u0003\u001da\u0017MY3m\u0013\u0012\u00042!\u0006\"O\u0011\u0015\t'\u0007\"\u0001c\u0003\u0019\u001a\u0017M\u001d3j]\u0006d\u0017\u000e^=Cs2\u000b'-\u001a7t\u0003:$'+\u001a7bi&|gn\u001d5jaRK\b/\u001a\u000b\u00055\u000e,7\u000eC\u0003eA\u0002\u0007q,A\u0005ge>lG*\u00192fY\")a\r\u0019a\u0001O\u0006I!/\u001a7UsB,\u0017\n\u001a\t\u0004+\tC\u0007CA(j\u0013\tQ7EA\u0005SK2$\u0016\u0010]3JI\")A\u000e\u0019a\u0001?\u00069Ao\u001c'bE\u0016d\u0007")
public final class TransactionBoundGraphStatistics {
    public static StatisticsCompletingGraphStatistics apply(Statement statement) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(statement);
    }

    public static class BaseTransactionBoundGraphStatistics
    implements GraphStatistics {
        private final Statement statement;

        public Option<Selectivity> indexSelectivity(LabelId label, PropertyKeyId property) {
            None$ none$;
            try {
                IndexDescriptor indexDescriptor = new IndexDescriptor(NameId$.MODULE$.toKernelEncode((NameId)label), NameId$.MODULE$.toKernelEncode((NameId)property));
                double labeledNodes = this.statement.readOperations().countsForNode(NameId$.MODULE$.toKernelEncode((NameId)label));
                double indexEntrySelectivity = this.statement.readOperations().indexUniqueValuesSelectivity(indexDescriptor);
                double frequencyOfNodesWithSameValue = 1.0 / indexEntrySelectivity;
                double indexSelectivity = frequencyOfNodesWithSameValue / labeledNodes;
                none$ = Selectivity$.MODULE$.of(indexSelectivity);
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public Cardinality nodesWithLabelCardinality(Option<LabelId> labelId) {
            return Cardinality$.MODULE$.lift((double)this.statement.readOperations().countsForNode(NameId$.MODULE$.toKernelEncode(labelId)));
        }

        public Cardinality cardinalityByLabelsAndRelationshipType(Option<LabelId> fromLabel, Option<RelTypeId> relTypeId, Option<LabelId> toLabel) {
            return Cardinality$.MODULE$.lift((double)this.statement.readOperations().countsForRelationship(NameId$.MODULE$.toKernelEncode(fromLabel), NameId$.MODULE$.toKernelEncode(relTypeId), NameId$.MODULE$.toKernelEncode(toLabel)));
        }

        public BaseTransactionBoundGraphStatistics(Statement statement) {
            this.statement = statement;
        }
    }
}

