/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;

public class SubGraphExporter {
    private final SubGraph graph;

    public SubGraphExporter(SubGraph graph) {
        this.graph = graph;
    }

    public void export(PrintWriter out) {
        this.appendNodes(out);
        this.appendRelationships(out);
    }

    public Collection<String> exportIndexes() {
        ArrayList<String> result = new ArrayList<String>();
        for (IndexDefinition index : this.graph.indexes()) {
            StringBuilder keys = new StringBuilder();
            for (String key : index.getPropertyKeys()) {
                if (keys.length() > 0) {
                    keys.append(", ");
                }
                keys.append(this.quote(key));
            }
            result.add("create index on :" + this.quote(index.getLabel().name()) + "(" + keys + ")");
        }
        return result;
    }

    public String quote(String id) {
        return "`" + id + "`";
    }

    private boolean hasProperties(Node node) {
        return node.getPropertyKeys().iterator().hasNext();
    }

    private String labelString(Node node) {
        Iterator labels = node.getLabels().iterator();
        if (!labels.hasNext()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        while (labels.hasNext()) {
            Label next = (Label)labels.next();
            result.append(":").append(this.quote(next.name()));
        }
        return result.toString();
    }

    private String identifier(Node node) {
        return "_" + node.getId();
    }

    private void appendPropertySetters(PrintWriter out, Node node) {
        for (String prop : node.getPropertyKeys()) {
            out.println("set " + this.identifier(node) + "." + this.quote(prop) + "=" + this.toString(node.getProperty(prop)));
        }
    }

    private void appendRelationships(PrintWriter out) {
        for (Node node : this.graph.getNodes()) {
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                this.appendRelationship(out, rel);
            }
        }
    }

    private void appendRelationship(PrintWriter out, Relationship rel) {
        out.print("create ");
        out.print(this.identifier(rel.getStartNode()));
        out.print("-[:");
        out.print(this.quote(rel.getType().name()));
        this.formatProperties(out, (PropertyContainer)rel);
        out.print("]->");
        out.print(this.identifier(rel.getEndNode()));
        out.println();
    }

    private void appendNodes(PrintWriter out) {
        for (Node node : this.graph.getNodes()) {
            this.appendNode(out, node);
        }
    }

    private void appendNode(PrintWriter out, Node node) {
        out.print("create (");
        out.print(this.identifier(node));
        String labels = this.labelString(node);
        if (!labels.isEmpty()) {
            out.print(labels);
        }
        this.formatProperties(out, (PropertyContainer)node);
        out.println(")");
    }

    private boolean isReferenceNode(Node node) {
        return node.getId() == 0L;
    }

    private void formatProperties(PrintWriter out, PropertyContainer pc) {
        if (!pc.getPropertyKeys().iterator().hasNext()) {
            return;
        }
        out.print(" ");
        String propertyString = this.formatProperties(pc);
        out.print(propertyString);
    }

    private String formatProperties(PropertyContainer pc) {
        StringBuilder result = new StringBuilder();
        List keys = Iterables.toList((Iterable)pc.getPropertyKeys());
        Collections.sort(keys);
        for (String prop : keys) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(this.quote(prop)).append(":");
            Object value = pc.getProperty(prop);
            result.append(this.toString(value));
        }
        return "{" + result + "}";
    }

    private String toString(Iterator<?> iterator) {
        StringBuilder result = new StringBuilder();
        while (iterator.hasNext()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            Object value = iterator.next();
            result.append(this.toString(value));
        }
        return "[" + result + "]";
    }

    private String arrayToString(Object value) {
        StringBuilder result = new StringBuilder();
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.toString(Array.get(value, i)));
        }
        return "[" + result + "]";
    }

    private String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof Iterator) {
            return this.toString((Iterator)value);
        }
        if (value instanceof Iterable) {
            return this.toString(((Iterable)value).iterator());
        }
        if (value.getClass().isArray()) {
            return this.arrayToString(value);
        }
        return value.toString();
    }
}

