/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.executionplan.builders;

import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.internal.commands.expressions.Expression;
import org.neo4j.cypher.internal.commands.expressions.Identifier;
import org.neo4j.cypher.internal.executionplan.builders.UpdateCommandExpander;
import org.neo4j.cypher.internal.mutation.CreateNode;
import org.neo4j.cypher.internal.mutation.CreateRelationship;
import org.neo4j.cypher.internal.mutation.ForeachAction;
import org.neo4j.cypher.internal.mutation.RelationshipEndpoint;
import org.neo4j.cypher.internal.mutation.UpdateAction;
import org.neo4j.cypher.internal.symbols.AnyType;
import org.neo4j.cypher.internal.symbols.CollectionType$;
import org.neo4j.cypher.internal.symbols.NodeType$;
import org.neo4j.cypher.internal.symbols.SymbolTable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;

public abstract class UpdateCommandExpander$class {
    public static Seq expandCommands(UpdateCommandExpander $this, Seq commands, SymbolTable symbols2) {
        Seq missingCreateNodeActions = (Seq)commands.flatMap((Function1)new Serializable($this, commands, symbols2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UpdateCommandExpander $outer;
            private final Seq commands$1;
            private final SymbolTable symbols$1;

            public final Seq<UpdateAction> apply(UpdateAction x0$3) {
                Seq seq;
                UpdateAction updateAction = x0$3;
                if (updateAction instanceof ForeachAction) {
                    ForeachAction foreachAction = (ForeachAction)updateAction;
                    Expression coll = foreachAction.collection();
                    String id2 = foreachAction.id();
                    Seq<UpdateAction> actions = foreachAction.actions();
                    Seq<UpdateAction> expandedCommands = this.$outer.expandCommands(actions, this.symbols$1.add(id2, coll.evaluateType(CollectionType$.MODULE$.apply(new AnyType()), this.symbols$1).iteratedType()));
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ForeachAction[]{new ForeachAction(coll, id2, expandedCommands)}));
                } else if (updateAction instanceof CreateRelationship) {
                    CreateRelationship createRelationship2 = (CreateRelationship)updateAction;
                    seq = (Seq)((TraversableLike)UpdateCommandExpander$class.alsoCreateNode$1(this.$outer, createRelationship2.from(), this.symbols$1, this.commands$1).$plus$plus((GenTraversableOnce)UpdateCommandExpander$class.alsoCreateNode$1(this.$outer, createRelationship2.to(), this.symbols$1, this.commands$1), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.commands$1, Seq$.MODULE$.canBuildFrom());
                } else {
                    seq = this.commands$1;
                }
                return seq;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.commands$1 = commands$1;
                this.symbols$1 = symbols$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq distinctMissingCreateNodeActions = (Seq)missingCreateNodeActions.distinct();
        Seq distinctifiedCreateNodeActions = UpdateCommandExpander$class.distinctify$1($this, distinctMissingCreateNodeActions);
        Seq<UpdateAction> sortedCreateNodeActions = new UpdateCommandExpander.SortedUpdateActionIterator($this, (Seq<UpdateAction>)distinctifiedCreateNodeActions, symbols2).toSeq();
        return sortedCreateNodeActions;
    }

    private static final Seq distinctify$1(UpdateCommandExpander $this, Seq nodes) {
        Set createdNodes = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        return (Seq)nodes.flatMap((Function1)new Serializable($this, createdNodes){
            public static final long serialVersionUID = 0L;
            private final Set createdNodes$1;

            public final Iterable<UpdateAction> apply(UpdateAction node2) {
                Iterable iterable;
                String key;
                boolean bl = false;
                CreateNode createNode2 = null;
                UpdateAction updateAction = node2;
                if (updateAction instanceof CreateNode) {
                    bl = true;
                    createNode2 = (CreateNode)updateAction;
                    String key2 = createNode2.key();
                    Map<String, Expression> props2 = createNode2.properties();
                    if (this.createdNodes$1.contains((Object)key2) && props2.nonEmpty()) {
                        throw new SyntaxException(new StringOps(Predef$.MODULE$.augmentString("Node `%s` has already been created. Can't assign properties to it again.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key2})));
                    }
                }
                if (bl) {
                    String key3 = createNode2.key();
                    boolean bare = createNode2.bare();
                    if (!bare && this.createdNodes$1.contains((Object)key3)) {
                        throw new SyntaxException(new StringOps(Predef$.MODULE$.augmentString("Node `%s` has already been created. Can't assign properties or labels to it again.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key3})));
                    }
                }
                if (bl && this.createdNodes$1.contains((Object)(key = createNode2.key()))) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else if (bl) {
                    String key4 = createNode2.key();
                    this.createdNodes$1.$plus$eq((Object)key4);
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)createNode2));
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)updateAction));
                }
                return iterable;
            }
            {
                this.createdNodes$1 = createdNodes$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final Seq alsoCreateNode$1(UpdateCommandExpander $this, RelationshipEndpoint e, SymbolTable symbols2, Seq commands) {
        Seq seq;
        Expression expression2 = e.node();
        if (expression2 instanceof Identifier) {
            Identifier identifier2 = (Identifier)expression2;
            String name = identifier2.entityName();
            boolean nodeFromUnderlyingPipe = symbols2.checkType(name, NodeType$.MODULE$.apply());
            boolean nodeFromOtherCommand = commands.exists((Function1)new Serializable($this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final boolean apply(UpdateAction x0$2) {
                    boolean bl;
                    UpdateAction updateAction = x0$2;
                    if (updateAction instanceof CreateNode) {
                        String n;
                        CreateNode createNode2 = (CreateNode)updateAction;
                        String string2 = n = createNode2.key();
                        String string3 = this.name$1;
                        bl = !(string2 != null ? !string2.equals(string3) : string3 != null);
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.name$1 = name$1;
                }
            });
            seq = nodeFromUnderlyingPipe || nodeFromOtherCommand ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateNode[]{new CreateNode(name, e.props(), e.labels(), e.bare())}));
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        return seq;
    }

    public static void $init$(UpdateCommandExpander $this) {
    }
}

