/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.executionplan.builders;

import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.internal.commands.Pattern;
import org.neo4j.cypher.internal.commands.RelatedTo;
import org.neo4j.cypher.internal.commands.SingleNode;
import org.neo4j.cypher.internal.commands.VarLengthRelatedTo;
import org.neo4j.cypher.internal.executionplan.builders.PatternGraphBuilder;
import org.neo4j.cypher.internal.pipes.matching.PatternGraph;
import org.neo4j.cypher.internal.pipes.matching.PatternNode;
import org.neo4j.cypher.internal.pipes.matching.PatternRelationship;
import org.neo4j.cypher.internal.symbols.SymbolTable;
import org.neo4j.graphdb.Direction;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;

public abstract class PatternGraphBuilder$class {
    public static PatternGraph buildPatternGraph(PatternGraphBuilder $this, SymbolTable symbols2, Seq patterns) {
        Map patternNodeMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map patternRelMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        patterns.foreach((Function1)new Serializable($this, patternNodeMap, patternRelMap){
            public static final long serialVersionUID = 0L;
            private final Map patternNodeMap$1;
            private final Map patternRelMap$1;

            public final void apply(Pattern x$10) {
                Pattern pattern2 = x$10;
                if (pattern2 instanceof RelatedTo) {
                    RelatedTo relatedTo = (RelatedTo)pattern2;
                    SingleNode left = relatedTo.left();
                    SingleNode right = relatedTo.right();
                    String rel = relatedTo.relName();
                    Seq<String> relType = relatedTo.relTypes();
                    Direction dir = relatedTo.direction();
                    boolean optional = relatedTo.optional();
                    PatternNode leftNode = (PatternNode)this.patternNodeMap$1.getOrElseUpdate((Object)left.name(), (Function0)new Serializable(this, left){
                        public static final long serialVersionUID = 0L;
                        private final SingleNode left$1;

                        public final PatternNode apply() {
                            return new PatternNode(this.left$1);
                        }
                        {
                            this.left$1 = left$1;
                        }
                    });
                    PatternNode rightNode = (PatternNode)this.patternNodeMap$1.getOrElseUpdate((Object)right.name(), (Function0)new Serializable(this, right){
                        public static final long serialVersionUID = 0L;
                        private final SingleNode right$1;

                        public final PatternNode apply() {
                            return new PatternNode(this.right$1);
                        }
                        {
                            this.right$1 = right$1;
                        }
                    });
                    if (this.patternRelMap$1.contains((Object)rel)) {
                        throw new SyntaxException(new StringOps(Predef$.MODULE$.augmentString("Can't re-use pattern relationship '%s' with different start/end nodes.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rel})));
                    }
                    this.patternRelMap$1.update((Object)rel, (Object)leftNode.relateTo(rel, rightNode, relType, dir, optional));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (pattern2 instanceof VarLengthRelatedTo) {
                    VarLengthRelatedTo varLengthRelatedTo = (VarLengthRelatedTo)pattern2;
                    String pathName = varLengthRelatedTo.pathName();
                    SingleNode start2 = varLengthRelatedTo.left();
                    SingleNode end = varLengthRelatedTo.right();
                    Option<Object> minHops = varLengthRelatedTo.minHops();
                    Option<Object> maxHops = varLengthRelatedTo.maxHops();
                    Seq<String> relType = varLengthRelatedTo.relTypes();
                    Direction dir = varLengthRelatedTo.direction();
                    Option<String> relsCollection = varLengthRelatedTo.relIterator();
                    boolean optional = varLengthRelatedTo.optional();
                    PatternNode startNode = (PatternNode)this.patternNodeMap$1.getOrElseUpdate((Object)start2.name(), (Function0)new Serializable(this, start2){
                        public static final long serialVersionUID = 0L;
                        private final SingleNode start$1;

                        public final PatternNode apply() {
                            return new PatternNode(this.start$1);
                        }
                        {
                            this.start$1 = start$1;
                        }
                    });
                    PatternNode endNode = (PatternNode)this.patternNodeMap$1.getOrElseUpdate((Object)end.name(), (Function0)new Serializable(this, end){
                        public static final long serialVersionUID = 0L;
                        private final SingleNode end$1;

                        public final PatternNode apply() {
                            return new PatternNode(this.end$1);
                        }
                        {
                            this.end$1 = end$1;
                        }
                    });
                    this.patternRelMap$1.update((Object)pathName, (Object)startNode.relateViaVariableLengthPathTo(pathName, endNode, minHops, maxHops, relType, dir, relsCollection, optional));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.patternNodeMap$1 = patternNodeMap$1;
                this.patternRelMap$1 = patternRelMap$1;
            }
        });
        return new PatternGraph((scala.collection.immutable.Map<String, PatternNode>)patternNodeMap.toMap(Predef$.MODULE$.conforms()), (scala.collection.immutable.Map<String, PatternRelationship>)patternRelMap.toMap(Predef$.MODULE$.conforms()), symbols2.keys());
    }

    public static void $init$(PatternGraphBuilder $this) {
    }
}

