/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;

public class SubGraphExporter {
    private final SubGraph graph;

    public SubGraphExporter(SubGraph graph) {
        this.graph = graph;
    }

    public void export(PrintWriter out) {
        this.init(out);
        this.appendNodes(out);
        this.appendRelationships(out);
    }

    public Collection<String> exportIndexes() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (IndexDefinition index : this.graph.indexes()) {
            StringBuilder keys2 = new StringBuilder();
            for (String key : index.getPropertyKeys()) {
                if (keys2.length() > 0) {
                    keys2.append(", ");
                }
                keys2.append(this.quote(key));
            }
            result2.add("create index on :" + this.quote(index.getLabel().name()) + "(" + keys2 + ")");
        }
        return result2;
    }

    public String quote(String id2) {
        return "`" + id2 + "`";
    }

    private void init(PrintWriter out) {
        Node node2 = this.getReferenceNode();
        if (node2 != null && (node2.hasRelationship() || this.hasProperties(node2))) {
            String id2 = this.identifier(node2);
            out.println("start " + id2 + " = node(" + node2.getId() + ") with " + id2 + " ");
            String labels = this.labelString(node2);
            if (!labels.isEmpty()) {
                out.print("set " + this.identifier(node2) + " " + labels + " ");
            }
            this.appendPropertySetters(out, node2);
        }
    }

    private boolean hasProperties(Node node2) {
        return node2.getPropertyKeys().iterator().hasNext();
    }

    private String labelString(Node node2) {
        try (ResourceIterator labels = node2.getLabels().iterator();){
            if (!labels.hasNext()) {
                String string2 = "";
                return string2;
            }
            StringBuilder result2 = new StringBuilder();
            while (labels.hasNext()) {
                Label next2 = (Label)labels.next();
                result2.append(":").append(this.quote(next2.name()));
            }
            String string3 = result2.toString();
            return string3;
        }
    }

    private String identifier(Node node2) {
        return "_" + node2.getId();
    }

    private void appendPropertySetters(PrintWriter out, Node node2) {
        for (String prop : node2.getPropertyKeys()) {
            out.println("set " + this.identifier(node2) + "." + this.quote(prop) + "=" + this.toString(node2.getProperty(prop)));
        }
    }

    private Node getReferenceNode() {
        try {
            return this.graph.getReferenceNode();
        }
        catch (NotFoundException nfe) {
            return null;
        }
    }

    private void appendRelationships(PrintWriter out) {
        for (Node node2 : this.graph.getNodes()) {
            for (Relationship rel : node2.getRelationships(Direction.OUTGOING)) {
                this.appendRelationship(out, rel);
            }
        }
    }

    private void appendRelationship(PrintWriter out, Relationship rel) {
        out.print("create ");
        out.print(this.identifier(rel.getStartNode()));
        out.print("-[:");
        out.print(this.quote(rel.getType().name()));
        this.formatProperties(out, (PropertyContainer)rel);
        out.print("]->");
        out.print(this.identifier(rel.getEndNode()));
        out.println();
    }

    private void appendNodes(PrintWriter out) {
        for (Node node2 : this.graph.getNodes()) {
            if (this.isReferenceNode(node2)) continue;
            this.appendNode(out, node2);
        }
    }

    private void appendNode(PrintWriter out, Node node2) {
        out.print("create (");
        out.print(this.identifier(node2));
        String labels = this.labelString(node2);
        if (!labels.isEmpty()) {
            out.print(labels);
        }
        this.formatProperties(out, (PropertyContainer)node2);
        out.println(")");
    }

    private boolean isReferenceNode(Node node2) {
        return node2.getId() == 0L;
    }

    private void formatProperties(PrintWriter out, PropertyContainer pc) {
        if (!pc.getPropertyKeys().iterator().hasNext()) {
            return;
        }
        out.print(" ");
        String propertyString = this.formatProperties(pc);
        out.print(propertyString);
    }

    private String formatProperties(PropertyContainer pc) {
        StringBuilder result2 = new StringBuilder();
        List keys2 = Iterables.toList((Iterable)pc.getPropertyKeys());
        Collections.sort(keys2);
        for (String prop : keys2) {
            if (result2.length() > 0) {
                result2.append(", ");
            }
            result2.append(this.quote(prop)).append(":");
            Object value = pc.getProperty(prop);
            result2.append(this.toString(value));
        }
        return "{" + result2 + "}";
    }

    private String toString(Iterator<?> iterator2) {
        StringBuilder result2 = new StringBuilder();
        while (iterator2.hasNext()) {
            if (result2.length() > 0) {
                result2.append(", ");
            }
            Object value = iterator2.next();
            result2.append(this.toString(value));
        }
        return "[" + result2 + "]";
    }

    private String arrayToString(Object value) {
        StringBuilder result2 = new StringBuilder();
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                result2.append(", ");
            }
            result2.append(this.toString(Array.get(value, i)));
        }
        return "[" + result2 + "]";
    }

    private String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof Iterator) {
            return this.toString((Iterator)value);
        }
        if (value instanceof Iterable) {
            return this.toString(((Iterable)value).iterator());
        }
        if (value.getClass().isArray()) {
            return this.arrayToString(value);
        }
        return value.toString();
    }
}

