/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.schema.IndexDefinition;

public class CypherResultSubGraph
implements SubGraph {
    private static final long REF_NODE_ID = 0L;
    private final SortedMap<Long, Node> nodes = new TreeMap<Long, Node>();
    private final SortedMap<Long, Relationship> relationships = new TreeMap<Long, Relationship>();

    public void add(Node node2) {
        long id2 = node2.getId();
        if (!this.nodes.containsKey(id2)) {
            this.addNode(id2, node2);
        }
    }

    void addNode(long id2, Node data) {
        this.nodes.put(id2, data);
    }

    public void add(Relationship rel) {
        long id2 = rel.getId();
        if (!this.relationships.containsKey(id2)) {
            this.addRel(id2, rel);
            this.add(rel.getStartNode());
            this.add(rel.getEndNode());
        }
    }

    public static SubGraph from(ExecutionResult result2, boolean addBetween) {
        CypherResultSubGraph graph = new CypherResultSubGraph();
        List<String> columns2 = result2.columns();
        Iterator i$ = result2.iterator();
        while (i$.hasNext()) {
            Map row = (Map)i$.next();
            for (String column2 : columns2) {
                Object value = row.get(column2);
                graph.addToGraph(value);
            }
        }
        if (addBetween) {
            graph.addRelationshipsBetweenNodes();
        }
        return graph;
    }

    private void addRelationshipsBetweenNodes() {
        HashSet<Node> newNodes = new HashSet<Node>();
        for (Node node2 : this.nodes.values()) {
            for (Relationship relationship2 : node2.getRelationships()) {
                Node other;
                if (!this.relationships.containsKey(relationship2.getId()) || this.nodes.containsKey((other = relationship2.getOtherNode(node2)).getId()) || newNodes.contains(other)) continue;
                newNodes.add(other);
            }
        }
        for (Node node2 : newNodes) {
            this.add(node2);
        }
    }

    private void addToGraph(Object value) {
        if (value instanceof Node) {
            this.add((Node)value);
        }
        if (value instanceof Relationship) {
            this.add((Relationship)value);
        }
        if (value instanceof Iterable) {
            for (Object inner : (Iterable)value) {
                this.addToGraph(inner);
            }
        }
    }

    @Override
    public Iterable<Node> getNodes() {
        return this.nodes.values();
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.relationships.values();
    }

    void addRel(Long id2, Relationship rel) {
        this.relationships.put(id2, rel);
    }

    @Override
    public Node getReferenceNode() {
        return (Node)this.nodes.get(0L);
    }

    @Override
    public boolean contains(Relationship relationship2) {
        return this.relationships.containsKey(relationship2.getId());
    }

    @Override
    public Iterable<IndexDefinition> indexes() {
        return Collections.emptyList();
    }
}

