/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi.gdsimpl;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypher.internal.spi.Locker;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;

public class GDSBackedLocker
implements Locker {
    private final Transaction transaction;
    private final Map<Long, Lock> nodeLocks = new HashMap<Long, Lock>();
    private final Map<Long, Lock> relationshipLocks = new HashMap<Long, Lock>();

    public GDSBackedLocker(Transaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public void readLock(PropertyContainer pc) {
        if (pc instanceof Node) {
            this.lock(pc, ((Node)pc).getId(), this.nodeLocks);
        } else {
            this.lock(pc, ((Relationship)pc).getId(), this.relationshipLocks);
        }
    }

    private void lock(PropertyContainer pc, long id2, Map<Long, Lock> lockHolder) {
        if (!lockHolder.containsKey(id2)) {
            Lock lock = this.transaction.acquireReadLock(pc);
            this.relationshipLocks.put(id2, lock);
        }
    }

    @Override
    public void releaseAllReadLocks() {
        for (Lock lock : this.nodeLocks.values()) {
            lock.release();
        }
        for (Lock lock : this.relationshipLocks.values()) {
            lock.release();
        }
    }
}

