/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi.gdsimpl;

import org.neo4j.cypher.internal.spi.QueryContext;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class GDSBackedQueryContext
implements QueryContext {
    private final GraphDatabaseService graph;

    public GDSBackedQueryContext(GraphDatabaseService graph) {
        this.graph = graph;
    }

    @Override
    public void close() {
    }

    @Override
    public Node createNode() {
        return this.graph.createNode();
    }

    @Override
    public Relationship createRelationship(Node start2, Node end, String relType) {
        return start2.createRelationshipTo(end, (RelationshipType)DynamicRelationshipType.withName((String)relType));
    }

    @Override
    public Iterable<Relationship> getRelationshipsFor(Node node2, Direction dir, String ... types) {
        if (types.length == 0) {
            return node2.getRelationships(dir);
        }
        return node2.getRelationships(dir, this.transform(types));
    }

    private RelationshipType[] transform(String[] types) {
        RelationshipType[] result2 = new RelationshipType[types.length];
        for (int i = 0; i < types.length; ++i) {
            result2[i] = DynamicRelationshipType.withName((String)types[i]);
        }
        return result2;
    }

    @Override
    public QueryContext.Operations<Node> nodeOps() {
        return new QueryContext.Operations<Node>(){

            @Override
            public void delete(Node obj) {
                obj.delete();
            }

            @Override
            public void setProperty(Node obj, String propertyKey, Object value) {
                obj.setProperty(propertyKey, value);
            }

            @Override
            public void removeProperty(Node obj, String propertyKey) {
                obj.removeProperty(propertyKey);
            }

            @Override
            public Object getProperty(Node obj, String propertyKey) {
                return obj.getProperty(propertyKey);
            }

            @Override
            public boolean hasProperty(Node obj, String propertyKey) {
                return obj.hasProperty(propertyKey);
            }

            @Override
            public Iterable<String> propertyKeys(Node obj) {
                return obj.getPropertyKeys();
            }

            @Override
            public Node getById(long id2) {
                return GDSBackedQueryContext.this.graph.getNodeById(id2);
            }
        };
    }

    @Override
    public QueryContext.Operations<Relationship> relationshipOps() {
        return new QueryContext.Operations<Relationship>(){

            @Override
            public void delete(Relationship obj) {
                obj.delete();
            }

            @Override
            public void setProperty(Relationship obj, String propertyKey, Object value) {
                obj.setProperty(propertyKey, value);
            }

            @Override
            public void removeProperty(Relationship obj, String propertyKey) {
                obj.removeProperty(propertyKey);
            }

            @Override
            public Object getProperty(Relationship obj, String propertyKey) {
                return obj.getProperty(propertyKey);
            }

            @Override
            public boolean hasProperty(Relationship obj, String propertyKey) {
                return obj.hasProperty(propertyKey);
            }

            @Override
            public Iterable<String> propertyKeys(Relationship obj) {
                return obj.getPropertyKeys();
            }

            @Override
            public Relationship getById(long id2) {
                return GDSBackedQueryContext.this.graph.getRelationshipById(id2);
            }
        };
    }
}

