/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.executionplan.builders;

import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.internal.commands.expressions.Expression;
import org.neo4j.cypher.internal.commands.expressions.Identifier;
import org.neo4j.cypher.internal.executionplan.builders.UpdateCommandExpander;
import org.neo4j.cypher.internal.mutation.CreateNode;
import org.neo4j.cypher.internal.mutation.CreateRelationship;
import org.neo4j.cypher.internal.mutation.ForeachAction;
import org.neo4j.cypher.internal.mutation.UpdateAction;
import org.neo4j.cypher.internal.symbols.AnyCollectionType$;
import org.neo4j.cypher.internal.symbols.NodeType$;
import org.neo4j.cypher.internal.symbols.SymbolTable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;

public abstract class UpdateCommandExpander$class {
    public static Seq expandCommands(UpdateCommandExpander $this, Seq commands, SymbolTable symbols2) {
        Seq missingCreateNodeActions = (Seq)((SeqLike)commands.flatMap((Function1)new Serializable($this, commands, symbols2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UpdateCommandExpander $outer;
            private final Seq commands$1;
            private final SymbolTable symbols$1;

            public final Seq<UpdateAction> apply(UpdateAction x0$4) {
                Seq seq;
                ForeachAction x2;
                UpdateAction updateAction = x0$4;
                if (updateAction instanceof ForeachAction && (x2 = (ForeachAction)updateAction) != null) {
                    Expression coll = x2.collection();
                    String id2 = x2.id();
                    Seq<UpdateAction> actions = x2.actions();
                    Seq<UpdateAction> expandedCommands = this.$outer.expandCommands(actions, this.symbols$1.add(id2, coll.evaluateType(AnyCollectionType$.MODULE$.apply(), this.symbols$1).iteratedType()));
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ForeachAction[]{new ForeachAction(coll, id2, expandedCommands)}));
                } else if (updateAction instanceof CreateRelationship) {
                    CreateRelationship x3 = (CreateRelationship)updateAction;
                    seq = (Seq)((TraversableLike)UpdateCommandExpander$class.alsoCreateNode$1(this.$outer, x3.from(), this.symbols$1, this.commands$1).$plus$plus((GenTraversableOnce)UpdateCommandExpander$class.alsoCreateNode$1(this.$outer, x3.to(), this.symbols$1, this.commands$1), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.commands$1, Seq$.MODULE$.canBuildFrom());
                } else {
                    seq = this.commands$1;
                }
                return seq;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.commands$1 = commands$1;
                this.symbols$1 = symbols$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        return new UpdateCommandExpander.SortedUpdateActionIterator($this, (Seq<UpdateAction>)UpdateCommandExpander$class.distinctify$1($this, missingCreateNodeActions), symbols2).toSeq();
    }

    private static final Seq distinctify$1(UpdateCommandExpander $this, Seq nodes) {
        Set createdNodes = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        return (Seq)nodes.flatMap((Function1)new Serializable($this, createdNodes){
            public static final long serialVersionUID = 0L;
            private final Set createdNodes$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Iterable<UpdateAction> apply(UpdateAction x0$2) {
                boolean rc8 = false;
                CreateNode x2 = null;
                UpdateAction updateAction = x0$2;
                if (updateAction instanceof CreateNode) {
                    rc8 = true;
                    x2 = (CreateNode)updateAction;
                    if (x2 != null) {
                        String key = x2.key();
                        Map<String, Expression> props2 = x2.props();
                        if (this.createdNodes$1.contains((Object)key) && props2.nonEmpty()) {
                            throw new SyntaxException(new StringOps(Predef$.MODULE$.augmentString("Node `%s` has already been created. Can't assign properties to it again.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
                        }
                    }
                }
                if (rc8 && x2 != null) {
                    String key = x2.key();
                    Map<String, Expression> p3 = x2.props();
                    if (this.createdNodes$1.contains((Object)key)) {
                        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                }
                if (!rc8) return Option$.MODULE$.option2Iterable((Option)new Some((Object)updateAction));
                if (x2 == null) return Option$.MODULE$.option2Iterable((Option)new Some((Object)updateAction));
                String key = x2.key();
                Map<String, Expression> p5 = x2.props();
                this.createdNodes$1.$plus$eq((Object)key);
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)x2));
            }
            {
                this.createdNodes$1 = createdNodes$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final Seq alsoCreateNode$1(UpdateCommandExpander $this, Tuple2 e, SymbolTable symbols2, Seq commands) {
        Seq seq;
        Identifier x2;
        Expression expression2 = (Expression)e._1();
        if (expression2 instanceof Identifier && (x2 = (Identifier)expression2) != null) {
            String name = x2.entityName();
            boolean nodeFromUnderlyingPipe = symbols2.checkType(name, NodeType$.MODULE$.apply());
            boolean nodeFromOtherCommand = commands.exists((Function1)new Serializable($this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final boolean apply(UpdateAction x0$3) {
                    boolean bl;
                    CreateNode x3;
                    UpdateAction updateAction = x0$3;
                    if (updateAction instanceof CreateNode && (x3 = (CreateNode)updateAction) != null) {
                        String n = x3.key();
                        Map<String, Expression> p2 = x3.props();
                        String string2 = n;
                        String string3 = this.name$1;
                        bl = !(string2 != null ? !string2.equals(string3) : string3 != null);
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.name$1 = name$1;
                }
            });
            seq = nodeFromUnderlyingPipe || nodeFromOtherCommand ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateNode[]{new CreateNode(name, (Map<String, Expression>)((Map)e._2()))}));
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        return seq;
    }

    public static void $init$(UpdateCommandExpander $this) {
    }
}

