/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.pipes;

import org.neo4j.cypher.internal.commands.AggregationExpression;
import org.neo4j.cypher.internal.commands.Expression;
import org.neo4j.cypher.internal.pipes.ExecutionContext;
import org.neo4j.cypher.internal.pipes.OrderedAggregator;
import org.neo4j.cypher.internal.pipes.Pipe;
import org.neo4j.cypher.internal.pipes.PipeWithSource;
import org.neo4j.cypher.internal.pipes.QueryState;
import org.neo4j.cypher.internal.symbols.AnyType$;
import org.neo4j.cypher.internal.symbols.Identifier;
import org.neo4j.cypher.internal.symbols.SymbolTable;
import org.neo4j.helpers.ThisShouldNotHappenError;
import scala.Function1;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u001b\t1rJ\u001d3fe\u0016$\u0017iZ4sK\u001e\fG/[8o!&\u0004XM\u0003\u0002\u0004\t\u0005)\u0001/\u001b9fg*\u0011QAB\u0001\tS:$XM\u001d8bY*\u0011q\u0001C\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005%Q\u0011!\u00028f_RR'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\tq\u0001+\u001b9f/&$\bnU8ve\u000e,\u0007CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"aC*dC2\fwJ\u00196fGRD\u0011\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u000f\u0002\rM|WO]2f!\ty1$\u0003\u0002\u001d\u0005\t!\u0001+\u001b9f\u0013\tI\u0002\u0003\u0003\u0005 \u0001\t\u0015\r\u0011\"\u0001!\u00039YW-_#yaJ,7o]5p]N,\u0012!\t\t\u0004E\u0015:S\"A\u0012\u000b\u0005\u0011\"\u0012AC2pY2,7\r^5p]&\u0011ae\t\u0002\u0004'\u0016\f\bC\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0005\u0003!\u0019w.\\7b]\u0012\u001c\u0018B\u0001\u0017*\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\t]\u0001\u0011\t\u0011)A\u0005C\u0005y1.Z=FqB\u0014Xm]:j_:\u001c\b\u0005\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u00031\twm\u001a:fO\u0006$\u0018n\u001c8t!\r\u0011SE\r\t\u0003QMJ!\u0001N\u0015\u0003+\u0005;wM]3hCRLwN\\#yaJ,7o]5p]\")a\u0007\u0001C\u0001o\u00051A(\u001b8jiz\"B\u0001O\u001d;wA\u0011q\u0002\u0001\u0005\u00063U\u0002\rA\u0007\u0005\u0006?U\u0002\r!\t\u0005\u0006aU\u0002\r!\r\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0003\u001d\u0019\u00180\u001c2pYN,\u0012a\u0010\t\u0003\u0001\nk\u0011!\u0011\u0006\u0003{\u0011I!aQ!\u0003\u0017MKXNY8m)\u0006\u0014G.\u001a\u0005\u0007\u000b\u0002\u0001\u000b\u0011B \u0002\u0011MLXNY8mg\u0002BQa\u0012\u0001\u0005\u0002!\u000bA\u0002Z3qK:$WM\\2jKN,\u0012!\u0013\t\u0004E\u0015R\u0005C\u0001!L\u0013\ta\u0015I\u0001\u0006JI\u0016tG/\u001b4jKJDQA\u0014\u0001\u0005\u0002=\u000bQb\u0019:fCR,7+_7c_2\u001cH#A \t\u000bE\u0003A\u0011\u0001*\u0002\u001b\r\u0014X-\u0019;f%\u0016\u001cX\u000f\u001c;t)\t\u0019&\rE\u0002U9~s!!\u0016.\u000f\u0005YKV\"A,\u000b\u0005ac\u0011A\u0002\u001fs_>$h(C\u0001\u0016\u0013\tYF#A\u0004qC\u000e\\\u0017mZ3\n\u0005us&a\u0003+sCZ,'o]1cY\u0016T!a\u0017\u000b\u0011\u0005=\u0001\u0017BA1\u0003\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003d!\u0002\u0007A-A\u0003ti\u0006$X\r\u0005\u0002\u0010K&\u0011aM\u0001\u0002\u000b#V,'/_*uCR,\u0007\"\u00025\u0001\t\u0003J\u0017!D3yK\u000e,H/[8o!2\fg\u000eF\u0001k!\tY\u0007/D\u0001m\u0015\tig.\u0001\u0003mC:<'\"A8\u0002\t)\fg/Y\u0005\u0003c2\u0014aa\u0015;sS:<\u0007")
public class OrderedAggregationPipe
extends PipeWithSource
implements ScalaObject {
    private final Seq<Expression> keyExpressions;
    private final Seq<AggregationExpression> aggregations;
    private final SymbolTable symbols;

    public Seq<Expression> keyExpressions() {
        return this.keyExpressions;
    }

    @Override
    public SymbolTable symbols() {
        return this.symbols;
    }

    @Override
    public Seq<Identifier> dependencies() {
        return (Seq)((TraversableLike)this.keyExpressions().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Identifier> apply(Expression expression2) {
                return expression2.dependencies(AnyType$.MODULE$.apply());
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.aggregations.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Identifier> apply(AggregationExpression aggregationExpression) {
                return aggregationExpression.dependencies(AnyType$.MODULE$.apply());
            }
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public SymbolTable createSymbols() {
        SymbolTable keySymbols = super.source().symbols().filter((Seq<String>)((Seq)this.keyExpressions().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Expression expression2) {
                return expression2.identifier().name();
            }
        }, Seq$.MODULE$.canBuildFrom())));
        Seq aggregateIdentifiers = (Seq)this.aggregations.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Identifier apply(AggregationExpression aggregationExpression) {
                return aggregationExpression.identifier();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return keySymbols.add((Seq<Identifier>)aggregateIdentifiers);
    }

    @Override
    public Traversable<ExecutionContext> createResults(QueryState state) {
        return new OrderedAggregator(super.source().createResults(state), this.keyExpressions(), this.aggregations);
    }

    @Override
    public String executionPlan() {
        return new StringBuilder().append((Object)super.source().executionPlan()).append((Object)"\r\n").append((Object)"EagerAggregation( keys: [").append((Object)((TraversableOnce)this.keyExpressions().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Expression expression2) {
                return expression2.identifier().name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")).append((Object)"], aggregates: [").append((Object)this.aggregations.mkString(", ")).append((Object)"])").toString();
    }

    public OrderedAggregationPipe(Pipe source, Seq<Expression> keyExpressions, Seq<AggregationExpression> aggregations) {
        this.keyExpressions = keyExpressions;
        this.aggregations = aggregations;
        super(source);
        if (keyExpressions.isEmpty()) {
            throw new ThisShouldNotHappenError("Andres Taylor", "The ordered aggregation pipe should never be used without aggregation keys");
        }
        this.symbols = this.createSymbols();
    }
}

