/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.pipes;

import org.neo4j.cypher.internal.commands.AggregationExpression;
import org.neo4j.cypher.internal.commands.Expression;
import org.neo4j.cypher.internal.pipes.OrderedAggregator;
import org.neo4j.cypher.internal.pipes.Pipe;
import org.neo4j.cypher.internal.pipes.PipeWithSource;
import org.neo4j.cypher.internal.symbols.AnyType$;
import org.neo4j.cypher.internal.symbols.Identifier;
import org.neo4j.cypher.internal.symbols.SymbolTable;
import org.neo4j.helpers.ThisShouldNotHappenError;
import scala.Function1;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u001b\t1rJ\u001d3fe\u0016$\u0017iZ4sK\u001e\fG/[8o!&\u0004XM\u0003\u0002\u0004\t\u0005)\u0001/\u001b9fg*\u0011QAB\u0001\tS:$XM\u001d8bY*\u0011q\u0001C\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005%Q\u0011!\u00028f_RR'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\tq\u0001+\u001b9f/&$\bnU8ve\u000e,\u0007CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"aC*dC2\fwJ\u00196fGRD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0007g>,(oY3\u0011\u0005=Y\u0012B\u0001\u000f\u0003\u0005\u0011\u0001\u0016\u000e]3\t\u0011y\u0001!Q1A\u0005\u0002}\tab[3z\u000bb\u0004(/Z:tS>t7/F\u0001!!\r\tCEJ\u0007\u0002E)\u00111\u0005F\u0001\u000bG>dG.Z2uS>t\u0017BA\u0013#\u0005\r\u0019V-\u001d\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S\u0011\t\u0001bY8n[\u0006tGm]\u0005\u0003W!\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0011!i\u0003A!A!\u0002\u0013\u0001\u0013aD6fs\u0016C\bO]3tg&|gn\u001d\u0011\t\u0011=\u0002!\u0011!Q\u0001\nA\nA\"Y4he\u0016<\u0017\r^5p]N\u00042!\t\u00132!\t9#'\u0003\u00024Q\t)\u0012iZ4sK\u001e\fG/[8o\u000bb\u0004(/Z:tS>t\u0007\"B\u001b\u0001\t\u00031\u0014A\u0002\u001fj]&$h\b\u0006\u00038qeR\u0004CA\b\u0001\u0011\u0015IB\u00071\u0001\u001b\u0011\u0015qB\u00071\u0001!\u0011\u0015yC\u00071\u00011\u0011\u001da\u0004A1A\u0005\u0002u\nqa]=nE>d7/F\u0001?!\ty\u0014)D\u0001A\u0015\taD!\u0003\u0002C\u0001\nY1+_7c_2$\u0016M\u00197f\u0011\u0019!\u0005\u0001)A\u0005}\u0005A1/_7c_2\u001c\b\u0005C\u0003G\u0001\u0011\u0005q)\u0001\u0007eKB,g\u000eZ3oG&,7/F\u0001I!\r\tC%\u0013\t\u0003\u007f)K!a\u0013!\u0003\u0015%#WM\u001c;jM&,'\u000fC\u0003N\u0001\u0011\u0005a*A\u0007de\u0016\fG/Z*z[\n|Gn\u001d\u000b\u0002}!)\u0001\u000b\u0001C\u0001#\u0006i1M]3bi\u0016\u0014Vm];miN,\"A\u0015:\u0015\u0005M\u0003\bc\u0001+]?:\u0011QK\u0017\b\u0003-fk\u0011a\u0016\u0006\u000312\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0005m#\u0012a\u00029bG.\fw-Z\u0005\u0003;z\u00131\u0002\u0016:bm\u0016\u00148/\u00192mK*\u00111\f\u0006\t\u0005A\u000e,W.D\u0001b\u0015\t\u0011'%A\u0004nkR\f'\r\\3\n\u0005\u0011\f'aA'baB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\u0005Y\u0006twMC\u0001k\u0003\u0011Q\u0017M^1\n\u00051<'AB*ue&tw\r\u0005\u0002\u0014]&\u0011q\u000e\u0006\u0002\u0004\u0003:L\b\"B9P\u0001\u0004y\u0016A\u00029be\u0006l7\u000fB\u0003t\u001f\n\u0007AOA\u0001V#\t)X\u000e\u0005\u0002\u0014m&\u0011q\u000f\u0006\u0002\b\u001d>$\b.\u001b8h\u0011\u0015I\b\u0001\"\u0011{\u00035)\u00070Z2vi&|g\u000e\u00157b]R\tQ\r")
public class OrderedAggregationPipe
extends PipeWithSource
implements ScalaObject {
    private final Pipe source;
    private final Seq<Expression> keyExpressions;
    private final Seq<AggregationExpression> aggregations;
    private final SymbolTable symbols;

    public Seq<Expression> keyExpressions() {
        return this.keyExpressions;
    }

    @Override
    public SymbolTable symbols() {
        return this.symbols;
    }

    @Override
    public Seq<Identifier> dependencies() {
        return (Seq)((TraversableLike)this.keyExpressions().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Identifier> apply(Expression expression2) {
                return expression2.dependencies(AnyType$.MODULE$.apply());
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.aggregations.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Identifier> apply(AggregationExpression aggregationExpression) {
                return aggregationExpression.dependencies(AnyType$.MODULE$.apply());
            }
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public SymbolTable createSymbols() {
        SymbolTable keySymbols = this.source.symbols().filter((Seq<String>)((Seq)this.keyExpressions().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Expression expression2) {
                return expression2.identifier().name();
            }
        }, Seq$.MODULE$.canBuildFrom())));
        Seq aggregateIdentifiers = (Seq)this.aggregations.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Identifier apply(AggregationExpression aggregationExpression) {
                return aggregationExpression.identifier();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return keySymbols.add((Seq<Identifier>)aggregateIdentifiers);
    }

    @Override
    public <U> Traversable<Map<String, Object>> createResults(Map<String, Object> params) {
        return new OrderedAggregator(this.source.createResults(params), this.keyExpressions(), this.aggregations);
    }

    @Override
    public String executionPlan() {
        return new StringBuilder().append((Object)this.source.executionPlan()).append((Object)"\r\n").append((Object)"EagerAggregation( keys: [").append((Object)((TraversableOnce)this.keyExpressions().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Expression expression2) {
                return expression2.identifier().name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")).append((Object)"], aggregates: [").append((Object)this.aggregations.mkString(", ")).append((Object)"])").toString();
    }

    public OrderedAggregationPipe(Pipe source, Seq<Expression> keyExpressions, Seq<AggregationExpression> aggregations) {
        this.source = source;
        this.keyExpressions = keyExpressions;
        this.aggregations = aggregations;
        super(source);
        if (keyExpressions.isEmpty()) {
            throw new ThisShouldNotHappenError("Andres Taylor", "The ordered aggregation pipe should never be used without aggregation keys");
        }
        this.symbols = this.createSymbols();
    }
}

