/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.testing.impl.driver;

import java.io.Serializable;
import org.neo4j.cypher.testing.api.Connection;
import org.neo4j.cypher.testing.api.Incoming;
import org.neo4j.cypher.testing.api.Outgoing;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Point;
import org.neo4j.driver.types.Relationship;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;

public final class DriverRecordConverter$ {
    public static final DriverRecordConverter$ MODULE$ = new DriverRecordConverter$();

    public Object convertValue(Value driverValue) {
        Object value = driverValue.asObject();
        return this.convertValue(value);
    }

    private Object convertValue(Object driverValue) {
        Object object = driverValue;
        if (object == null) {
            return null;
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            return this.convertNode(node);
        }
        if (object instanceof Relationship) {
            Relationship relationship = (Relationship)object;
            return this.convertRelationship(relationship);
        }
        if (object instanceof Path) {
            Path path = (Path)object;
            return this.convertPath(path);
        }
        if (object instanceof Point) {
            throw new IllegalStateException("Point type is not supported yet");
        }
        if (object instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object;
            return this.convertMap(map);
        }
        if (object instanceof java.util.List) {
            java.util.List list = (java.util.List)object;
            return this.convertList(list);
        }
        return object;
    }

    private org.neo4j.cypher.testing.api.Node convertNode(Node driverValue) {
        List labels = CollectionConverters$.MODULE$.IterableHasAsScala(driverValue.labels()).asScala().toList();
        Map<String, Object> properties = this.convertMap((MapAccessor)driverValue);
        return new org.neo4j.cypher.testing.api.Node(driverValue.id(), (Seq<String>)labels, properties);
    }

    private org.neo4j.cypher.testing.api.Relationship convertRelationship(Relationship driverValue) {
        Map<String, Object> properties = this.convertMap((MapAccessor)driverValue);
        return new org.neo4j.cypher.testing.api.Relationship(driverValue.id(), driverValue.type(), properties, driverValue.startNodeId(), driverValue.endNodeId());
    }

    private Map<String, Object> convertMap(MapAccessor driverValue) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(driverValue.keys()).asScala().map((Function1 & Serializable)key -> new Tuple2(key, MODULE$.convertValue(driverValue.get(key))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private org.neo4j.cypher.testing.api.Path convertPath(Path driverValue) {
        org.neo4j.cypher.testing.api.Node startNode = this.convertNode(driverValue.start());
        List connections = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)driverValue).asScala().toList().map((Function1 & Serializable)segment -> {
            Relationship relationship = segment.relationship();
            boolean outgoing = relationship.startNodeId() == segment.start().id();
            org.neo4j.cypher.testing.api.Relationship convertedRelationship = MODULE$.convertRelationship(relationship);
            org.neo4j.cypher.testing.api.Node endNode = MODULE$.convertNode(segment.end());
            if (outgoing) {
                return new Outgoing(convertedRelationship, endNode);
            }
            return new Incoming(convertedRelationship, endNode);
        });
        return new org.neo4j.cypher.testing.api.Path(startNode, (Seq<Connection>)connections);
    }

    private Map<String, Object> convertMap(java.util.Map<String, Object> driverValue) {
        return CollectionConverters$.MODULE$.MapHasAsScala(driverValue).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                return new Tuple2((Object)key, MODULE$.convertValue(value));
            }
            throw new MatchError((Object)tuple2);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Seq<Object> convertList(java.util.List<Object> driverValue2) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(driverValue2).asScala().map((Function1 & Serializable)driverValue -> MODULE$.convertValue(driverValue))).toList();
    }

    private DriverRecordConverter$() {
    }
}

