/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.testing.impl.embedded;

import java.io.Serializable;
import org.neo4j.cypher.testing.api.Connection;
import org.neo4j.cypher.testing.api.Incoming;
import org.neo4j.cypher.testing.api.Node;
import org.neo4j.cypher.testing.api.Outgoing;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.ObjectRef;

public final class EmbeddedRecordConverter$ {
    public static EmbeddedRecordConverter$ MODULE$;

    static {
        new EmbeddedRecordConverter$();
    }

    public Map<String, Object> convertMap(java.util.Map<String, Object> embeddedValue) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(embeddedValue).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, MODULE$.convertValue(value));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Object convertValue(Object embeddedValue) {
        Object object;
        Object object2 = embeddedValue;
        if (object2 == null) {
            object = null;
        } else if (object2 instanceof org.neo4j.graphdb.Node) {
            org.neo4j.graphdb.Node node = (org.neo4j.graphdb.Node)object2;
            object = this.convertNode(node);
        } else if (object2 instanceof Relationship) {
            Relationship relationship = (Relationship)object2;
            object = this.convertRelationship(relationship);
        } else if (object2 instanceof Path) {
            Path path = (Path)object2;
            object = this.convertPath(path);
        } else {
            if (object2 instanceof Point) {
                throw new IllegalStateException("Point type is not supported yet");
            }
            if (object2 instanceof java.util.Map) {
                java.util.Map map = (java.util.Map)object2;
                object = this.convertMap(map);
            } else if (object2 instanceof java.util.List) {
                java.util.List list = (java.util.List)object2;
                object = this.convertList(list);
            } else {
                object = object2;
            }
        }
        return object;
    }

    private Seq<Object> convertList(java.util.List<Object> embeddedValue2) {
        return (Seq)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(embeddedValue2).asScala()).toList().map((Function1 & Serializable & scala.Serializable)embeddedValue -> MODULE$.convertValue(embeddedValue), List$.MODULE$.canBuildFrom());
    }

    private Node convertNode(org.neo4j.graphdb.Node embeddedValue) {
        Map<String, Object> properties = this.convertMap(embeddedValue.getAllProperties());
        List labels = (List)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(embeddedValue.getLabels()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), List$.MODULE$.canBuildFrom());
        return new Node(embeddedValue.getId(), (Seq<String>)labels, properties);
    }

    private org.neo4j.cypher.testing.api.Relationship convertRelationship(Relationship embeddedValue) {
        Map<String, Object> properties = this.convertMap(embeddedValue.getAllProperties());
        String relType = embeddedValue.getType().name();
        return new org.neo4j.cypher.testing.api.Relationship(embeddedValue.getId(), relType, properties, embeddedValue.getStartNodeId(), embeddedValue.getEndNodeId());
    }

    private org.neo4j.cypher.testing.api.Path convertPath(Path embeddedValue) {
        Node startNode = this.convertNode(embeddedValue.startNode());
        ObjectRef latestNode = ObjectRef.create((Object)startNode);
        List connections = (List)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(embeddedValue.relationships()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)embeddedRelationship -> {
            Connection connection;
            org.neo4j.cypher.testing.api.Relationship relationship = MODULE$.convertRelationship((Relationship)embeddedRelationship);
            if (embeddedRelationship.getStartNodeId() == ((Node)latestNode$1.elem).id()) {
                latestNode$1.elem = MODULE$.convertNode(embeddedRelationship.getEndNode());
                connection = new Outgoing(relationship, (Node)latestNode$1.elem);
            } else {
                latestNode$1.elem = MODULE$.convertNode(embeddedRelationship.getStartNode());
                connection = new Incoming(relationship, (Node)latestNode$1.elem);
            }
            return connection;
        }, List$.MODULE$.canBuildFrom());
        return new org.neo4j.cypher.testing.api.Path(startNode, (Seq<Connection>)connections);
    }

    private EmbeddedRecordConverter$() {
        MODULE$ = this;
    }
}

