/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.testing.impl.driver;

import java.io.Serializable;
import org.neo4j.cypher.testing.api.Connection;
import org.neo4j.cypher.testing.api.Incoming;
import org.neo4j.cypher.testing.api.Outgoing;
import org.neo4j.cypher.testing.impl.driver.DriverRecordConverter;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Point;
import org.neo4j.driver.types.Relationship;
import org.neo4j.kernel.api.exceptions.Status;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;

public final class DriverRecordConverter$ {
    public static DriverRecordConverter$ MODULE$;

    static {
        new DriverRecordConverter$();
    }

    public Object convertValue(Value driverValue) {
        Object value = driverValue.asObject();
        return this.convertValue(value);
    }

    private Object convertValue(Object driverValue) {
        Object object;
        Object object2 = driverValue;
        if (object2 == null) {
            object = null;
        } else if (object2 instanceof Node) {
            Node node = (Node)object2;
            object = this.convertNode(node);
        } else if (object2 instanceof Relationship) {
            Relationship relationship = (Relationship)object2;
            object = this.convertRelationship(relationship);
        } else if (object2 instanceof Path) {
            Path path = (Path)object2;
            object = this.convertPath(path);
        } else {
            if (object2 instanceof Point) {
                throw new IllegalStateException("Point type is not supported yet");
            }
            if (object2 instanceof java.util.Map) {
                java.util.Map map = (java.util.Map)object2;
                object = this.convertMap(map);
            } else if (object2 instanceof java.util.List) {
                java.util.List list = (java.util.List)object2;
                object = this.convertList(list);
            } else {
                object = object2;
            }
        }
        return object;
    }

    private org.neo4j.cypher.testing.api.Node convertNode(Node driverValue) {
        List labels = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(driverValue.labels()).asScala()).toList();
        Map<String, Object> properties = this.convertMap((MapAccessor)driverValue);
        return new org.neo4j.cypher.testing.api.Node(driverValue.id(), (Seq<String>)labels, properties);
    }

    private org.neo4j.cypher.testing.api.Relationship convertRelationship(Relationship driverValue) {
        Map<String, Object> properties = this.convertMap((MapAccessor)driverValue);
        return new org.neo4j.cypher.testing.api.Relationship(driverValue.id(), driverValue.type(), properties, driverValue.startNodeId(), driverValue.endNodeId());
    }

    private Map<String, Object> convertMap(MapAccessor driverValue) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(driverValue.keys()).asScala()).map((Function1 & Serializable & scala.Serializable)key -> new Tuple2(key, MODULE$.convertValue(driverValue.get(key))), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private org.neo4j.cypher.testing.api.Path convertPath(Path driverValue) {
        org.neo4j.cypher.testing.api.Node startNode = this.convertNode(driverValue.start());
        List connections = (List)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)driverValue).asScala()).toList().map((Function1 & Serializable & scala.Serializable)segment -> {
            Relationship relationship = segment.relationship();
            boolean outgoing = relationship.startNodeId() == segment.start().id();
            org.neo4j.cypher.testing.api.Relationship convertedRelationship = MODULE$.convertRelationship(relationship);
            org.neo4j.cypher.testing.api.Node endNode = MODULE$.convertNode(segment.end());
            return outgoing ? new Outgoing(convertedRelationship, endNode) : new Incoming(convertedRelationship, endNode);
        }, List$.MODULE$.canBuildFrom());
        return new org.neo4j.cypher.testing.api.Path(startNode, (Seq<Connection>)connections);
    }

    private Map<String, Object> convertMap(java.util.Map<String, Object> driverValue) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(driverValue).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, MODULE$.convertValue(value));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Seq<Object> convertList(java.util.List<Object> driverValue2) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(driverValue2).asScala()).map((Function1 & Serializable & scala.Serializable)driverValue -> MODULE$.convertValue(driverValue), Iterable$.MODULE$.canBuildFrom())).toList();
    }

    public Throwable addStatus(Throwable throwable, Throwable rootThrowable) {
        Throwable throwable2;
        while (true) {
            Throwable throwable3;
            if ((throwable3 = throwable) == null) {
                throwable2 = rootThrowable;
                break;
            }
            if (throwable3 instanceof Neo4jException) {
                Neo4jException neo4jException = (Neo4jException)throwable3;
                Option status2 = ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)Status.Code.all()).asScala()).find((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)DriverRecordConverter$.$anonfun$addStatus$1(neo4jException, status)));
                Option maybeAddedStatus = status2.map((Function1 & Serializable & scala.Serializable)s -> new DriverRecordConverter.DriverException(neo4jException, (Status)s));
                throwable2 = (Throwable)maybeAddedStatus.getOrElse((Function0 & Serializable & scala.Serializable)() -> rootThrowable);
                break;
            }
            throwable = throwable.getCause();
        }
        return throwable2;
    }

    public static final /* synthetic */ boolean $anonfun$addStatus$1(Neo4jException x3$1, Status status) {
        String string = status.code().serialize();
        String string2 = x3$1.code();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private DriverRecordConverter$() {
        MODULE$ = this;
    }
}

