/*
 * Decompiled with CFR 0.152.
 */
package cypher.feature.parser.matchers;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Paths;

class TckSerializer {
    private final StringBuilder sb = new StringBuilder();

    private TckSerializer() {
    }

    static String serialize(Object obj) {
        return new TckSerializer().innerSerialize(obj);
    }

    private String innerSerialize(Object obj) {
        if (obj == null) {
            this.sb.append("null");
        } else if (obj instanceof Node) {
            Node n = (Node)obj;
            this.sb.append("(");
            n.getLabels().forEach(l -> this.sb.append(":").append(l.name()));
            this.sb.append(" {");
            String[] comma = new String[]{""};
            n.getAllProperties().forEach((k, v) -> {
                this.sb.append(comma[0]).append((String)k).append(": ").append(TckSerializer.serialize(v));
                comma[0] = ", ";
            });
            this.sb.append("})");
        } else if (obj instanceof Relationship) {
            Relationship r = (Relationship)obj;
            this.sb.append("[:");
            this.sb.append(r.getType().name());
            this.sb.append(" {");
            String[] comma = new String[]{""};
            r.getAllProperties().forEach((k, v) -> {
                this.sb.append(comma[0]).append((String)k).append(": ").append(TckSerializer.serialize(v));
                comma[0] = ", ";
            });
            this.sb.append("}]");
        } else if (obj instanceof Path) {
            Path p = (Path)obj;
            this.sb.append("<");
            this.sb.append(Paths.pathToString((Path)p, (Paths.PathDescriptor)new Paths.PathDescriptor<Path>(){

                public String nodeRepresentation(Path path, Node node) {
                    return TckSerializer.serialize(node);
                }

                public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
                    String prefix = "-";
                    String suffix = "-";
                    if (from.equals(relationship.getEndNode())) {
                        prefix = "<-";
                    } else {
                        suffix = "->";
                    }
                    return prefix + TckSerializer.serialize(relationship) + suffix;
                }
            }));
            this.sb.append(">");
        } else if (obj instanceof String) {
            this.sb.append("'").append(obj.toString()).append("'");
        } else if (obj instanceof List) {
            List list = (List)obj;
            ArrayList output = new ArrayList(list.size());
            list.forEach(item -> output.add(TckSerializer.serialize(item)));
            this.sb.append(output);
        } else if (obj.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(obj); ++i) {
                list.add(Array.get(obj, i));
            }
            this.sb.append(TckSerializer.serialize(list));
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            this.sb.append("{");
            String[] comma = new String[]{""};
            map.forEach((k, v) -> {
                this.sb.append(comma[0]).append(k).append(": ").append(TckSerializer.serialize(v));
                comma[0] = ", ";
            });
            this.sb.append("}");
        } else {
            this.sb.append(obj.toString());
        }
        return this.sb.toString();
    }
}

