/*
 * Decompiled with CFR 0.152.
 */
package cypher.feature.parser.matchers;

import cypher.feature.parser.matchers.TckSerializer;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;

public class ResultWrapper
implements Result {
    private final Result inner;
    private final StringBuilder builder;
    private int rowCounter = 1;

    public ResultWrapper(Result inner) {
        this.inner = inner;
        this.builder = new StringBuilder("Actual result of:\n");
    }

    public String toString() {
        return this.builder.toString();
    }

    public QueryExecutionType getQueryExecutionType() {
        return this.inner.getQueryExecutionType();
    }

    public List<String> columns() {
        return this.inner.columns();
    }

    public <T> ResourceIterator<T> columnAs(String name) {
        return this.inner.columnAs(name);
    }

    public boolean hasNext() {
        return this.inner.hasNext();
    }

    public Map<String, Object> next() {
        Map next = this.inner.next();
        this.builder.append("[").append(this.rowCounter++).append("]   ");
        this.builder.append("actualRow:");
        this.builder.append(TckSerializer.serialize(next));
        this.builder.append("\n");
        return next;
    }

    public void close() {
        this.inner.close();
    }

    public QueryStatistics getQueryStatistics() {
        return this.inner.getQueryStatistics();
    }

    public ExecutionPlanDescription getExecutionPlanDescription() {
        return this.inner.getExecutionPlanDescription();
    }

    public String resultAsString() {
        return this.inner.resultAsString();
    }

    public void writeAsStringTo(PrintWriter writer) {
        this.inner.writeAsStringTo(writer);
    }

    public void remove() {
        this.inner.remove();
    }

    public Iterable<Notification> getNotifications() {
        return this.inner.getNotifications();
    }

    public <VisitationException extends Exception> void accept(Result.ResultVisitor<VisitationException> visitor) throws VisitationException {
        this.inner.accept(new ResultVisitorWrapper(visitor));
    }

    public Stream<Map<String, Object>> stream() {
        return this.inner.stream();
    }

    public <R> ResourceIterator<R> map(Function<Map<String, Object>, R> map) {
        return this.inner.map(map);
    }

    public void forEachRemaining(Consumer<? super Map<String, Object>> action) {
        this.inner.forEachRemaining(action);
    }

    private class ResultRowWrapper
    implements Result.ResultRow {
        private final Result.ResultRow inner;

        private ResultRowWrapper(Result.ResultRow inner) {
            this.inner = inner;
        }

        public Node getNode(String key) {
            Node node = this.inner.getNode(key);
            ResultWrapper.this.builder.append(key).append("=").append(TckSerializer.serialize(node)).append(", ");
            return node;
        }

        public Relationship getRelationship(String key) {
            Relationship relationship = this.inner.getRelationship(key);
            ResultWrapper.this.builder.append(key).append("=").append(TckSerializer.serialize(relationship)).append(", ");
            return relationship;
        }

        public Object get(String key) {
            Object obj = this.inner.get(key);
            ResultWrapper.this.builder.append(key).append("=").append(TckSerializer.serialize(obj)).append(", ");
            return obj;
        }

        public String getString(String key) {
            String string = this.inner.getString(key);
            ResultWrapper.this.builder.append(key).append("=").append(TckSerializer.serialize(string)).append(", ");
            return string;
        }

        public Number getNumber(String key) {
            Number number = this.inner.getNumber(key);
            ResultWrapper.this.builder.append(key).append("=").append(TckSerializer.serialize(number)).append(", ");
            return number;
        }

        public Boolean getBoolean(String key) {
            Boolean aBoolean = this.inner.getBoolean(key);
            ResultWrapper.this.builder.append(key).append("=").append(TckSerializer.serialize(aBoolean)).append(", ");
            return aBoolean;
        }

        public Path getPath(String key) {
            Path path = this.inner.getPath(key);
            ResultWrapper.this.builder.append(key).append("=").append(TckSerializer.serialize(path)).append(", ");
            return path;
        }
    }

    private class ResultVisitorWrapper<T extends Exception>
    implements Result.ResultVisitor<T> {
        private final Result.ResultVisitor<T> inner;

        private ResultVisitorWrapper(Result.ResultVisitor<T> visitor) {
            this.inner = visitor;
        }

        public boolean visit(Result.ResultRow row) throws T {
            ResultWrapper.this.builder.append("[").append(ResultWrapper.this.rowCounter++).append("]   ");
            ResultWrapper.this.builder.append("actualRow: {");
            boolean result = this.inner.visit((Result.ResultRow)new ResultRowWrapper(row));
            ResultWrapper.this.builder.delete(ResultWrapper.this.builder.length() - 2, ResultWrapper.this.builder.length());
            ResultWrapper.this.builder.append("}\n");
            return result;
        }
    }
}

