/*
 * Decompiled with CFR 0.152.
 */
package cypher.feature.parser.matchers;

import cypher.feature.parser.matchers.Matcher;
import cypher.feature.parser.matchers.RowMatcher;
import cypher.feature.parser.matchers.UnorderedListMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Result;

public class ResultMatcher
implements Matcher<Result> {
    private final List<RowMatcher> rowMatchers;

    public ResultMatcher(List<RowMatcher> rowMatchers) {
        this.rowMatchers = rowMatchers;
    }

    @Override
    public boolean matches(Result value) {
        ArrayList<RowMatcher> mutableCopy = new ArrayList<RowMatcher>(this.rowMatchers);
        boolean[] matched = new boolean[]{true};
        List columns = value.columns();
        value.accept(row -> {
            HashMap<String, Object> nextRow = new HashMap<String, Object>(columns.size());
            for (String col : columns) {
                nextRow.put(col, row.get(col));
            }
            int index = UnorderedListMatcher.findMatch(mutableCopy, nextRow);
            if (index < 0) {
                matched[0] = false;
                return true;
            }
            mutableCopy.remove(index);
            return true;
        });
        boolean nothingLeftInMatcher = mutableCopy.isEmpty();
        return matched[0] && nothingLeftInMatcher;
    }

    public boolean matchesOrdered(Result value) {
        int[] counter = new int[]{0};
        boolean[] matched = new boolean[]{true};
        List columns = value.columns();
        value.accept(row -> {
            HashMap<String, Object> nextRow = new HashMap<String, Object>(columns.size());
            for (String col : columns) {
                nextRow.put(col, row.get(col));
            }
            if (counter[0] >= this.rowMatchers.size()) {
                matched[0] = false;
                return true;
            }
            int n = counter[0];
            counter[0] = n + 1;
            matched[0] = matched[0] & this.rowMatchers.get(n).matches((Map<String, Object>)nextRow);
            return true;
        });
        boolean nothingLeftInMatcher = counter[0] == this.rowMatchers.size();
        return matched[0] && nothingLeftInMatcher;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Expected result of:\n");
        int i = 1;
        for (RowMatcher row : this.rowMatchers) {
            sb.append("[").append(i++).append("] ").append(row).append("\n");
        }
        return sb.toString();
    }
}

