/*
 * Decompiled with CFR 0.152.
 */
package cypher.feature.parser.matchers;

import cypher.feature.parser.matchers.MapMatcher;
import cypher.feature.parser.matchers.ValueMatcher;
import org.neo4j.graphdb.Relationship;

public class RelationshipMatcher
implements ValueMatcher {
    private final String relationshipTypeName;
    private final MapMatcher propertyMatcher;

    public RelationshipMatcher(String relationshipTypeName, MapMatcher propertyMatcher) {
        this.relationshipTypeName = relationshipTypeName;
        this.propertyMatcher = propertyMatcher;
    }

    @Override
    public boolean matches(Object value) {
        if (value instanceof Relationship) {
            Relationship relationship = (Relationship)value;
            return relationship.getType().name().equals(this.relationshipTypeName) && this.propertyMatcher.matches(relationship.getAllProperties());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[:").append(this.relationshipTypeName);
        sb.append(" ").append(this.propertyMatcher).append("]");
        return sb.toString();
    }
}

