/*
 * Decompiled with CFR 0.152.
 */
package cypher.feature.parser.matchers;

import cypher.feature.parser.matchers.NodeMatcher;
import cypher.feature.parser.matchers.PathLinkMatcher;
import cypher.feature.parser.matchers.ValueMatcher;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;

public class PathMatcher
implements ValueMatcher {
    private final NodeMatcher singleNodePath;
    private final List<PathLinkMatcher> pathLinks;

    public PathMatcher(List<PathLinkMatcher> pathLinks) {
        this.pathLinks = pathLinks;
        this.singleNodePath = null;
    }

    public PathMatcher(NodeMatcher pathNode) {
        this.singleNodePath = pathNode;
        this.pathLinks = Collections.emptyList();
    }

    @Override
    public boolean matches(Object value) {
        if (value instanceof Path) {
            Path path = (Path)value;
            if (path.length() != this.pathLinks.size()) {
                return false;
            }
            if (this.pathLinks.isEmpty()) {
                return path.length() == 0 && this.singleNodePath.matches(path.startNode()) && this.singleNodePath.matches(path.endNode());
            }
            Iterator relationships = path.relationships().iterator();
            for (PathLinkMatcher pathLink : this.pathLinks) {
                Relationship next;
                if (pathLink.matches(next = (Relationship)relationships.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.pathLinks.isEmpty()) {
            return "<" + this.singleNodePath + ">";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        this.pathLinks.forEach(sb::append);
        sb.append(">");
        return sb.toString();
    }
}

