/*
 * Decompiled with CFR 0.152.
 */
package cypher.feature.parser;

import cypher.feature.parser.matchers.BooleanMatcher;
import cypher.feature.parser.matchers.FloatMatcher;
import cypher.feature.parser.matchers.IntegerMatcher;
import cypher.feature.parser.matchers.ListMatcher;
import cypher.feature.parser.matchers.MapMatcher;
import cypher.feature.parser.matchers.NodeMatcher;
import cypher.feature.parser.matchers.PathLinkMatcher;
import cypher.feature.parser.matchers.PathMatcher;
import cypher.feature.parser.matchers.RelationshipMatcher;
import cypher.feature.parser.matchers.StringMatcher;
import cypher.feature.parser.matchers.UnorderedListMatcher;
import cypher.feature.parser.matchers.ValueMatcher;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.opencypher.tools.tck.parsing.generated.FeatureResultsBaseListener;
import org.opencypher.tools.tck.parsing.generated.FeatureResultsParser;

class CypherMatchersCreator
extends FeatureResultsBaseListener {
    private final Deque<ValueMatcher> workload = new LinkedList<ValueMatcher>();
    private final Deque<Integer> listCounters;
    private final Deque<Integer> mapCounters;
    private final Deque<String> keys = new LinkedList<String>();
    private final Deque<String> names;
    private final Deque<PathLinkMatcher> pathElements;
    private boolean unorderedLists = false;
    private static final String INFINITY = "Inf";

    CypherMatchersCreator() {
        this.listCounters = new LinkedList<Integer>();
        this.mapCounters = new LinkedList<Integer>();
        this.names = new LinkedList<String>();
        this.pathElements = new LinkedList<PathLinkMatcher>();
    }

    ValueMatcher parsed() {
        return this.workload.pop();
    }

    CypherMatchersCreator setLists(boolean unordered) {
        this.unorderedLists = unordered;
        return this;
    }

    public void enterInteger(FeatureResultsParser.IntegerContext ctx) {
        this.workload.push(new IntegerMatcher(Long.valueOf(ctx.getText())));
    }

    public void enterNullValue(FeatureResultsParser.NullValueContext ctx) {
        this.workload.push(ValueMatcher.NULL_MATCHER);
    }

    public void enterFloatingPoint(FeatureResultsParser.FloatingPointContext ctx) {
        String text = ctx.getText();
        if (text.contains(INFINITY)) {
            this.workload.push(new FloatMatcher(Double.parseDouble(text + "inity")));
        } else {
            this.workload.push(new FloatMatcher(Double.parseDouble(text)));
        }
    }

    public void enterBool(FeatureResultsParser.BoolContext ctx) {
        this.workload.push(new BooleanMatcher(Boolean.valueOf(ctx.getText())));
    }

    public void enterString(FeatureResultsParser.StringContext ctx) {
        String text = ctx.getText();
        String substring = text.substring(1, text.length() - 1);
        String escaped = substring.replace("\\'", "'");
        this.workload.push(new StringMatcher(escaped));
    }

    public void enterList(FeatureResultsParser.ListContext ctx) {
        this.listCounters.push(0);
    }

    public void enterListElement(FeatureResultsParser.ListElementContext ctx) {
        this.listCounters.push(this.listCounters.pop() + 1);
    }

    public void exitList(FeatureResultsParser.ListContext ctx) {
        LinkedList<ValueMatcher> temp = new LinkedList<ValueMatcher>();
        int counter = this.listCounters.pop();
        for (int i = 0; i < counter; ++i) {
            temp.addFirst(this.workload.pop());
        }
        if (this.unorderedLists) {
            this.workload.push(new UnorderedListMatcher(temp));
        } else {
            this.workload.push(new ListMatcher(temp));
        }
    }

    public void enterPropertyMap(FeatureResultsParser.PropertyMapContext ctx) {
        this.mapCounters.push(0);
    }

    public void enterKeyValuePair(FeatureResultsParser.KeyValuePairContext ctx) {
        this.mapCounters.push(this.mapCounters.pop() + 1);
    }

    public void exitPropertyMap(FeatureResultsParser.PropertyMapContext ctx) {
        int counter = this.mapCounters.pop();
        HashMap<String, ValueMatcher> map = new HashMap<String, ValueMatcher>();
        for (int i = 0; i < counter; ++i) {
            ValueMatcher value = this.workload.pop();
            String key = this.keys.pop();
            map.put(key, value);
        }
        this.workload.push(new MapMatcher(map));
    }

    public void enterPropertyKey(FeatureResultsParser.PropertyKeyContext ctx) {
        this.keys.push(ctx.getText());
    }

    public void enterLabelName(FeatureResultsParser.LabelNameContext ctx) {
        this.names.push(ctx.getText());
    }

    public void exitNodeDesc(FeatureResultsParser.NodeDescContext ctx) {
        MapMatcher properties = this.getMapMatcher();
        HashSet<String> labelNames = new HashSet<String>();
        while (!this.names.isEmpty()) {
            labelNames.add(this.names.pop());
        }
        this.workload.push(new NodeMatcher(labelNames, properties));
    }

    private MapMatcher getMapMatcher() {
        if (this.workload.peek() instanceof MapMatcher) {
            return (MapMatcher)this.workload.pop();
        }
        return MapMatcher.EMPTY;
    }

    public void enterRelationshipTypeName(FeatureResultsParser.RelationshipTypeNameContext ctx) {
        this.names.push(ctx.getText());
    }

    public void exitRelationshipDesc(FeatureResultsParser.RelationshipDescContext ctx) {
        MapMatcher properties = this.getMapMatcher();
        String relTypeName = this.names.pop();
        this.workload.push(new RelationshipMatcher(relTypeName, properties));
    }

    public void exitForwardsRelationship(FeatureResultsParser.ForwardsRelationshipContext ctx) {
        this.constructPartialPathLink(true);
    }

    public void exitBackwardsRelationship(FeatureResultsParser.BackwardsRelationshipContext ctx) {
        this.constructPartialPathLink(false);
    }

    private void constructPartialPathLink(boolean outgoing) {
        RelationshipMatcher relMatcher = (RelationshipMatcher)this.workload.pop();
        NodeMatcher startNode = (NodeMatcher)this.workload.pop();
        this.pathElements.push(new PathLinkMatcher(relMatcher, startNode, outgoing));
    }

    public void exitPathLink(FeatureResultsParser.PathLinkContext ctx) {
        NodeMatcher nodeMatcher = (NodeMatcher)this.workload.peek();
        this.pathElements.peek().setRightNode(nodeMatcher);
    }

    public void exitPath(FeatureResultsParser.PathContext ctx) {
        NodeMatcher singleNodePath = (NodeMatcher)this.workload.pop();
        if (this.pathElements.isEmpty()) {
            this.workload.push(new PathMatcher(singleNodePath));
        } else {
            ArrayList<PathLinkMatcher> pathLinkMatchers = new ArrayList<PathLinkMatcher>();
            this.pathElements.descendingIterator().forEachRemaining(pathLinkMatchers::add);
            this.pathElements.clear();
            this.workload.push(new PathMatcher(pathLinkMatchers));
        }
    }
}

