/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.cucumber.user.function;

import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;
import org.neo4j.values.AnyValue;

public class TestFailNTimesFunction {
    public static final QualifiedName name = new QualifiedName("test", "failNTimes");
    @Context
    public State state;

    @UserFunction(value="test.failNTimes")
    @Description(value="Throws an exception the first <n> times it is called for a given value of <key>")
    public AnyValue failNTimes(@Name(value="n") long n, @Name(value="key") AnyValue key, @Name(value="exceptionType") String exceptionType) {
        long i = this.state.incrementAndGet(key);
        FailNTimesException.ExceptionType et = switch (exceptionType) {
            case "client" -> FailNTimesException.ExceptionType.CLIENT;
            case "transient" -> FailNTimesException.ExceptionType.TRANSIENT;
            default -> throw new IllegalArgumentException("exceptionType");
        };
        if (i <= n) {
            throw new FailNTimesException(i, n, et);
        }
        return key;
    }

    public static class State {
        private final ConcurrentHashMap<AnyValue, Long> map = new ConcurrentHashMap();

        public long incrementAndGet(AnyValue key) {
            return this.map.compute(key, (_k, value) -> value == null ? 1L : value + 1L);
        }
    }

    public static class FailNTimesException
    extends RuntimeException
    implements Status.HasStatus {
        private final ExceptionType type;

        public FailNTimesException(Long i, Long n, ExceptionType type) {
            super("Failing " + i + "/" + n);
            this.type = type;
        }

        public Status status() {
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Status.Transaction.Outdated;
                case 1 -> Status.Statement.SyntaxError;
            };
        }

        public static enum ExceptionType {
            TRANSIENT,
            CLIENT;

        }
    }
}

