/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.cucumber.synthesise.generator;

import io.cucumber.datatable.DataTable;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.neo4j.cypher.cucumber.steps.CypherCucumberSteps;
import org.neo4j.cypher.cucumber.synthesise.generator.GeneratedScenario;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.AnyOrder$;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.AnyOrderUnorderedLists$;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.AssertError;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.AssertGqlError;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.AssertResults;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.Comment;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.CommitTransaction$;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.CreateCsvFile;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.Execute;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.ExecuteControl;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.ExecuteControlInOpenTx;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.ExecuteInOpenTx;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.ExpectError;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.HavingExecuted;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.HavingExecutedInOpenTx;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.OpenTransaction$;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.Order$;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.OrderUnorderedLists$;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.QueryExecution;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.RecordedStep;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.RegisterProcedure;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.RegisterUserFunction;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.ResultOrder;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.SetParams;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.SideEffects;
import org.neo4j.cypher.cucumber.synthesise.glue.scenario.TransactionHandling;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005!4qa\u0002\u0005\u0011\u0002\u0007\u0005Q\u0003C\u0003\u001d\u0001\u0011\u0005Q\u0004C\u0003\"\u0001\u0011\u0005!\u0005C\u00036\u0001\u0011%a\u0007C\u0003?\u0001\u0011%q\bC\u0003P\u0001\u0011%\u0001\u000bC\u0003^\u0001\u0011%aL\u0001\tTG\u0016t\u0017M]5p%\u0016tG-\u001a:fe*\u0011\u0011BC\u0001\nO\u0016tWM]1u_JT!a\u0003\u0007\u0002\u0015MLh\u000e\u001e5fg&\u001cXM\u0003\u0002\u000e\u001d\u0005A1-^2v[\n,'O\u0003\u0002\u0010!\u000511-\u001f9iKJT!!\u0005\n\u0002\u000b9,w\u000e\u000e6\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\ta\u0004\u0005\u0002\u0018?%\u0011\u0001\u0005\u0007\u0002\u0005+:LG/A\u0007xe&$XmU2f]\u0006\u0014\u0018n\u001c\u000b\u0004=\rz\u0003\"\u0002\u0013\u0003\u0001\u0004)\u0013a\u00013jeB\u0011a%L\u0007\u0002O)\u0011\u0001&K\u0001\u0005M&dWM\u0003\u0002+W\u0005\u0019a.[8\u000b\u00031\nAA[1wC&\u0011af\n\u0002\u0005!\u0006$\b\u000eC\u00031\u0005\u0001\u0007\u0011'\u0001\u0005tG\u0016t\u0017M]5p!\t\u00114'D\u0001\t\u0013\t!\u0004BA\tHK:,'/\u0019;fIN\u001bWM\\1sS>\faB]3oI\u0016\u00148kY3oCJLw\u000e\u0006\u00028{A\u0011\u0001hO\u0007\u0002s)\u0011!hK\u0001\u0005Y\u0006tw-\u0003\u0002=s\ta1\t[1s'\u0016\fX/\u001a8dK\")\u0001g\u0001a\u0001c\u0005YAO]5qY\u0016\fVo\u001c;f)\r\u00015*\u0014\t\u0003\u0003\"s!A\u0011$\u0011\u0005\rCR\"\u0001#\u000b\u0005\u0015#\u0012A\u0002\u001fs_>$h(\u0003\u0002H1\u00051\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9\u0005\u0004C\u0003M\t\u0001\u0007\u0001)\u0001\u0004bGRLwN\u001c\u0005\u0006\u001d\u0012\u0001\r\u0001Q\u0001\u0006m\u0006dW/Z\u0001\u0007e\u0016tG-\u001a:\u0015\u0007\u0001\u000b6\u000bC\u0003S\u000b\u0001\u0007\u0001)A\u0004iK\u0006$\u0017N\\4\t\u000b9+\u0001\u0019\u0001+\u0011\u0005U[V\"\u0001,\u000b\u0005]C\u0016!\u00033bi\u0006$\u0018M\u00197f\u0015\ti\u0011LC\u0001[\u0003\tIw.\u0003\u0002]-\nIA)\u0019;b)\u0006\u0014G.Z\u0001\u000be\u0016tG-\u001a:Ti\u0016\u0004HC\u0001!`\u0011\u0015\u0001g\u00011\u0001b\u0003\u0011\u0019H/\u001a9\u0011\u0005\t4W\"A2\u000b\u0005A\"'BA3\u000b\u0003\u00119G.^3\n\u0005\u001d\u001c'\u0001\u0004*fG>\u0014H-\u001a3Ti\u0016\u0004\b")
public interface ScenarioRenderer {
    public static /* synthetic */ void writeScenario$(ScenarioRenderer $this, Path dir, GeneratedScenario scenario) {
        $this.writeScenario(dir, scenario);
    }

    default public void writeScenario(Path dir, GeneratedScenario scenario) {
        Path path = dir.resolve(scenario.featurePath());
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String header = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("# This file contains generated test cases.\n           >Feature: " + ((Object)path.getFileName()).toString().replace(".feature", "") + "\n           >\n           >"), '>');
            v0 = Files.writeString(path, (CharSequence)header, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        Files.writeString(path, this.renderScenario(scenario), StandardOpenOption.WRITE, StandardOpenOption.APPEND);
    }

    private CharSequence renderScenario(GeneratedScenario scenario) {
        StringBuilder res = new StringBuilder();
        StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(scenario.comment())).foreach((Function1 & Serializable)l -> res.append("  # ").append(l).append("\n"));
        scenario.tags().foreach((Function1 & Serializable)tag -> res.append("  ").append(tag).append("\n"));
        StringBuilder stringBuilder = scenario.examples().isEmpty() ? res.append("  Scenario: ") : res.append("  Scenario Template: ");
        res.append(scenario.name()).append("\n");
        scenario.steps().view().map((Function1 & Serializable)step -> this.renderStep((RecordedStep)step)).foreach((Function1 & Serializable)step -> res.append(StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(step)).mkString("    ", "\n      ", "\n")));
        scenario.examples().foreach((Function1 & Serializable)examples -> res.append("    Examples:").append("\n").append(StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(examples.toString())).mkString("      ", "\n      ", "\n")));
        return res.append("\n");
    }

    private String tripleQuote(String action, String value) {
        return action + "\n\"\"\"\n" + value.trim() + "\n\"\"\"";
    }

    private String render(String heading, DataTable value) {
        return heading + "\n" + (value.isEmpty() ? "|" : value.toString().trim());
    }

    private String renderStep(RecordedStep step) {
        boolean bl = false;
        AssertResults assertResults = null;
        boolean bl2 = false;
        SideEffects sideEffects = null;
        RecordedStep recordedStep = step;
        if (recordedStep instanceof QueryExecution) {
            QueryExecution queryExecution = (QueryExecution)recordedStep;
            QueryExecution queryExecution2 = queryExecution;
            if (queryExecution2 instanceof HavingExecuted) {
                HavingExecuted havingExecuted = (HavingExecuted)queryExecution2;
                String cypher = havingExecuted.cypher();
                return this.tripleQuote("And having executed:", cypher);
            }
            if (queryExecution2 instanceof HavingExecutedInOpenTx) {
                HavingExecutedInOpenTx havingExecutedInOpenTx = (HavingExecutedInOpenTx)queryExecution2;
                String cypher = havingExecutedInOpenTx.cypher();
                return this.tripleQuote("And having executed, in open tx:", cypher);
            }
            if (queryExecution2 instanceof Execute) {
                Execute execute = (Execute)queryExecution2;
                String cypher = execute.cypher();
                return this.tripleQuote("When executing query:", cypher);
            }
            if (queryExecution2 instanceof ExecuteInOpenTx) {
                ExecuteInOpenTx executeInOpenTx = (ExecuteInOpenTx)queryExecution2;
                String cypher = executeInOpenTx.cypher();
                return this.tripleQuote("When executing query, in open tx:", cypher);
            }
            if (queryExecution2 instanceof ExecuteControl) {
                ExecuteControl executeControl = (ExecuteControl)queryExecution2;
                String cypher = executeControl.cypher();
                return this.tripleQuote("When executing control query:", cypher);
            }
            if (queryExecution2 instanceof ExecuteControlInOpenTx) {
                ExecuteControlInOpenTx executeControlInOpenTx = (ExecuteControlInOpenTx)queryExecution2;
                String cypher = executeControlInOpenTx.cypher();
                return this.tripleQuote("When executing control query, in open tx:", cypher);
            }
            throw new MatchError((Object)queryExecution2);
        }
        if (recordedStep instanceof TransactionHandling) {
            TransactionHandling transactionHandling = (TransactionHandling)recordedStep;
            TransactionHandling transactionHandling2 = transactionHandling;
            if (OpenTransaction$.MODULE$.equals(transactionHandling2)) {
                return "Given an open transaction";
            }
            if (CommitTransaction$.MODULE$.equals(transactionHandling2)) {
                return "Then open transaction should commit without errors";
            }
            throw new MatchError((Object)transactionHandling2);
        }
        if (recordedStep instanceof SetParams) {
            SetParams setParams = (SetParams)recordedStep;
            Map<String, String> params = setParams.params();
            return this.render("And parameters are:", DataTable.create((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)params.toSeq().map((Function1 & Serializable)t -> List.of(t._1(), t._2()))).asJava()));
        }
        if (recordedStep instanceof AssertResults) {
            bl = true;
            assertResults = (AssertResults)recordedStep;
            DataTable expected = assertResults.expected();
            if (expected.isEmpty()) {
                return "Then the result should be empty";
            }
        }
        if (bl) {
            String string;
            DataTable expected = assertResults.expected();
            ResultOrder order = assertResults.order();
            ResultOrder resultOrder = order;
            if (Order$.MODULE$.equals(resultOrder)) {
                string = ", in order";
            } else if (AnyOrder$.MODULE$.equals(resultOrder)) {
                string = ", in any order";
            } else if (OrderUnorderedLists$.MODULE$.equals(resultOrder)) {
                string = ", in order (ignoring element order for lists)";
            } else if (AnyOrderUnorderedLists$.MODULE$.equals(resultOrder)) {
                string = " (ignoring element order for lists)";
            } else {
                throw new MatchError((Object)resultOrder);
            }
            String orderString = string;
            return this.render("Then the result should be" + orderString + ":", expected);
        }
        if (recordedStep instanceof ExpectError) {
            CypherCucumberSteps.ExpectedGqlError expectedGqlError;
            AssertError assertError;
            CypherCucumberSteps.ExpectedError expectedError;
            ExpectError expectError = (ExpectError)recordedStep;
            boolean bl3 = false;
            AssertGqlError assertGqlError = null;
            ExpectError expectError2 = expectError;
            if (expectError2 instanceof AssertError && (expectedError = (assertError = (AssertError)expectError2).expected()) != null) {
                String error = expectedError.error();
                Option<String> description = expectedError.description();
                Option<String> phase = expectedError.phase();
                return "a " + error + " should be raised at " + phase + ": " + description;
            }
            if (expectError2 instanceof AssertGqlError) {
                bl3 = true;
                assertGqlError = (AssertGqlError)expectError2;
                CypherCucumberSteps.ExpectedGqlError expectedGqlError2 = assertGqlError.expected();
                if (expectedGqlError2 != null) {
                    String code = expectedGqlError2.code();
                    Option<String> option = expectedGqlError2.descriptionContains();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String desc = (String)some.value();
                        return this.tripleQuote("execution should fail with GQL code " + code + " and message containing:", desc);
                    }
                }
            }
            if (bl3 && (expectedGqlError = assertGqlError.expected()) != null) {
                String code = expectedGqlError.code();
                Option<String> option = expectedGqlError.descriptionContains();
                if (None$.MODULE$.equals(option)) {
                    return "Then execution should fail with GQL code " + code;
                }
            }
            throw new MatchError((Object)expectError2);
        }
        if (recordedStep instanceof SideEffects) {
            bl2 = true;
            sideEffects = (SideEffects)recordedStep;
            DataTable expected = sideEffects.expected();
            if (expected.isEmpty()) {
                return "And no side effects";
            }
        }
        if (bl2) {
            DataTable expected = sideEffects.expected();
            return this.render("And the side effects should be:", expected);
        }
        if (recordedStep instanceof Comment) {
            Comment comment = (Comment)recordedStep;
            String comment2 = comment.comment();
            return "# " + comment2;
        }
        if (recordedStep instanceof RegisterProcedure) {
            RegisterProcedure registerProcedure = (RegisterProcedure)recordedStep;
            String signature = registerProcedure.signature();
            DataTable results = registerProcedure.results();
            return this.render("And there exists a procedure " + signature + ":", results);
        }
        if (recordedStep instanceof CreateCsvFile) {
            CreateCsvFile createCsvFile = (CreateCsvFile)recordedStep;
            String param = createCsvFile.urlParam();
            DataTable table = createCsvFile.content();
            return this.render("And there exists a CSV file with URL as $" + param + ", with rows:", table);
        }
        if (recordedStep instanceof RegisterUserFunction) {
            RegisterUserFunction registerUserFunction = (RegisterUserFunction)recordedStep;
            String name = registerUserFunction.name();
            return "And the " + name + " function is registered";
        }
        throw new MatchError((Object)recordedStep);
    }

    public static void $init$(ScenarioRenderer $this) {
    }
}

