/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.cucumber.glue.regular;

import io.cucumber.datatable.DataTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.neo4j.cypher.cucumber.glue.regular.RegularCypherCucumberSteps;
import org.neo4j.cypher.cucumber.glue.regular.TestConf;
import org.neo4j.cypher.cucumber.value.CypherCucumberValueParser$;
import org.neo4j.cypher.testing.api.ConsumedResult;
import org.neo4j.cypher.testing.api.CypherExecutorException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.helpers.Exceptions;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;

public final class RegularCypherCucumberSteps$ {
    public static final RegularCypherCucumberSteps$ MODULE$ = new RegularCypherCucumberSteps$();

    public List<List<Object>> toResultRows(DataTable table) {
        if (table.isEmpty()) {
            return List.of();
        }
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(table.height() - 1);
        List cells = table.cells();
        for (int i = 1; i < cells.size(); ++i) {
            List row = (List)cells.get(i);
            ArrayList<Object> parsedRow = new ArrayList<Object>(row.size());
            for (int j = 0; j < row.size(); ++j) {
                parsedRow.add(CypherCucumberValueParser$.MODULE$.parse((String)row.get(j)));
            }
            result.add(parsedRow);
        }
        return result;
    }

    public String renderAsTable(ConsumedResult results) {
        ArrayList<List> table = new ArrayList<List>(results.rows().size() + 1);
        table.add(results.headers());
        results.rows().forEach(row -> table.add(row.stream().map(v -> Objects.toString(v)).toList()));
        return DataTable.create(table).toString();
    }

    public String describeConf(TestConf conf) {
        return ((IterableOnceOps)conf.neo4jConf().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return key + "=" + value;
            }
            throw new MatchError((Object)tuple2);
        })).mkString("\n");
    }

    public void unexpectedFailure(RegularCypherCucumberSteps.QueryFailure failure, TestConf conf) {
        Assertions.fail((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |Query failed but was expected to succeed.\n       |Phase: " + failure.phase() + "\n       |Query:\n       |" + failure.query() + "\n       |\n       |Cause: " + Exceptions.stringify((Throwable)this.originalError(failure.cause())) + "\n       |\n       |Config (excl tag based config, @conf:...):\n       |" + this.describeConf(conf) + "\n       |")));
    }

    public void unexpectedSuccess(RegularCypherCucumberSteps.QueryResults results, TestConf conf) {
        Assertions.fail((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       >Query was expected to fail, but executed successfully.\n       >\n       >Results:\n       >" + this.renderAsTable(results.results()) + "\n       >Query:\n       >" + results.query() + "\n       >\n       >Config (excl tag based config, @conf:...):\n       >" + this.describeConf(conf) + "\n       |"), '>'));
    }

    public Throwable originalError(Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof CypherExecutorException) {
            CypherExecutorException cypherExecutorException = (CypherExecutorException)throwable2;
            return cypherExecutorException.original();
        }
        return throwable;
    }

    public Option<RegularCypherCucumberSteps.GqlFailure> findMatchingGqlFailure(String code, Object throwable) {
        while (true) {
            boolean bl = false;
            Neo4jException neo4jException = null;
            boolean bl2 = false;
            ErrorGqlStatusObject errorGqlStatusObject = null;
            Object object = throwable;
            if (object instanceof Neo4jException) {
                bl = true;
                neo4jException = (Neo4jException)object;
                String string = neo4jException.gqlStatus();
                String string2 = code;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return new Some((Object)new RegularCypherCucumberSteps.GqlFailure(neo4jException.gqlStatus(), neo4jException.statusDescription(), neo4jException.getMessage()));
                }
            }
            if (bl) {
                throwable = neo4jException.gqlCause().orElse(null);
                continue;
            }
            if (object instanceof ErrorGqlStatusObject) {
                bl2 = true;
                errorGqlStatusObject = (ErrorGqlStatusObject)object;
                String string = errorGqlStatusObject.gqlStatus();
                String string3 = code;
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    return new Some((Object)new RegularCypherCucumberSteps.GqlFailure(errorGqlStatusObject.gqlStatus(), errorGqlStatusObject.statusDescription(), errorGqlStatusObject.getMessage()));
                }
            }
            if (!bl2) break;
            throwable = errorGqlStatusObject.cause().orElse(null);
        }
        return None$.MODULE$;
    }

    public Seq<String> findAllGqlCodes(Object throwable, Seq<String> result) {
        while (true) {
            Object object;
            if ((object = throwable) instanceof Neo4jException) {
                Neo4jException neo4jException = (Neo4jException)object;
                result = (Seq)result.appended((Object)neo4jException.gqlStatus());
                throwable = neo4jException.gqlCause().orElse(null);
                continue;
            }
            if (!(object instanceof ErrorGqlStatusObject)) break;
            ErrorGqlStatusObject errorGqlStatusObject = (ErrorGqlStatusObject)object;
            result = (Seq)result.appended((Object)errorGqlStatusObject.gqlStatus());
            throwable = errorGqlStatusObject.cause().orElse(null);
        }
        return result;
    }

    public Seq<String> findAllGqlCodes$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Supplier<String> org$neo4j$cypher$cucumber$glue$regular$RegularCypherCucumberSteps$$describeFailure(RegularCypherCucumberSteps.QueryFailure failure) {
        return () -> "Query failure (you need to scroll past the stacktrace for actual assertion error).\n" + MODULE$.org$neo4j$cypher$cucumber$glue$regular$RegularCypherCucumberSteps$$doDescribeFailure(failure);
    }

    public String org$neo4j$cypher$cucumber$glue$regular$RegularCypherCucumberSteps$$doDescribeFailure(RegularCypherCucumberSteps.QueryFailure failure) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |Phase: " + failure.phase() + "\n       |Query:\n       |" + failure.query() + "\n       |\n       |Cause: " + Exceptions.stringify((Throwable)this.originalError(failure.cause())) + "\n       |"));
    }

    private RegularCypherCucumberSteps$() {
    }
}

