/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.cucumber.glue.regular;

import io.cucumber.scala.Scenario;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.cucumber.glue.regular.DbAccessor;
import org.neo4j.cypher.cucumber.glue.regular.ExecutorPool$;
import org.neo4j.cypher.cucumber.glue.regular.Executors;
import org.neo4j.cypher.cucumber.glue.regular.TestConf;
import org.neo4j.cypher.cucumber.util.KernelOperation$;
import org.neo4j.cypher.testing.api.CypherExecutorFactory;
import org.neo4j.cypher.testing.impl.FeatureDatabaseManagementService;
import org.neo4j.cypher.testing.impl.FeatureDatabaseManagementService$;
import org.neo4j.cypher.testing.impl.driver.DriverCypherExecutorFactory;
import org.neo4j.cypher.testing.impl.driver.DriverCypherExecutorFactory$;
import org.neo4j.cypher.testing.impl.embedded.EmbeddedCypherExecutorFactory;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.util.Preconditions;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001ddaB\u000b\u0017!\u0003\r\ta\t\u0005\u0006]\u0001!\ta\f\u0005\bg\u0001\u0011\r\u0015\"\u00035\u0011\u001d)\u0005\u00011Q\u0005\n\u0019CqA\u0014\u0001AB\u0013%q\nC\u0003S\u0001\u0019\u00051\u000bC\u0003X\u0001\u0011\u0015\u0003\fC\u0003d\u0001\u0011\u0015C\rC\u0003h\u0001\u0011%\u0001\u000eC\u0004\u0002\b\u0001!I!!\u0003\t\r\u00055\u0001\u0001\"\u00110\u0011\u0019\ty\u0001\u0001C!_!9\u0011\u0011\u0003\u0001\u0005\u0012\u0005M\u0001bBA\u0014\u0001\u00115\u0011\u0011\u0006\u0005\b\u0003\u000b\u0002A\u0011BA$\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001b:q!!\u0015\u0017\u0011\u0003\t\u0019F\u0002\u0004\u0016-!\u0005\u0011Q\u000b\u0005\b\u0003/\nB\u0011AA-\u0011%\tY&\u0005b\u0001\n\u0003\ti\u0006\u0003\u0005\u0002fE\u0001\u000b\u0011BA0\u00051)\u00050Z2vi>\u0014\bk\\8m\u0015\t9\u0002$A\u0004sK\u001e,H.\u0019:\u000b\u0005eQ\u0012\u0001B4mk\u0016T!a\u0007\u000f\u0002\u0011\r,8-^7cKJT!!\b\u0010\u0002\r\rL\b\u000f[3s\u0015\ty\u0002%A\u0003oK>$$NC\u0001\"\u0003\ry'oZ\u0002\u0001'\r\u0001AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-bS\"\u0001\f\n\u000552\"!C#yK\u000e,Ho\u001c:t\u0003\u0019!\u0013N\\5uIQ\t\u0001\u0007\u0005\u0002&c%\u0011!G\n\u0002\u0005+:LG/A\u0005fq\u0016\u001cW\u000f^8sgV\tQ\u0007E\u00027{}j\u0011a\u000e\u0006\u0003qe\n!bY8oGV\u0014(/\u001a8u\u0015\tQ4(\u0001\u0003vi&d'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}]\u0012!#\u0011:sCf\u0014En\\2lS:<\u0017+^3vKB\u0019Q\u0005\u0011\"\n\u0005\u00053#AB(qi&|g\u000e\u0005\u0002,\u0007&\u0011AI\u0006\u0002\u000b\t\n\f5mY3tg>\u0014\u0018aB:uCJ$X\rZ\u000b\u0002\u000fB\u0011Q\u0005S\u0005\u0003\u0013\u001a\u0012qAQ8pY\u0016\fg\u000e\u000b\u0002\u0004\u0017B\u0011Q\u0005T\u0005\u0003\u001b\u001a\u0012\u0001B^8mCRLG.Z\u0001\fgR\f'\u000f^3e?\u0012*\u0017\u000f\u0006\u00021!\"9\u0011\u000bBA\u0001\u0002\u00049\u0015a\u0001=%c\u0005!1m\u001c8g+\u0005!\u0006CA\u0016V\u0013\t1fC\u0001\u0005UKN$8i\u001c8g\u0003\u001d\t7-];je\u0016$\"AQ-\t\u000bi3\u0001\u0019A.\u0002\u0011M\u001cWM\\1sS>\u0004\"\u0001X1\u000e\u0003uS!a\n0\u000b\u0005my&\"\u00011\u0002\u0005%|\u0017B\u00012^\u0005!\u00196-\u001a8be&|\u0017a\u0002:fY\u0016\f7/\u001a\u000b\u0003a\u0015DQAZ\u0004A\u0002\t\u000b\u0001\"\u001a=fGV$xN]\u0001\rSN\u001cu.\u001c9bi&\u0014G.\u001a\u000b\u0004\u000f&\\\u0007\"\u00026\t\u0001\u0004\u0011\u0015\u0001C1dG\u0016\u001c8o\u001c:\t\u000b1D\u0001\u0019A7\u0002\u001b\u0015DHO]1TKR$\u0018N\\4t!\rq\u0017\u0011\u0001\b\u0003_zt!\u0001]?\u000f\u0005EdhB\u0001:|\u001d\t\u0019(P\u0004\u0002us:\u0011Q\u000f_\u0007\u0002m*\u0011qOI\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!a\b\u0011\n\u0005uq\u0012BA\u000e\u001d\u0013\tI\"$\u0003\u0002\u00181%\u0011qPF\u0001\t)\u0016\u001cHoQ8oM&!\u00111AA\u0003\u0005!\u0019V\r\u001e;j]\u001e\u001c(BA@\u0017\u00039\u0019'/Z1uK\u0016CXmY;u_J$2AQA\u0006\u0011\u0015a\u0017\u00021\u0001n\u0003\u0015\u0019H/\u0019:u\u0003!\u0019\b.\u001e;e_^t\u0017!C:uCJ$HIY7t)\u0011\t)\"!\n\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005\u0019\u0011\r]5\u000b\u0007\u0005}a$\u0001\u0003eE6\u001c\u0018\u0002BA\u0012\u00033\u0011\u0011\u0004R1uC\n\f7/Z'b]\u0006<W-\\3oiN+'O^5dK\")A\u000e\u0004a\u0001[\u0006a\u0011mY2fgN|'O\u0012:p[R9!)a\u000b\u0002.\u0005=\u0002bBA\u0010\u001b\u0001\u0007\u0011Q\u0003\u0005\u0006Y6\u0001\r!\u001c\u0005\b\u0003ci\u0001\u0019AA\u001a\u0003\u0019!'MT1nKB!Q\u0005QA\u001b!\u0011\t9$a\u0010\u000f\t\u0005e\u00121\b\t\u0003k\u001aJ1!!\u0010'\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011IA\"\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\b\u0014\u0002!\u0015DHO]1TKR$\u0018N\\4t\r>\u0014HcA7\u0002J!)!L\u0004a\u00017\u0006\u00012\u000f[;uI><h.\u0012=fGV$xN\u001d\u000b\u0004a\u0005=\u0003\"\u00026\u0010\u0001\u0004\u0011\u0015\u0001D#yK\u000e,Ho\u001c:Q_>d\u0007CA\u0016\u0012'\t\tB%\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003'\n\u0001\u0002U8pYNK'0Z\u000b\u0003\u0003?\u00022!JA1\u0013\r\t\u0019G\n\u0002\u0004\u0013:$\u0018!\u0003)p_2\u001c\u0016N_3!\u0001")
public interface ExecutorPool
extends Executors {
    public static int PoolSize() {
        return ExecutorPool$.MODULE$.PoolSize();
    }

    public void org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$_setter_$org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$executors_$eq(ArrayBlockingQueue<Option<DbAccessor>> var1);

    public ArrayBlockingQueue<Option<DbAccessor>> org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$executors();

    public boolean org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$started();

    public void org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$started_$eq(boolean var1);

    public TestConf conf();

    public static /* synthetic */ DbAccessor acquire$(ExecutorPool $this, Scenario scenario) {
        return $this.acquire(scenario);
    }

    @Override
    default public DbAccessor acquire(Scenario scenario) {
        Preconditions.checkState((boolean)this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$started(), (String)"ExecutorPool is not started");
        scala.collection.immutable.Map<String, String> extraSettings = this.extraSettingsFor(scenario);
        Option<DbAccessor> option = this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$executors().poll(5L, TimeUnit.MINUTES);
        if (option instanceof Some) {
            DbAccessor dbAccessor;
            Some some = (Some)option;
            DbAccessor executor = (DbAccessor)some.value();
            try {
                if (this.isCompatible(executor, extraSettings)) {
                    dbAccessor = new DbAccessor(executor.dbms().withNewExecutor(), executor.extraSettings(), executor.reUseCount() + 1);
                } else {
                    this.shutdownExecutor(executor);
                    dbAccessor = this.createExecutor(extraSettings);
                }
            }
            catch (Throwable t) {
                Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.shutdownExecutor(executor));
                this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$executors().offer((Option<DbAccessor>)None$.MODULE$);
                throw t;
            }
            return dbAccessor;
        }
        if (None$.MODULE$.equals(option)) {
            DbAccessor dbAccessor;
            try {
                dbAccessor = this.createExecutor(extraSettings);
            }
            catch (Throwable t) {
                this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$executors().offer((Option<DbAccessor>)None$.MODULE$);
                throw t;
            }
            return dbAccessor;
        }
        if (option == null) {
            throw new IllegalStateException("Timed out while waiting for executor (not supposed to happen)");
        }
        throw new MatchError(option);
    }

    public static /* synthetic */ void release$(ExecutorPool $this, DbAccessor executor) {
        $this.release(executor);
    }

    @Override
    default public void release(DbAccessor executor) {
        Preconditions.checkState((boolean)this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$started(), (String)"ExecutorPool is not started");
        try {
            Assertions.assertTrue((boolean)executor.dbms().database().isAvailable(), (String)"Database is not available after test");
            executor.dbms().dropIndexesAndConstraints();
            executor.dbms().terminateAllTransactions();
            KernelOperation$.MODULE$.detachDeleteAllNodes((GraphDatabaseService)executor.dbms().database());
            executor.dbms().closeExecutor();
            this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$executors().offer((Option<DbAccessor>)new Some((Object)executor));
        }
        catch (Throwable t) {
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.shutdownExecutor(executor));
            this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$executors().offer((Option<DbAccessor>)None$.MODULE$);
            throw t;
        }
    }

    private boolean isCompatible(DbAccessor accessor, scala.collection.immutable.Map<String, String> extraSettings) {
        return accessor.isCompatible(extraSettings) && (!this.conf().useSpd() || accessor.reUseCount() < 256);
    }

    private DbAccessor createExecutor(scala.collection.immutable.Map<String, String> extraSettings) {
        return this.accessorFrom(this.startDbms(extraSettings), extraSettings, (Option<String>)None$.MODULE$);
    }

    public static /* synthetic */ void start$(ExecutorPool $this) {
        $this.start();
    }

    @Override
    default public void start() {
        Preconditions.checkState((!this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$started() ? 1 : 0) != 0, (String)"Tried starting already started ExecutorPool");
        while (this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$executors().offer((Option<DbAccessor>)None$.MODULE$)) {
        }
        this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$started_$eq(true);
    }

    public static /* synthetic */ void shutdown$(ExecutorPool $this) {
        $this.shutdown();
    }

    @Override
    default public void shutdown() {
        ExecutorPool executorPool = this;
        synchronized (executorPool) {
            Preconditions.checkState((boolean)this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$started(), (String)"Tried stopping already stopped ExecutorPool");
            this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$started_$eq(false);
            this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$executors().forEach((Consumer<Option<DbAccessor>>)((Consumer<Option>)x$1 -> x$1.foreach((Function1 & Serializable)a -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.shutdownExecutor((DbAccessor)a)))));
            this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$executors().clear();
        }
    }

    public static /* synthetic */ DatabaseManagementService startDbms$(ExecutorPool $this, scala.collection.immutable.Map extraSettings) {
        return $this.startDbms((scala.collection.immutable.Map<String, String>)extraSettings);
    }

    default public DatabaseManagementService startDbms(scala.collection.immutable.Map<String, String> extraSettings) {
        TestDatabaseManagementServiceBuilder testDatabaseManagementServiceBuilder;
        if (this.conf().useEnterprise()) {
            Class<?> cls = this.getClass().getClassLoader().loadClass("com.neo4j.test.TestEnterpriseDatabaseManagementServiceBuilder");
            testDatabaseManagementServiceBuilder = (TestDatabaseManagementServiceBuilder)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            testDatabaseManagementServiceBuilder = new TestDatabaseManagementServiceBuilder();
        }
        TestDatabaseManagementServiceBuilder dbmsBuilder = testDatabaseManagementServiceBuilder;
        return dbmsBuilder.impermanent().setDatabaseRootDirectory(Path.of("target", "test data", UUID.randomUUID().toString())).setConfigRaw(CollectionConverters$.MODULE$.MapHasAsJava((Map)this.conf().neo4jConf().$plus$plus(extraSettings)).asJava()).build();
    }

    private DbAccessor accessorFrom(DatabaseManagementService dbms, scala.collection.immutable.Map<String, String> extraSettings, Option<String> dbName) {
        Config neo4jConf = (Config)((GraphDatabaseFacade)dbms.database((String)dbName.getOrElse((Function0 & Serializable)() -> "neo4j"))).getDependencyResolver().resolveDependency(Config.class);
        DriverCypherExecutorFactory executorFactory = this.conf().useBolt() ? new DriverCypherExecutorFactory(dbms, neo4jConf, DriverCypherExecutorFactory$.MODULE$.apply$default$3()) : new EmbeddedCypherExecutorFactory(dbms, neo4jConf);
        return new DbAccessor(new FeatureDatabaseManagementService(dbms, (CypherExecutorFactory)executorFactory, dbName, FeatureDatabaseManagementService$.MODULE$.apply$default$4()), extraSettings, 0);
    }

    private scala.collection.immutable.Map<String, String> extraSettingsFor(Scenario scenario) {
        Collection tags = scenario.getSourceTagNames();
        if (!tags.isEmpty() && tags.stream().anyMatch(tag -> tag.startsWith("@conf:"))) {
            return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(tags).asScala().view().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1.startsWith("@conf:")) {
                        int equalsIndex = A1.indexOf("=");
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)A1.substring("@conf:".length(), equalsIndex)), (Object)A1.substring(equalsIndex + 1));
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(String x1) {
                    String string = x1;
                    return string.startsWith("@conf:");
                }
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return Predef$.MODULE$.Map().empty();
    }

    private void shutdownExecutor(DbAccessor accessor) {
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> accessor.dbms().clearQueryCaches());
        accessor.dbms().shutdown();
    }

    public static void $init$(ExecutorPool $this) {
        $this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$_setter_$org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$executors_$eq(new ArrayBlockingQueue<Option<DbAccessor>>(ExecutorPool$.MODULE$.PoolSize()));
        $this.org$neo4j$cypher$cucumber$glue$regular$ExecutorPool$$started_$eq(false);
    }
}

