/*
 * Decompiled with CFR 0.152.
 */
package cypher.features;

import cypher.features.ProcedureSignature;
import java.io.Serializable;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.package$;
import org.neo4j.exceptions.SyntaxException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005%4A\u0001C\u0005\u0001\u001d!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!)!\b\u0001C\u0005w!)\u0011\t\u0001C\u0005\u0005\")!\f\u0001C\u00057\")\u0011\r\u0001C\u0005E\")Q\r\u0001C\u0005M\nA\u0002K]8dK\u0012,(/Z*jO:\fG/\u001e:f!\u0006\u00148/\u001a:\u000b\u0005)Y\u0011\u0001\u00034fCR,(/Z:\u000b\u00031\taaY=qQ\u0016\u00148\u0001A\n\u0003\u0001=\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\n\u0003\u0015\u0001\u0018M]:f)\tYb\u0004\u0005\u0002\u00199%\u0011Q$\u0003\u0002\u0013!J|7-\u001a3ve\u0016\u001c\u0016n\u001a8biV\u0014X\rC\u0003 \u0005\u0001\u0007\u0001%A\u0007tS\u001et\u0017\r^;sKR+\u0007\u0010\u001e\t\u0003C!r!A\t\u0014\u0011\u0005\r\nR\"\u0001\u0013\u000b\u0005\u0015j\u0011A\u0002\u001fs_>$h(\u0003\u0002(#\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9\u0013\u0003K\u0002\u0003Ye\u00022\u0001E\u00170\u0013\tq\u0013C\u0001\u0004uQJ|wo\u001d\t\u0003a]j\u0011!\r\u0006\u0003eM\n!\"\u001a=dKB$\u0018n\u001c8t\u0015\t!T'A\u0003oK>$$NC\u00017\u0003\ry'oZ\u0005\u0003qE\u0012qbU=oi\u0006DX\t_2faRLwN\\\u0012\u0002_\u0005QR\r\u001f;sC\u000e$\u0018J\u001c9vi\u0006sGmT;uaV$\b+\u0019:ugR\u0011Ah\u0010\t\u0005!u\u0002\u0003%\u0003\u0002?#\t1A+\u001e9mKJBQ\u0001Q\u0002A\u0002\u0001\nA#\u001b8qkR\fe\u000eZ(viB,Ho\u0015;sS:<\u0017aG3yiJ\f7\r\u001e)s_\u000e,G-\u001e:f\u0013:\u0004X\u000f\u001e$jK2$7\u000f\u0006\u0002D1B\u0019A)\u0013'\u000f\u0005\u0015;eBA\u0012G\u0013\u0005\u0011\u0012B\u0001%\u0012\u0003\u001d\u0001\u0018mY6bO\u0016L!AS&\u0003\u0007M+\u0017O\u0003\u0002I#A!\u0001#\u0010\u0011N!\tqe+D\u0001P\u0015\t\u0001\u0016+A\u0004ts6\u0014w\u000e\\:\u000b\u0005I\u001b\u0016\u0001B;uS2T!\u0001V+\u0002\u0011%tG/\u001a:oC2T!\u0001D\u001a\n\u0005]{%AC\"za\",'\u000fV=qK\")\u0011\f\u0002a\u0001A\u0005Y\u0011N\u001c9viN#(/\u001b8h\u0003q)\u0007\u0010\u001e:bGR\u0004&o\\2fIV\u0014XmT;uaV$h)[3mIN$\"\u0001X0\u0011\u0007Ai6)\u0003\u0002_#\t1q\n\u001d;j_:DQ\u0001Y\u0003A\u0002\u0001\nAb\\;uaV$8\u000b\u001e:j]\u001e\fQ#\u001a=ue\u0006\u001cG\u000f\u0015:pG\u0016$WO]3GS\u0016dG\r\u0006\u0002MG\")AM\u0002a\u0001A\u0005q\u0001O]8dK\u0012,(/\u001a$jK2$\u0017!E3yiJ\f7\r^\"za\",'\u000fV=qKR\u0011Qj\u001a\u0005\u0006Q\u001e\u0001\r\u0001I\u0001\u000bif\u0004Xm\u0015;sS:<\u0007")
public class ProcedureSignatureParser {
    public ProcedureSignature parse(String signatureText) throws SyntaxException {
        String signature = signatureText.trim();
        String[] parts = signature.split("(?=\\()", 2);
        if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])parts)) < 2) {
            throw SyntaxException.internalError((String)this.getClass().getSimpleName(), (String)"Error parsing procedure signature: expected '(' after procedure name");
        }
        String[] nameParts = ((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])parts))).split("\\.");
        Tuple2<String, String> tuple2 = this.extractInputAndOutputParts((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])parts)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String inputPart = (String)tuple2._1();
        String outputPart = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)inputPart, (Object)outputPart);
        String inputPart2 = (String)tuple22._1();
        String outputPart2 = (String)tuple22._2();
        Seq<Tuple2<String, CypherType>> inputs = this.extractProcedureInputFields(inputPart2);
        Option<Seq<Tuple2<String, CypherType>>> outputs = this.extractProcedureOutputFields(outputPart2);
        return new ProcedureSignature((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])nameParts), 1)), (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])nameParts)), inputs, outputs);
    }

    private Tuple2<String, String> extractInputAndOutputParts(String inputAndOutputString) {
        if (StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(inputAndOutputString)) != '(' || StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(inputAndOutputString)) != ')') {
            throw SyntaxException.internalError((String)this.getClass().getSimpleName(), (String)"Error parsing procedure signature: expected input fields to be on the format '(input) :: (output)'");
        }
        String[] inputAndOutput = inputAndOutputString.split("\\) :: \\(");
        if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])inputAndOutput)) != 2) {
            throw SyntaxException.internalError((String)this.getClass().getSimpleName(), (String)"Error parsing procedure signature: expected exactly one ') :: (' between input and output.");
        }
        return new Tuple2((Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])inputAndOutput))), 1), (Object)StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])inputAndOutput))), 1));
    }

    private Seq<Tuple2<String, CypherType>> extractProcedureInputFields(String inputString) {
        if (inputString.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        String[] inputFields = inputString.split(",");
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])inputFields), (Function1 & Serializable)x -> this.extractProcedureField((String)x), ClassTag$.MODULE$.apply(Tuple2.class))));
    }

    private Option<Seq<Tuple2<String, CypherType>>> extractProcedureOutputFields(String outputString) {
        if (outputString.isEmpty() || outputString.trim().equals("VOID")) {
            return None$.MODULE$;
        }
        String[] outputFields = outputString.split(",");
        return new Some((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])outputFields), (Function1 & Serializable)x -> this.extractProcedureField((String)x), ClassTag$.MODULE$.apply(Tuple2.class)))));
    }

    private Tuple2<String, CypherType> extractProcedureField(String procedureField) {
        String[] fieldParts = procedureField.split("::");
        if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])fieldParts)) != 2) {
            throw SyntaxException.internalError((String)this.getClass().getSimpleName(), (String)"Error parsing procedure signature: expected exactly one '::' between procedure field parts.");
        }
        String fieldName = ((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])fieldParts))).trim();
        CypherType cypherType = this.extractCypherType(((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])fieldParts))).trim());
        return new Tuple2((Object)fieldName, (Object)cypherType);
    }

    private CypherType extractCypherType(String typeString) {
        String string = typeString;
        switch (string == null ? 0 : string.hashCode()) {
            case -1929424689: {
                if (!"POINT?".equals(string)) break;
                return package$.MODULE$.CTPoint();
            }
            case -1506277065: {
                if (!"BOOLEAN?".equals(string)) break;
                return package$.MODULE$.CTBoolean();
            }
            case -1282532842: {
                if (!"NUMBER?".equals(string)) break;
                return package$.MODULE$.CTNumber();
            }
            case -1163776434: {
                if (!"STRING?".equals(string)) break;
                return package$.MODULE$.CTString();
            }
            case -706189049: {
                if (!"RELATIONSHIP?".equals(string)) break;
                return package$.MODULE$.CTRelationship();
            }
            case 2014195: {
                if (!"ANY?".equals(string)) break;
                return package$.MODULE$.CTAny();
            }
            case 2358915: {
                if (!"MAP?".equals(string)) break;
                return package$.MODULE$.CTMap();
            }
            case 74455677: {
                if (!"NODE?".equals(string)) break;
                return package$.MODULE$.CTNode();
            }
            case 75901114: {
                if (!"PATH?".equals(string)) break;
                return package$.MODULE$.CTPath();
            }
            case 1352701665: {
                if (!"INTEGER?".equals(string)) break;
                return package$.MODULE$.CTInteger();
            }
            case 2076646787: {
                if (!"FLOAT?".equals(string)) break;
                return package$.MODULE$.CTFloat();
            }
        }
        if (string.startsWith("LIST? OF ")) {
            return package$.MODULE$.CTList(this.extractCypherType(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(string), "LIST? OF ")));
        }
        throw SyntaxException.internalError((String)this.getClass().getSimpleName(), (String)("Error parsing procedure signature: unexpected Cypher type " + string));
    }
}

