/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.cucumber.glue.regular;

import io.cucumber.datatable.DataTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.neo4j.cypher.cucumber.glue.regular.RegularCypherCucumberSteps;
import org.neo4j.cypher.cucumber.value.CypherCucumberValueParser$;
import org.neo4j.cypher.testing.api.ConsumedResult;
import org.neo4j.internal.helpers.Exceptions;
import scala.Predef$;
import scala.collection.StringOps$;

public final class RegularCypherCucumberSteps$ {
    public static final RegularCypherCucumberSteps$ MODULE$ = new RegularCypherCucumberSteps$();

    public List<List<Object>> toResultRows(DataTable table) {
        if (table.isEmpty()) {
            return List.of();
        }
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(table.height() - 1);
        List cells = table.cells();
        for (int i = 1; i < cells.size(); ++i) {
            List row = (List)cells.get(i);
            ArrayList<Object> parsedRow = new ArrayList<Object>(row.size());
            for (int j = 0; j < row.size(); ++j) {
                parsedRow.add(CypherCucumberValueParser$.MODULE$.parse((String)row.get(j)));
            }
            result.add(parsedRow);
        }
        return result;
    }

    private String renderAsTable(ConsumedResult results) {
        ArrayList<List> table = new ArrayList<List>(results.rows().size() + 1);
        table.add(results.headers());
        results.rows().forEach(row -> table.add(row.stream().map(v -> Objects.toString(v)).toList()));
        return DataTable.create(table).toString();
    }

    public void org$neo4j$cypher$cucumber$glue$regular$RegularCypherCucumberSteps$$assertEqualHeaders(RegularCypherCucumberSteps.QueryResults actual, DataTable expected) {
        List actualHeaders = actual.results().headers();
        List expectedHeaders = expected.isEmpty() ? List.of() : expected.row(0);
        List list = actualHeaders;
        List list2 = expectedHeaders;
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            Assertions.assertThat((List)actualHeaders).as("Result has correct headers", new Object[0]).containsExactlyElementsOf((Iterable)expectedHeaders);
            return;
        }
    }

    public void unexpectedFailure(RegularCypherCucumberSteps.QueryFailure failure) {
        org.junit.jupiter.api.Assertions.fail((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |Query failed but was expected to succeed.\n       |Phase: " + failure.phase() + "\n       |Query:\n       |" + failure.query() + "\n       |\n       |Cause: " + Exceptions.stringify((Throwable)failure.cause()) + "\n       |")));
    }

    public void unexpectedSuccess(RegularCypherCucumberSteps.QueryResults results) {
        org.junit.jupiter.api.Assertions.fail((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       >Query was expected to fail, but executed successfully.\n       >\n       >Results:\n       >" + this.renderAsTable(results.results()) + "\n       >Query:\n       >" + results.query() + "\n       |"), '>'));
    }

    public Supplier<String> org$neo4j$cypher$cucumber$glue$regular$RegularCypherCucumberSteps$$describe(RegularCypherCucumberSteps.QueryResults actual, DataTable expected, String order) {
        return () -> {
            List expectedHeaders = expected.height() > 0 ? expected.row(0) : List.of();
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       >Incorrect query result.\n       >\n       >Actual results:\n       >" + MODULE$.renderAsTable(actual.results()) + "\n       >Expected results (" + order + "):\n       >" + MODULE$.renderAsTable(new ConsumedResult(expectedHeaders, MODULE$.toResultRows(expected))) + "\n       >Query:\n       >" + actual.query() + "\n       >"), '>');
        };
    }

    public Supplier<String> org$neo4j$cypher$cucumber$glue$regular$RegularCypherCucumberSteps$$describe(RegularCypherCucumberSteps.QueryFailure failure) {
        return () -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |Query failure (you need to scroll past the stacktrace for actual assertion error).\n       |Phase: " + failure.phase() + "\n       |Query:\n       |" + failure.query() + "\n       |\n       |Cause: " + Exceptions.stringify((Throwable)failure.cause()) + "\n       |"));
    }

    private RegularCypherCucumberSteps$() {
    }
}

