/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_4.runtime.slotted;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

public class DefaultComparatorTopTable<T>
implements Iterable<T> {
    private final Comparator<T> comparator;
    private final int totalCount;
    private int count = -1;
    private PriorityQueue<T> heap;
    private Object[] array;

    public DefaultComparatorTopTable(Comparator<T> comparator, int totalCount) {
        this.comparator = comparator;
        if (totalCount <= 0) {
            throw new IllegalArgumentException("Top table size must be greater than 0");
        }
        this.totalCount = totalCount;
        this.heap = new PriorityQueue<T>(totalCount, comparator.reversed());
        this.array = new Object[totalCount];
    }

    public boolean add(T e) {
        if (this.heap.size() < this.totalCount) {
            return this.heap.offer(e);
        }
        T head = this.heap.peek();
        if (this.comparator.compare(head, e) > 0) {
            this.heap.poll();
            return this.heap.offer(e);
        }
        return false;
    }

    public void sort() {
        this.count = this.heap.size();
        for (int i = 0; i < this.count; ++i) {
            this.array[i] = this.heap.poll();
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.count == -1) {
            throw new IllegalStateException("sort() needs to be called before requesting an iterator");
        }
        return new Iterator<T>(){
            private int cursor;
            {
                this.cursor = DefaultComparatorTopTable.this.count;
            }

            @Override
            public boolean hasNext() {
                return this.cursor > 0;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return DefaultComparatorTopTable.this.array[--this.cursor];
            }
        };
    }
}

