/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.List;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.io.pagecache.context.CursorContext;

public record PartitionedMultiScan<INNER extends Cursor, OUTER extends Cursor>(List<PartitionedScan<INNER>> scans) implements PartitionedScan<OUTER>
{
    public int getNumberOfPartitions() {
        return this.scans.size() > 0 ? this.scans.get(0).getNumberOfPartitions() : 0;
    }

    public boolean reservePartition(OUTER cursor, CursorContext cursorContext, AccessMode accessMode) {
        throw new UnsupportedOperationException("Do not call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reservePartition(INNER[] cursors, CursorContext cursorContext, AccessMode accessMode) {
        assert (cursors.length == this.scans.size());
        List<PartitionedScan<INNER>> list = this.scans;
        synchronized (list) {
            for (int i = 0; i < cursors.length; ++i) {
                this.scans.get(i).reservePartition(cursors[i], cursorContext, accessMode);
            }
        }
    }
}

