/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.Lengths;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PGPathPropagatingBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PathWriter;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.MultiRelationshipExpansion;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TwoWaySignpost
implements Measurable {
    public static final int NO_TARGET_DISTANCE = -1;
    public final NodeState prevNode;
    public final NodeState forwardNode;
    public final Lengths lengths;
    protected int minTargetDistance = -1;
    public final BitSet cycleLengths;

    protected TwoWaySignpost(NodeState prevNode, NodeState forwardNode, Lengths lengths) {
        this.prevNode = prevNode;
        this.forwardNode = forwardNode;
        this.lengths = lengths;
        this.cycleLengths = new BitSet();
    }

    protected TwoWaySignpost(NodeState prevNode, NodeState forwardNode, int sourceLength, Lengths lengths) {
        this(prevNode, forwardNode, lengths);
        this.lengths.markAsSeen(sourceLength);
    }

    public static RelSignpost fromRelExpansion(MemoryTracker mt, NodeState prevNode, long relId, NodeState forwardNode, RelationshipExpansion relationshipExpansion, int sourceLength, Lengths lengths) {
        return TwoWaySignpost.allocate(mt, new RelSignpost(prevNode, relId, forwardNode, relationshipExpansion, sourceLength, lengths));
    }

    public static RelSignpost fromRelExpansion(MemoryTracker mt, NodeState prevNode, long relId, NodeState forwardNode, RelationshipExpansion relationshipExpansion, Lengths lengths) {
        return TwoWaySignpost.allocate(mt, new RelSignpost(prevNode, relId, forwardNode, relationshipExpansion, lengths));
    }

    public static NodeSignpost fromNodeJuxtaposition(MemoryTracker mt, NodeState prevNode, NodeState forwardNode, int sourceLength, Lengths lengths) {
        return TwoWaySignpost.allocate(mt, new NodeSignpost(prevNode, forwardNode, sourceLength, lengths));
    }

    public static NodeSignpost fromNodeJuxtaposition(MemoryTracker mt, NodeState prevNode, NodeState forwardNode, Lengths lengths) {
        return TwoWaySignpost.allocate(mt, new NodeSignpost(prevNode, forwardNode, lengths));
    }

    public static MultiRelSignpost fromMultiRel(MemoryTracker mt, NodeState prevNode, long[] rels, long[] nodes, MultiRelationshipExpansion expansion, NodeState forwardNode, Lengths lengths) {
        return TwoWaySignpost.allocate(mt, new MultiRelSignpost(prevNode, rels, nodes, forwardNode, expansion, lengths));
    }

    public static MultiRelSignpost fromMultiRel(MemoryTracker mt, NodeState prevNode, long[] rels, long[] nodes, MultiRelationshipExpansion expansion, NodeState forwardNode, int sourceLength, Lengths lengths) {
        return TwoWaySignpost.allocate(mt, new MultiRelSignpost(prevNode, rels, nodes, forwardNode, expansion, sourceLength, lengths));
    }

    private static <T extends TwoWaySignpost> T allocate(MemoryTracker mt, T signpost) {
        mt.allocateHeap(signpost.estimatedHeapUsage());
        return signpost;
    }

    public abstract int entityCount();

    public abstract int dataGraphLength();

    public abstract void materialize(PathWriter var1);

    public boolean hasBeenTraced() {
        return this.minTargetDistance != -1;
    }

    public void setMinTargetDistance(int distance, PGPathPropagatingBFS.Phase phase) {
        Preconditions.checkState((this.minTargetDistance == -1 ? 1 : 0) != 0, (String)"A signpost should only have setMinDistToTarget() called upon it on the first trace");
        this.minTargetDistance = distance;
        this.prevNode.addTargetSignpost(this, distance, phase);
    }

    public int minTargetDistance() {
        return this.minTargetDistance;
    }

    public void addSourceLength(int sourceLength) {
        this.lengths.markAsSeen(sourceLength);
        this.prevNode.globalState.hooks.addSourceLength(this, sourceLength);
    }

    public boolean seenAt(int sourceLength) {
        return this.lengths.seenAt(sourceLength);
    }

    public void propagate(int sourceLength, int targetLength) {
        int newLength = sourceLength + this.dataGraphLength();
        this.forwardNode.newPropagatedSourceLength(newLength, targetLength - this.dataGraphLength());
        this.addSourceLength(newLength);
    }

    public void pruneSourceLength(int sourceLength) {
        this.prevNode.globalState.hooks.pruneSourceLength(this, sourceLength);
        this.lengths.clearSeen(sourceLength);
        this.forwardNode.synchronizeLengthAfterPrune(sourceLength);
    }

    public void validate(int sourceLength) {
        this.prevNode.globalState.hooks.setValidated(this, sourceLength);
        this.lengths.markAsValidated(sourceLength);
    }

    public boolean isValidatedAtLength(int sourceLength) {
        return this.lengths.validatedAt(sourceLength);
    }

    public static final class RelSignpost
    extends TwoWaySignpost {
        public final long relId;
        public final RelationshipExpansion relationshipExpansion;
        private static long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelSignpost.class);

        private RelSignpost(NodeState prevNode, long relId, NodeState forwardNode, RelationshipExpansion relationshipExpansion, int lengthFromSource, Lengths lengths) {
            super(prevNode, forwardNode, lengthFromSource, lengths);
            this.relId = relId;
            this.relationshipExpansion = relationshipExpansion;
        }

        private RelSignpost(NodeState prevNode, long relId, NodeState forwardNode, RelationshipExpansion relationshipExpansion, Lengths lengths) {
            super(prevNode, forwardNode, lengths);
            this.relId = relId;
            this.relationshipExpansion = relationshipExpansion;
        }

        @Override
        public void materialize(PathWriter pathWriter) {
            pathWriter.writeNode(this.prevNode.state().slotOrName(), this.prevNode.id());
            pathWriter.writeRel(this.relationshipExpansion.slotOrName(), this.relId);
        }

        @Override
        public int entityCount() {
            return 2;
        }

        @Override
        public int dataGraphLength() {
            return 1;
        }

        public String toString() {
            String sourceLengths;
            StringBuilder sb = new StringBuilder("RE ").append(this.prevNode).append("-[");
            if (this.relationshipExpansion.slotOrName() != SlotOrName.none()) {
                sb.append(this.relationshipExpansion.slotOrName()).append("@");
            }
            sb.append(this.relId).append("]->").append(this.forwardNode);
            if (this.minTargetDistance != -1) {
                sb.append(", minTargetDistance: ").append(this.minTargetDistance);
            }
            if (!(sourceLengths = this.lengths.renderSourceLengths()).isEmpty()) {
                sb.append(", sourceLengths: ").append(sourceLengths);
            }
            return sb.toString();
        }

        public long estimatedHeapUsage() {
            return SHALLOW_SIZE + this.lengths.estimatedHeapUsage();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelSignpost that = (RelSignpost)o;
            return this.prevNode == that.prevNode && this.forwardNode == that.forwardNode && this.relId == that.relId;
        }

        public int hashCode() {
            return Objects.hash(this.prevNode, this.forwardNode, this.relId);
        }
    }

    public static final class NodeSignpost
    extends TwoWaySignpost {
        private static long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeSignpost.class);

        private NodeSignpost(NodeState prevNode, NodeState forwardNode, int lengthFromSource, Lengths lengths) {
            super(prevNode, forwardNode, lengthFromSource, lengths);
            assert (prevNode != forwardNode) : "A state cannot have a node juxtaposition to itself";
        }

        @Override
        public void materialize(PathWriter pathWriter) {
            pathWriter.writeNode(this.prevNode.state().slotOrName(), this.prevNode.id());
        }

        @Override
        public int entityCount() {
            return 1;
        }

        private NodeSignpost(NodeState prevNode, NodeState forwardNode, Lengths lengths) {
            super(prevNode, forwardNode, lengths);
            assert (prevNode != forwardNode) : "A state cannot have a node juxtaposition to itself";
        }

        @Override
        public int dataGraphLength() {
            return 0;
        }

        public String toString() {
            String sourceLengths;
            StringBuilder sb = new StringBuilder("NJ ").append(this.prevNode).append(" ").append(this.forwardNode);
            if (this.minTargetDistance != -1) {
                sb.append(", minTargetDistance: ").append(this.minTargetDistance);
            }
            if (!(sourceLengths = this.lengths.renderSourceLengths()).isEmpty()) {
                sb.append(", sourceLengths: ").append(sourceLengths);
            }
            return sb.toString();
        }

        public long estimatedHeapUsage() {
            return SHALLOW_SIZE + this.lengths.estimatedHeapUsage();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeSignpost that = (NodeSignpost)o;
            return this.prevNode == that.prevNode && this.forwardNode == that.forwardNode;
        }

        public int hashCode() {
            return Objects.hash(this.prevNode, this.forwardNode);
        }
    }

    public static final class MultiRelSignpost
    extends TwoWaySignpost {
        public final long[] rels;
        public final long[] nodes;
        public final MultiRelationshipExpansion transition;
        private static long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(MultiRelSignpost.class);

        private MultiRelSignpost(NodeState prevNode, long[] rels, long[] nodes, NodeState forwardNode, MultiRelationshipExpansion transition, int lengthFromSource, Lengths lengths) {
            super(prevNode, forwardNode, lengthFromSource, lengths);
            this.rels = rels;
            this.nodes = nodes;
            this.transition = transition;
            assert (rels.length == transition.rels().length);
            assert (nodes.length == transition.nodes().length);
        }

        @Override
        public void materialize(PathWriter pathWriter) {
            pathWriter.writeNode(this.prevNode.state().slotOrName(), this.prevNode.id());
            for (int i = 0; i < this.nodes.length; ++i) {
                long rel = this.rels[i];
                SlotOrName relSlot = this.transition.rels()[i].slotOrName();
                pathWriter.writeRel(relSlot, rel);
                long node = this.nodes[i];
                SlotOrName nodeSlot = this.transition.nodes()[i].slotOrName();
                pathWriter.writeNode(nodeSlot, node);
            }
            long lastRel = this.rels[this.rels.length - 1];
            SlotOrName lastSlot = this.transition.rels()[this.transition.rels().length - 1].slotOrName();
            pathWriter.writeRel(lastSlot, lastRel);
        }

        private MultiRelSignpost(NodeState prevNode, long[] rels, long[] nodes, NodeState forwardNode, MultiRelationshipExpansion transition, Lengths lengths) {
            super(prevNode, forwardNode, lengths);
            this.rels = rels;
            this.nodes = nodes;
            this.transition = transition;
            assert (rels.length == transition.rels().length);
            assert (nodes.length == transition.nodes().length);
        }

        public long estimatedHeapUsage() {
            return SHALLOW_SIZE + this.lengths.estimatedHeapUsage() + HeapEstimator.sizeOf((long[])this.rels) + HeapEstimator.sizeOf((long[])this.nodes);
        }

        @Override
        public int entityCount() {
            return 1 + this.rels.length + this.nodes.length;
        }

        @Override
        public int dataGraphLength() {
            return this.transition.length();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiRelSignpost that = (MultiRelSignpost)o;
            return this.prevNode == that.prevNode && this.forwardNode == that.forwardNode && Arrays.equals(this.rels, that.rels);
        }

        public int hashCode() {
            return Objects.hash(this.prevNode, this.forwardNode, Arrays.hashCode(this.rels));
        }

        public String toString() {
            String sourceLengths;
            StringBuilder sb = new StringBuilder("MRE ").append(this.prevNode);
            if (this.transition.rels()[0].direction() == Direction.INCOMING) {
                sb.append("<");
            }
            sb.append("-[");
            for (int i = 0; i < this.transition.length(); ++i) {
                MultiRelationshipExpansion.Rel rel = this.transition.rels()[i];
                if (rel.slotOrName() != SlotOrName.none()) {
                    sb.append(rel.slotOrName()).append("@");
                }
                sb.append(this.rels[i]).append("]-");
                if (rel.direction() == Direction.OUTGOING) {
                    sb.append(">");
                }
                if (i >= this.nodes.length) continue;
                sb.append("(");
                MultiRelationshipExpansion.Node node = this.transition.nodes()[i];
                if (node.slotOrName() != SlotOrName.none()) {
                    sb.append(node.slotOrName()).append("@");
                }
                sb.append(this.nodes[i]).append(")");
                if (this.transition.rels()[i + 1].direction() == Direction.INCOMING) {
                    sb.append("<");
                }
                sb.append("-[");
            }
            sb.append(this.forwardNode);
            if (this.minTargetDistance != -1) {
                sb.append(", minTargetDistance: ").append(this.minTargetDistance);
            }
            if (!(sourceLengths = this.lengths.renderSourceLengths()).isEmpty()) {
                sb.append(", sourceLengths: ").append(sourceLengths);
            }
            return sb.toString();
        }
    }
}

