/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.collection;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.neo4j.cypher.internal.collection.MemoryTrackingHeap;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class DefaultComparatorTopTable<T>
extends MemoryTrackingHeap<T>
implements Iterable<T> {
    private static final long SHALLOW_INSTANCE_SIZE = HeapEstimator.shallowSizeOfInstance(DefaultComparatorTopTable.class);
    private long totalCount;
    private boolean heapified;
    private boolean isSorted;

    public DefaultComparatorTopTable(Comparator<? super T> comparator, long totalCount) {
        this(comparator, totalCount, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public DefaultComparatorTopTable(Comparator<? super T> comparator, long totalCount, MemoryTracker memoryTracker) {
        this(comparator, totalCount, memoryTracker, 0L);
    }

    public DefaultComparatorTopTable(Comparator<? super T> comparator, long totalCount, MemoryTracker memoryTracker, long extraShallowSize) {
        super(comparator, (int)Math.min(totalCount, 1024L), memoryTracker, SHALLOW_INSTANCE_SIZE + extraShallowSize);
        this.totalCount = totalCount;
    }

    public boolean add(T e) {
        T evicted = this.addAndGetEvicted(e);
        return e != evicted;
    }

    public T addAndGetEvicted(T e) {
        if ((long)this.size < this.totalCount) {
            if (this.size >= this.heap.length) {
                this.grow(this.size + 1);
            }
            this.heap[this.size++] = e;
            return null;
        }
        if (!this.heapified) {
            this.heapify();
            this.heapified = true;
        }
        return super.replace(e);
    }

    public int getSize() {
        return this.size;
    }

    public Iterator<T> unorderedIterator() {
        return this.getIterator();
    }

    @Override
    public void sort() {
        if (this.isSorted) {
            return;
        }
        if (!this.heapified) {
            Arrays.sort(this.heap, 0, this.size, this.comparator);
        } else {
            super.sort();
        }
        this.isSorted = true;
    }

    public void reset(long newTotalCount) {
        Preconditions.checkArgument((newTotalCount > 0L ? 1 : 0) != 0, (String)"Top table size must be greater than 0");
        this.totalCount = newTotalCount;
        this.clear();
        this.heapified = false;
        this.isSorted = false;
    }

    @Override
    public Iterator<T> iterator() {
        if (!this.isSorted) {
            throw new IllegalStateException("sort() needs to be called before requesting an iterator");
        }
        return this.getIterator();
    }

    public Iterator<T> autoClosingIterator(AutoCloseable closeable) {
        if (!this.isSorted) {
            throw new IllegalStateException("sort() needs to be called before requesting an iterator");
        }
        return this.getAutoClosingIterator(closeable);
    }

    @Override
    protected void overflow(long maxSize) {
        throw new CypherExecutionException("Top table cannot hold more than " + maxSize + " elements.");
    }
}

