/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.productgraph;

import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.RelationshipDataReader;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalDirection;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.Transition;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public record MultiRelationshipExpansion(State sourceState, Rel[] rels, Node[] nodes, CompoundPredicate compoundPredicate, State targetState) implements Transition
{
    public MultiRelationshipExpansion {
        assert (nodes.length == rels.length - 1) : "There must be exactly one fewer interior nodes than relationships in a MultiRelationshipExpansion";
    }

    public int length() {
        return this.rels.length;
    }

    public Rel rel(int depth, TraversalDirection direction) {
        return direction.isBackward() ? this.rels[this.rels.length - 1 - depth] : this.rels[depth];
    }

    public Node node(int depth, TraversalDirection direction) {
        return direction.isBackward() ? this.nodes[this.nodes.length - 1 - depth] : this.nodes[depth];
    }

    public LongPredicate nodePredicate(int depth, TraversalDirection direction) {
        if (depth == this.nodes.length) {
            return direction.isBackward() ? this.sourceState.predicate() : this.targetState.predicate();
        }
        return this.node(depth, direction).predicate();
    }

    public record Rel(Predicate<RelationshipDataReader> predicate, int[] types, Direction direction, SlotOrName slotOrName) {
        public RelationshipSelection getSelection(TraversalDirection traversalDirection) {
            return RelationshipSelection.selection((int[])this.types, (Direction)(traversalDirection == TraversalDirection.BACKWARD ? this.direction.reverse() : this.direction));
        }
    }

    public record Node(LongPredicate predicate, SlotOrName slotOrName) {
    }

    public static interface CompoundPredicate {
        public static final CompoundPredicate ALWAYS_TRUE = (startNode, rels, interiorNodes, endNode) -> true;

        public boolean test(long var1, VirtualRelationshipValue[] var3, long[] var4, long var5);
    }
}

