/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.List;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingLongArrayList;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.RelationshipDataReader;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.FoundNodes;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.GlobalState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.MREValidator;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PGPathPropagatingBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SearchMode;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalDirection;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalMatchModeFactory;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.MultiRelationshipExpansion;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.NodeJuxtaposition;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.ProductGraphTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.values.virtual.VirtualRelationshipValue;

final class BFSExpander
implements AutoCloseable {
    private final MemoryTracker mt;
    private final PPBFSHooks hooks;
    private final GlobalState globalState;
    private final ProductGraphTraversalCursor pgCursor;
    private final ProductGraphTraversalCursor.DataGraphRelationshipCursor relCursor;
    private final long intoTarget;
    private final TraversalMatchModeFactory tracker;
    private final HeapTrackingArrayList<State> statesList;
    private final FoundNodes foundNodes;

    public BFSExpander(FoundNodes foundNodes, GlobalState globalState, ProductGraphTraversalCursor pgCursor, ProductGraphTraversalCursor.DataGraphRelationshipCursor relCursor, long intoTarget, int nfaStateCount, TraversalMatchModeFactory tracker) {
        this.mt = globalState.mt;
        this.hooks = globalState.hooks;
        this.globalState = globalState;
        this.pgCursor = pgCursor;
        this.relCursor = relCursor;
        this.intoTarget = intoTarget;
        this.statesList = HeapTrackingArrayList.newArrayList((int)nfaStateCount, (MemoryTracker)this.mt);
        this.foundNodes = foundNodes;
        this.tracker = tracker;
    }

    public void discover(NodeState node, TraversalDirection direction) {
        this.hooks.discover(node, direction);
        this.foundNodes.addToBuffer(node);
        node.discover(direction);
        State state = node.state();
        block4: for (NodeJuxtaposition nj : state.getNodeJuxtapositions(direction)) {
            if (!nj.endState(direction).test(node.id())) continue;
            switch (direction) {
                case FORWARD: {
                    NodeState nextNode = this.encounter(node.id(), nj.targetState(), direction);
                    TwoWaySignpost.NodeSignpost signpost = TwoWaySignpost.fromNodeJuxtaposition(this.mt, node, nextNode, this.foundNodes.forwardDepth(), this.tracker.lengths());
                    if (this.globalState.searchMode != SearchMode.Unidirectional && nextNode.hasSourceSignpost(signpost)) continue block4;
                    nextNode.addSourceSignpost(signpost, this.foundNodes.forwardDepth());
                    continue block4;
                }
                case BACKWARD: {
                    NodeState nextNode = this.encounter(node.id(), nj.sourceState(), direction);
                    TwoWaySignpost.NodeSignpost signpost = TwoWaySignpost.fromNodeJuxtaposition(this.mt, nextNode, node, this.tracker.lengths());
                    if (nextNode.hasTargetSignpost(signpost)) continue block4;
                    TwoWaySignpost.NodeSignpost addedSignpost = node.upsertSourceSignpost(signpost);
                    addedSignpost.setMinTargetDistance(this.foundNodes.backwardDepth(), PGPathPropagatingBFS.Phase.Expansion);
                }
            }
        }
    }

    public NodeState encounter(long nodeId, State state, TraversalDirection direction) {
        NodeState nodeState = this.foundNodes.get(nodeId, state.id());
        if (nodeState == null) {
            nodeState = new NodeState(this.globalState, nodeId, state, this.intoTarget, this.tracker.lengths());
            this.discover(nodeState, direction);
        } else if (this.globalState.searchMode == SearchMode.Bidirectional && !nodeState.hasBeenSeen(direction)) {
            this.discover(nodeState, direction);
        }
        return nodeState;
    }

    private void multiHopDFS(NodeState startNode, MultiRelationshipExpansion expansion, TraversalDirection direction) {
        VirtualRelationshipValue[] rels = new VirtualRelationshipValue[expansion.length()];
        long[] nodes = new long[expansion.length() - 1];
        HeapTrackingLongArrayList[] nodeTree = new HeapTrackingLongArrayList[expansion.length() + 1];
        nodeTree[0] = HeapTrackingLongArrayList.newLongArrayList((int)1, (MemoryTracker)this.mt);
        nodeTree[0].add(startNode.id());
        HeapTrackingArrayList[] relTree = new HeapTrackingArrayList[expansion.length()];
        int depth = 0;
        MREValidator mreValidator = this.tracker.mreValidator();
        block4: while (depth != -1) {
            VirtualRelationshipValue rel;
            assert (depth <= expansion.length()) : "Multi-hop depth first search should never exceed total expansion length";
            if (nodeTree[depth] == null || nodeTree[depth].isEmpty()) {
                if (depth > 0) {
                    rels[direction.isBackward() ? rels.length - depth : depth - 1] = null;
                    if (depth <= nodes.length) {
                        nodes[direction.isBackward() ? nodes.length - depth : depth - 1] = 0L;
                    }
                }
                --depth;
                continue;
            }
            if (depth == expansion.length()) {
                long endNode = nodeTree[depth].removeLast();
                rel = (VirtualRelationshipValue)relTree[depth - 1].removeLast();
                rels[direction.isBackward() ? rels.length - depth : depth - 1] = rel;
                if (!expansion.compoundPredicate().test(startNode.id(), rels, nodes, endNode)) continue;
                NodeState nextNode = this.encounter(endNode, expansion.endState(direction), direction);
                long[] relIds = new long[rels.length];
                for (int i = 0; i < rels.length; ++i) {
                    relIds[i] = rels[i].id();
                }
                switch (direction) {
                    case FORWARD: {
                        TwoWaySignpost.MultiRelSignpost signpost = TwoWaySignpost.fromMultiRel(this.mt, startNode, relIds, (long[])nodes.clone(), expansion, nextNode, this.foundNodes.forwardDepth(), this.tracker.lengths());
                        if (this.globalState.searchMode != SearchMode.Unidirectional && nextNode.hasSourceSignpost(signpost)) continue block4;
                        nextNode.addSourceSignpost(signpost, this.foundNodes.forwardDepth());
                        break;
                    }
                    case BACKWARD: {
                        TwoWaySignpost.MultiRelSignpost signpost = TwoWaySignpost.fromMultiRel(this.mt, nextNode, relIds, (long[])nodes.clone(), expansion, startNode, this.tracker.lengths());
                        if (nextNode.hasTargetSignpost(signpost)) break;
                        TwoWaySignpost.MultiRelSignpost addedSignpost = startNode.upsertSourceSignpost(signpost);
                        addedSignpost.setMinTargetDistance(this.foundNodes.backwardDepth(), PGPathPropagatingBFS.Phase.Expansion);
                    }
                }
                continue;
            }
            long node = nodeTree[depth].removeLast();
            if (depth > 0) {
                rel = (VirtualRelationshipValue)relTree[depth - 1].removeLast();
                rels[direction.isBackward() ? rels.length - depth : depth - 1] = rel;
                if (depth <= nodes.length) {
                    nodes[direction.isBackward() ? nodes.length - depth : depth - 1] = node;
                }
            }
            MultiRelationshipExpansion.Rel relHop = expansion.rel(depth, direction);
            LongPredicate nodePredicate = expansion.nodePredicate(depth, direction);
            RelationshipSelection sel = relHop.getSelection(direction);
            this.relCursor.setNode(node, sel);
            boolean canExpand = false;
            while (this.relCursor.nextRelationship()) {
                if (!relHop.predicate().test(this.relCursor) || !nodePredicate.test(this.relCursor.otherNode()) || !mreValidator.validateRelationships(direction, depth, rels, this.relCursor)) continue;
                if (nodeTree[depth + 1] == null) {
                    nodeTree[depth + 1] = HeapTrackingLongArrayList.newLongArrayList((MemoryTracker)this.mt);
                }
                nodeTree[depth + 1].add(this.relCursor.otherNode());
                if (relTree[depth] == null) {
                    relTree[depth] = HeapTrackingArrayList.newArrayList((MemoryTracker)this.mt);
                }
                relTree[depth].add((Object)ValueUtils.fromRelationshipCursor((RelationshipDataReader)this.relCursor));
                canExpand = true;
            }
            if (!canExpand) continue;
            ++depth;
        }
    }

    public void expand() {
        this.foundNodes.openBuffer();
        TraversalDirection direction = this.foundNodes.getNextExpansionDirection();
        this.hooks.expand(direction, this.foundNodes);
        for (LongObjectPair pair : this.foundNodes.frontier(direction).keyValuesView()) {
            long dbNodeId = pair.getOne();
            HeapTrackingArrayList statesById = (HeapTrackingArrayList)pair.getTwo();
            this.statesList.clear();
            for (NodeState nodeState : statesById) {
                if (nodeState == null) continue;
                this.statesList.add((Object)nodeState.state());
                for (MultiRelationshipExpansion mre : nodeState.state().getMultiRelationshipExpansions(direction)) {
                    int depth = this.foundNodes.depth(direction) - 1 + mre.length();
                    this.foundNodes.enqueueScheduled(depth, nodeState, mre, direction);
                }
            }
            this.hooks.expandNode(dbNodeId, this.statesList, direction);
            this.pgCursor.setNodeAndStates(dbNodeId, (List<State>)this.statesList, direction);
            block7: while (this.pgCursor.next()) {
                long foundNode = this.pgCursor.otherNodeReference();
                RelationshipExpansion re = this.pgCursor.relationshipExpansion();
                switch (direction) {
                    case FORWARD: {
                        NodeState nextNode = this.encounter(foundNode, re.targetState(), direction);
                        NodeState node = (NodeState)statesById.get(re.sourceState().id());
                        TwoWaySignpost.RelSignpost signpost = TwoWaySignpost.fromRelExpansion(this.mt, node, this.pgCursor.relationshipReference(), nextNode, re, this.foundNodes.forwardDepth(), this.tracker.lengths());
                        if (this.globalState.searchMode != SearchMode.Unidirectional && nextNode.hasSourceSignpost(signpost)) continue block7;
                        nextNode.addSourceSignpost(signpost, this.foundNodes.forwardDepth());
                        break;
                    }
                    case BACKWARD: {
                        NodeState nextNode = this.encounter(foundNode, re.sourceState(), direction);
                        NodeState node = (NodeState)statesById.get(re.targetState().id());
                        TwoWaySignpost.RelSignpost signpost = TwoWaySignpost.fromRelExpansion(this.mt, nextNode, this.pgCursor.relationshipReference(), node, re, this.tracker.lengths());
                        if (nextNode.hasTargetSignpost(signpost)) break;
                        TwoWaySignpost.RelSignpost addedSignpost = node.upsertSourceSignpost(signpost);
                        addedSignpost.setMinTargetDistance(this.foundNodes.backwardDepth(), PGPathPropagatingBFS.Phase.Expansion);
                    }
                }
            }
        }
        FoundNodes.ScheduledExpansion mre = this.foundNodes.dequeueScheduled(direction);
        while (mre != null) {
            this.multiHopDFS(mre.start(), mre.expansion(), direction);
            mre = this.foundNodes.dequeueScheduled(direction);
        }
        this.foundNodes.commitBuffer(direction);
    }

    public void setTracer(KernelReadTracer tracer) {
        this.pgCursor.setTracer(tracer);
    }

    @Override
    public void close() throws Exception {
        this.pgCursor.close();
        this.statesList.close();
    }
}

