/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.BitSet;
import org.neo4j.common.EntityType;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeData;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SignpostStack;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;

public final class PathTracer
extends PrefetchingIterator<TracedPath> {
    private final PPBFSHooks hooks;
    private final SignpostStack stack;
    private NodeData sourceNode;
    private int dgLength;
    private final BitSet pgTrailToTarget = new BitSet();
    private final BitSet betweenDuplicateRels = new BitSet();
    private boolean shouldReturnSingleNodePath;
    private boolean ready = false;

    public boolean isSaturated() {
        return this.stack.target().remainingTargetCount() == 0;
    }

    public PathTracer(MemoryTracker memoryTracker, PPBFSHooks hooks) {
        this.hooks = hooks;
        this.stack = new SignpostStack(memoryTracker, hooks);
    }

    public void setSourceNode(NodeData sourceNode) {
        this.ready = false;
        this.sourceNode = sourceNode;
    }

    public void resetWithNewTargetNodeAndDGLength(NodeData targetNode, int dgLength) {
        Preconditions.checkArgument((targetNode.remainingTargetCount() >= 0 ? 1 : 0) != 0, (String)"remainingTargetCount should not be decremented beyond 0");
        this.ready = true;
        this.stack.reset(targetNode, dgLength);
        this.pgTrailToTarget.clear();
        this.pgTrailToTarget.set(0);
        this.betweenDuplicateRels.clear();
        this.dgLength = dgLength;
        this.shouldReturnSingleNodePath = targetNode == this.sourceNode && dgLength == 0;
        super.reset();
    }

    public boolean ready() {
        return this.ready;
    }

    private void popCurrent() {
        TwoWaySignpost popped = this.stack.pop();
        if (popped == null) {
            return;
        }
        int sourceLength = this.stack.lengthFromSource();
        if (!popped.isVerifiedAtLength(sourceLength) && !this.betweenDuplicateRels.get(this.stack.size())) {
            popped.pruneSourceLength(sourceLength);
        }
    }

    protected TracedPath fetchNextOrNull() {
        if (!this.ready) {
            throw new IllegalStateException("PathTracer attempted to iterate without fully configuring.");
        }
        if (this.shouldReturnSingleNodePath && !this.isSaturated()) {
            this.shouldReturnSingleNodePath = false;
            Preconditions.checkState((this.stack.lengthFromSource() == 0 ? 1 : 0) != 0, (String)"Attempting to return a path that does not reach the source");
            return this.stack.currentPath();
        }
        while (this.stack.hasNext()) {
            if (!this.stack.pushNext()) {
                this.popCurrent();
                continue;
            }
            TwoWaySignpost sourceSignpost = this.stack.headSignpost();
            this.betweenDuplicateRels.set(this.stack.size() - 1, false);
            boolean isTargetPGTrail = this.pgTrailToTarget.get(this.stack.size() - 1) && !sourceSignpost.isDoublyActive();
            this.pgTrailToTarget.set(this.stack.size(), isTargetPGTrail);
            if (isTargetPGTrail && !sourceSignpost.hasBeenTraced()) {
                sourceSignpost.setMinDistToTarget(this.stack.lengthToTarget());
            }
            if (sourceSignpost.isDoublyActive() && this.allNodesAreValidatedBetweenDuplicates()) {
                this.hooks.skippingDuplicateRelationship((Function0<TracedPath>)((Function0)this.stack::currentPath));
                this.stack.pop();
                continue;
            }
            if (sourceSignpost.prevNode != this.sourceNode || !this.validateTrail() || this.isSaturated()) continue;
            Preconditions.checkState((this.stack.lengthFromSource() == 0 ? 1 : 0) != 0, (String)"Attempting to return a path that does not reach the source");
            TracedPath path = this.stack.currentPath();
            this.hooks.returnPath(path);
            return path;
        }
        return null;
    }

    private boolean allNodesAreValidatedBetweenDuplicates() {
        TwoWaySignpost lastSignpost = this.stack.headSignpost();
        int dgLengthFromSource = this.stack.lengthFromSource();
        if (!lastSignpost.prevNode.validatedAtLength(dgLengthFromSource)) {
            return false;
        }
        dgLengthFromSource += lastSignpost.dataGraphLength();
        for (int i = this.stack.size() - 2; i >= 0; --i) {
            TwoWaySignpost candidate = this.stack.signpost(i);
            if (!candidate.prevNode.validatedAtLength(dgLengthFromSource)) {
                return false;
            }
            if (candidate.dataGraphRelationshipEquals(lastSignpost)) {
                this.betweenDuplicateRels.set(i + 1, this.stack.size() - 1, true);
                return true;
            }
            dgLengthFromSource += candidate.dataGraphLength();
        }
        throw new IllegalStateException("Expected duplicate relationship in SHORTEST trail validation");
    }

    private boolean validateTrail() {
        int dgLengthFromSource = 0;
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            TwoWaySignpost signpost = this.stack.signpost(i);
            dgLengthFromSource += signpost.dataGraphLength();
            for (int j = this.stack.size() - 1; j > i; --j) {
                if (!signpost.dataGraphRelationshipEquals(this.stack.signpost(j))) continue;
                this.hooks.invalidTrail((Function0<TracedPath>)((Function0)this.stack::currentPath));
                return false;
            }
            if (signpost.isVerifiedAtLength(dgLengthFromSource)) continue;
            signpost.setVerified(dgLengthFromSource);
            if (signpost.forwardNode.validatedAtLength(dgLengthFromSource)) continue;
            signpost.forwardNode.validateLengthState(dgLengthFromSource, this.dgLength - dgLengthFromSource);
        }
        return true;
    }

    public void decrementTargetCount() {
        this.stack.target().decrementTargetCount();
    }

    public record TracedPath(PathEntity[] entities) {
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("(");
            PathEntity last = null;
            for (PathEntity e : this.entities) {
                switch (e.entityType) {
                    case NODE: {
                        if (last == null || last.entityType == EntityType.RELATIONSHIP) {
                            sb.append(e.id).append("@").append(e.slotOrName);
                            break;
                        }
                        if (last.slotOrName == e.slotOrName) break;
                        sb.append(",").append(e.slotOrName);
                        break;
                    }
                    case RELATIONSHIP: {
                        sb.append(")-[").append(e.id).append("]-(");
                    }
                }
                last = e;
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public record PathEntity(SlotOrName slotOrName, long id, EntityType entityType) {
        static PathEntity fromNode(NodeData node) {
            return new PathEntity(node.state().slotOrName(), node.id(), EntityType.NODE);
        }

        static PathEntity fromRel(TwoWaySignpost.RelSignpost signpost) {
            return new PathEntity(signpost.slotOrName(), signpost.relId, EntityType.RELATIONSHIP);
        }

        public AnyValue idValue() {
            return switch (this.entityType) {
                default -> throw new IncompatibleClassChangeError();
                case EntityType.NODE -> VirtualValues.node((long)this.id);
                case EntityType.RELATIONSHIP -> VirtualValues.relationship((long)this.id);
            };
        }
    }
}

