/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import org.eclipse.collections.api.block.procedure.Procedure;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeData;
import org.neo4j.memory.MemoryTracker;

final class HeapTrackingNodeDatas
implements AutoCloseable {
    private final HeapTrackingArrayList<HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeData>>> previousLevels;
    private HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeData>> currentLevel;
    private HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeData>> nextLevel;
    private final HeapTrackingArrayList<HeapTrackingArrayList<NodeData>> nextLevelQueue;
    private final MemoryTracker memoryTracker;
    private final int numberOfNFAStates;

    public HeapTrackingNodeDatas(MemoryTracker memoryTracker, int numberOfNFAStates) {
        this.memoryTracker = memoryTracker.getScopedMemoryTracker();
        this.previousLevels = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);
        this.currentLevel = HeapTrackingLongObjectHashMap.createLongObjectHashMap((MemoryTracker)this.memoryTracker);
        this.nextLevel = HeapTrackingLongObjectHashMap.createLongObjectHashMap((MemoryTracker)this.memoryTracker);
        this.nextLevelQueue = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);
        this.numberOfNFAStates = numberOfNFAStates;
    }

    public void addToNextLevel(NodeData nodeData) {
        HeapTrackingArrayList dgNodeDatas = (HeapTrackingArrayList)this.nextLevel.get(nodeData.id());
        if (dgNodeDatas == null) {
            dgNodeDatas = HeapTrackingArrayList.newEmptyArrayList((int)this.numberOfNFAStates, (MemoryTracker)this.memoryTracker);
            this.nextLevel.put(nodeData.id(), (Object)dgNodeDatas);
            this.nextLevelQueue.add((Object)dgNodeDatas);
        }
        dgNodeDatas.set(nodeData.state().id(), (Object)nodeData);
    }

    public NodeData get(long nodeId, int stateId) {
        NodeData nodeData;
        HeapTrackingArrayList dgNodeDatas = (HeapTrackingArrayList)this.nextLevel.get(nodeId);
        if (dgNodeDatas != null && (nodeData = (NodeData)dgNodeDatas.get(stateId)) != null) {
            return nodeData;
        }
        dgNodeDatas = (HeapTrackingArrayList)this.currentLevel.get(nodeId);
        if (dgNodeDatas != null && (nodeData = (NodeData)dgNodeDatas.get(stateId)) != null) {
            return nodeData;
        }
        for (int i = this.previousLevels.size() - 1; i >= 0; --i) {
            NodeData nodeData2;
            dgNodeDatas = (HeapTrackingArrayList)((HeapTrackingLongObjectHashMap)this.previousLevels.get(i)).get(nodeId);
            if (dgNodeDatas == null || (nodeData2 = (NodeData)dgNodeDatas.get(stateId)) == null) continue;
            return nodeData2;
        }
        return null;
    }

    public void allocateNextLevel() {
        this.previousLevels.add(this.currentLevel);
        this.currentLevel = this.nextLevel;
        this.nextLevel = HeapTrackingLongObjectHashMap.createLongObjectHashMap((MemoryTracker)this.memoryTracker, (int)this.currentLevel.size());
        this.nextLevelQueue.clear();
    }

    public void forEachNodeInNextLevel(Procedure<? super NodeData> p) {
        for (int i = 0; i < this.nextLevelQueue.size(); ++i) {
            HeapTrackingArrayList dgNodeDatas = (HeapTrackingArrayList)this.nextLevelQueue.get(i);
            for (int j = 0; j < this.numberOfNFAStates; ++j) {
                NodeData nodeData = (NodeData)dgNodeDatas.get(j);
                if (nodeData == null) continue;
                p.accept((Object)nodeData);
            }
        }
    }

    public HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeData>> getCurrentLevelDGDatas() {
        return this.currentLevel;
    }

    public boolean currentLevelHasNodes() {
        return this.currentLevel.notEmpty();
    }

    @Override
    public void close() {
        this.memoryTracker.close();
    }
}

