/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.InvalidValuesArgumentException;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;
import org.opencypher.v9_0.util.CypherTypeException;
import org.opencypher.v9_0.util.InvalidArgumentException;
import org.opencypher.v9_0.util.ParameterWrongTypeException;

public final class CypherFunctions {
    private static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private static String[] POINT_KEYS = new String[]{"crs", "x", "y", "z", "longitude", "latitude", "height", "srid"};

    private CypherFunctions() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static DoubleValue sin(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.sin(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("sin()");
    }

    public static DoubleValue asin(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.asin(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("asin()");
    }

    public static DoubleValue haversin(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)((1.0 - Math.cos(((NumberValue)in).doubleValue())) / 2.0));
        }
        throw CypherFunctions.needsNumbers("haversin()");
    }

    public static DoubleValue cos(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.cos(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("cos()");
    }

    public static DoubleValue cot(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)(1.0 / Math.tan(((NumberValue)in).doubleValue())));
        }
        throw CypherFunctions.needsNumbers("cot()");
    }

    public static DoubleValue acos(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.acos(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("acos()");
    }

    public static DoubleValue tan(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.tan(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("tan()");
    }

    public static DoubleValue atan(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.atan(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("atan()");
    }

    public static DoubleValue atan2(AnyValue y, AnyValue x) {
        if (y instanceof NumberValue && x instanceof NumberValue) {
            return Values.doubleValue((double)Math.atan2(((NumberValue)y).doubleValue(), ((NumberValue)x).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("atan2()");
    }

    public static DoubleValue ceil(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.ceil(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("ceil()");
    }

    public static DoubleValue floor(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.floor(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("floor()");
    }

    public static DoubleValue round(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.round(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("round()");
    }

    public static NumberValue abs(AnyValue in) {
        if (in instanceof NumberValue) {
            if (in instanceof IntegralValue) {
                return Values.longValue((long)Math.abs(((NumberValue)in).longValue()));
            }
            return Values.doubleValue((double)Math.abs(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("abs()");
    }

    public static DoubleValue toDegrees(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.toDegrees(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("toDegrees()");
    }

    public static DoubleValue exp(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.exp(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("exp()");
    }

    public static DoubleValue log(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.log(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("log()");
    }

    public static DoubleValue log10(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.log10(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("log10()");
    }

    public static DoubleValue toRadians(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.toRadians(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("toRadians()");
    }

    public static ListValue range(AnyValue startValue, AnyValue endValue) {
        return VirtualValues.range((long)CypherFunctions.asLong(startValue), (long)CypherFunctions.asLong(endValue), (long)1L);
    }

    public static ListValue range(AnyValue startValue, AnyValue endValue, AnyValue stepValue) {
        long step = CypherFunctions.asLong(stepValue);
        if (step == 0L) {
            throw new InvalidArgumentException("step argument to range() cannot be zero", null);
        }
        return VirtualValues.range((long)CypherFunctions.asLong(startValue), (long)CypherFunctions.asLong(endValue), (long)step);
    }

    public static LongValue signum(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.longValue((long)((long)Math.signum(((NumberValue)in).doubleValue())));
        }
        throw CypherFunctions.needsNumbers("signum()");
    }

    public static DoubleValue sqrt(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.sqrt(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("sqrt()");
    }

    public static DoubleValue rand() {
        return Values.doubleValue((double)ThreadLocalRandom.current().nextDouble());
    }

    public static Value distance(AnyValue lhs, AnyValue rhs) {
        if (lhs instanceof PointValue && rhs instanceof PointValue) {
            return CypherFunctions.calculateDistance((PointValue)lhs, (PointValue)rhs);
        }
        return Values.NO_VALUE;
    }

    public static NodeValue startNode(AnyValue anyValue, DbAccess access) {
        if (anyValue instanceof RelationshipValue) {
            return access.relationshipGetStartNode((RelationshipValue)anyValue);
        }
        throw new CypherTypeException(String.format("Expected %s to be a RelationshipValue", anyValue), null);
    }

    public static NodeValue endNode(AnyValue anyValue, DbAccess access) {
        if (anyValue instanceof RelationshipValue) {
            return access.relationshipGetEndNode((RelationshipValue)anyValue);
        }
        throw new CypherTypeException(String.format("Expected %s to be a RelationshipValue", anyValue), null);
    }

    public static BooleanValue propertyExists(String key, AnyValue container, DbAccess dbAccess) {
        if (container instanceof VirtualNodeValue) {
            return dbAccess.nodeHasProperty(((VirtualNodeValue)container).id(), dbAccess.propertyKey(key)) ? Values.TRUE : Values.FALSE;
        }
        if (container instanceof VirtualRelationshipValue) {
            return dbAccess.relationshipHasProperty(((VirtualRelationshipValue)container).id(), dbAccess.propertyKey(key)) ? Values.TRUE : Values.FALSE;
        }
        if (container instanceof MapValue) {
            return ((MapValue)container).get(key) != Values.NO_VALUE ? Values.TRUE : Values.FALSE;
        }
        throw new CypherTypeException(String.format("Expected %s to be a property container", container), null);
    }

    public static AnyValue propertyGet(String key, AnyValue container, DbAccess dbAccess) {
        if (container instanceof VirtualNodeValue) {
            return dbAccess.nodeProperty(((VirtualNodeValue)container).id(), dbAccess.propertyKey(key));
        }
        if (container instanceof VirtualRelationshipValue) {
            return dbAccess.relationshipProperty(((VirtualRelationshipValue)container).id(), dbAccess.propertyKey(key));
        }
        if (container instanceof MapValue) {
            return ((MapValue)container).get(key);
        }
        if (container instanceof TemporalValue) {
            return ((TemporalValue)container).get(key);
        }
        if (container instanceof DurationValue) {
            return ((DurationValue)container).get(key);
        }
        if (container instanceof PointValue) {
            try {
                return ((PointValue)container).get(key);
            }
            catch (InvalidValuesArgumentException e) {
                throw new InvalidArgumentException(e.getMessage(), (Throwable)e);
            }
        }
        throw new CypherTypeException(String.format("Type mismatch: expected a map but was %s", container.toString()), null);
    }

    public static AnyValue containerIndex(AnyValue container, AnyValue index, DbAccess dbAccess) {
        if (container instanceof VirtualNodeValue) {
            return dbAccess.nodeProperty(((VirtualNodeValue)container).id(), dbAccess.propertyKey(CypherFunctions.asString(index)));
        }
        if (container instanceof VirtualRelationshipValue) {
            return dbAccess.relationshipProperty(((VirtualRelationshipValue)container).id(), dbAccess.propertyKey(CypherFunctions.asString(index)));
        }
        if (container instanceof MapValue) {
            return CypherFunctions.mapAccess((MapValue)container, index);
        }
        if (container instanceof SequenceValue) {
            return CypherFunctions.listAccess((SequenceValue)container, index);
        }
        throw new CypherTypeException(String.format("`%s` is not a collection or a map. Element access is only possible by performing a collection lookup using an integer index, or by performing a map lookup using a string key (found: %s[%s])", container, container, index), null);
    }

    public static AnyValue head(AnyValue container) {
        if (container instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)container;
            if (sequence.length() == 0) {
                return Values.NO_VALUE;
            }
            return sequence.value(0);
        }
        throw new CypherTypeException(String.format("Expected %s to be a list", container), null);
    }

    public static ListValue tail(AnyValue container) {
        if (container instanceof ListValue) {
            return ((ListValue)container).tail();
        }
        if (container instanceof ArrayValue) {
            return VirtualValues.fromArray((ArrayValue)((ArrayValue)container)).tail();
        }
        return VirtualValues.EMPTY_LIST;
    }

    public static AnyValue last(AnyValue container) {
        if (container instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)container;
            int length = sequence.length();
            if (length == 0) {
                return Values.NO_VALUE;
            }
            return sequence.value(length - 1);
        }
        throw new CypherTypeException(String.format("Expected %s to be a list", container), null);
    }

    public static TextValue left(AnyValue in, AnyValue endPos) {
        if (in instanceof TextValue) {
            int len = CypherFunctions.asInt(endPos);
            return ((TextValue)in).substring(0, len);
        }
        throw CypherFunctions.notAString("left", in);
    }

    public static TextValue ltrim(AnyValue in) {
        if (in instanceof TextValue) {
            return ((TextValue)in).ltrim();
        }
        throw CypherFunctions.notAString("ltrim", in);
    }

    public static TextValue rtrim(AnyValue in) {
        if (in instanceof TextValue) {
            return ((TextValue)in).rtrim();
        }
        throw CypherFunctions.notAString("rtrim", in);
    }

    public static TextValue trim(AnyValue in) {
        if (in instanceof TextValue) {
            return ((TextValue)in).trim();
        }
        throw CypherFunctions.notAString("trim", in);
    }

    public static TextValue replace(AnyValue original, AnyValue search, AnyValue replaceWith) {
        if (original instanceof TextValue) {
            return ((TextValue)original).replace(CypherFunctions.asString(search), CypherFunctions.asString(replaceWith));
        }
        throw CypherFunctions.notAString("replace", original);
    }

    public static AnyValue reverse(AnyValue original) {
        if (original instanceof TextValue) {
            return ((TextValue)original).reverse();
        }
        if (original instanceof ListValue) {
            return ((ListValue)original).reverse();
        }
        throw new CypherTypeException("Expected a string or a list; consider converting it to a string with toString() or creating a list.", null);
    }

    public static TextValue right(AnyValue original, AnyValue length) {
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            int len = CypherFunctions.asInt(length);
            if (len < 0) {
                throw new IndexOutOfBoundsException("negative length");
            }
            int startVal = asText.length() - len;
            return asText.substring(Math.max(0, startVal));
        }
        throw CypherFunctions.notAString("right", original);
    }

    public static ListValue split(AnyValue original, AnyValue separator) {
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            if (asText.length() == 0) {
                return VirtualValues.list((AnyValue[])new AnyValue[]{Values.EMPTY_STRING});
            }
            return asText.split(CypherFunctions.asString(separator));
        }
        throw CypherFunctions.notAString("split", original);
    }

    public static TextValue substring(AnyValue original, AnyValue start) {
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            return asText.substring(CypherFunctions.asInt(start));
        }
        throw CypherFunctions.notAString("substring", original);
    }

    public static TextValue substring(AnyValue original, AnyValue start, AnyValue length) {
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            return asText.substring(CypherFunctions.asInt(start), CypherFunctions.asInt(length));
        }
        throw CypherFunctions.notAString("substring", original);
    }

    public static TextValue toLower(AnyValue in) {
        if (in instanceof TextValue) {
            return ((TextValue)in).toLower();
        }
        throw CypherFunctions.notAString("toLower", in);
    }

    public static TextValue toUpper(AnyValue in) {
        if (in instanceof TextValue) {
            return ((TextValue)in).toUpper();
        }
        throw CypherFunctions.notAString("toUpper", in);
    }

    public static LongValue id(AnyValue item) {
        if (item instanceof VirtualNodeValue) {
            return Values.longValue((long)((VirtualNodeValue)item).id());
        }
        if (item instanceof VirtualRelationshipValue) {
            return Values.longValue((long)((VirtualRelationshipValue)item).id());
        }
        throw new CypherTypeException(String.format("Expected %s to be a node or relationship, but it was `%s`", item, item.getClass().getSimpleName()), null);
    }

    public static ListValue labels(AnyValue item, DbAccess access) {
        if (item instanceof NodeValue) {
            return access.getLabelsForNode(((NodeValue)item).id());
        }
        throw new ParameterWrongTypeException("Expected a Node, got: " + item, null);
    }

    public static boolean hasLabel(AnyValue entity, int labelToken, DbAccess access) {
        if (entity instanceof NodeValue) {
            return access.isLabelSetOnNode(labelToken, ((NodeValue)entity).id());
        }
        throw new ParameterWrongTypeException("Expected a Node, got: " + entity, null);
    }

    public static TextValue type(AnyValue item) {
        if (item instanceof RelationshipValue) {
            return ((RelationshipValue)item).type();
        }
        throw new ParameterWrongTypeException("Expected a Relationship, got: " + item, null);
    }

    public static ListValue nodes(AnyValue in) {
        if (in instanceof PathValue) {
            return VirtualValues.list((AnyValue[])((PathValue)in).nodes());
        }
        throw new CypherTypeException(String.format("Expected %s to be a path.", in), null);
    }

    public static ListValue relationships(AnyValue in) {
        if (in instanceof PathValue) {
            return VirtualValues.list((AnyValue[])((PathValue)in).relationships());
        }
        throw new CypherTypeException(String.format("Expected %s to be a path.", in), null);
    }

    public static Value point(AnyValue in, DbAccess access) {
        if (in instanceof VirtualNodeValue) {
            return CypherFunctions.asPoint(access, (VirtualNodeValue)in);
        }
        if (in instanceof VirtualRelationshipValue) {
            return CypherFunctions.asPoint(access, (VirtualRelationshipValue)in);
        }
        if (in instanceof MapValue) {
            MapValue map = (MapValue)in;
            if (CypherFunctions.containsNull(map)) {
                return Values.NO_VALUE;
            }
            return PointValue.fromMap((MapValue)map);
        }
        throw new CypherTypeException(String.format("Expected a map but got %s", in), null);
    }

    public static ListValue keys(AnyValue in, DbAccess access) {
        if (in instanceof VirtualNodeValue) {
            return CypherFunctions.extractKeys(access, access.nodePropertyIds(((VirtualNodeValue)in).id()));
        }
        if (in instanceof VirtualRelationshipValue) {
            return CypherFunctions.extractKeys(access, access.relationshipPropertyIds(((VirtualRelationshipValue)in).id()));
        }
        if (in instanceof MapValue) {
            return ((MapValue)in).keys();
        }
        throw new CypherTypeException(String.format("Expected a node, a relationship or a literal map but got %s", in), null);
    }

    public static MapValue properties(AnyValue in, DbAccess access) {
        if (in instanceof VirtualNodeValue) {
            return access.nodeAsMap(((VirtualNodeValue)in).id());
        }
        if (in instanceof VirtualRelationshipValue) {
            return access.relationshipAsMap(((VirtualRelationshipValue)in).id());
        }
        if (in instanceof MapValue) {
            return (MapValue)in;
        }
        throw new CypherTypeException(String.format("Expected a node, a relationship or a literal map but got %s", in), null);
    }

    public static IntegralValue size(AnyValue item) {
        if (item instanceof PathValue) {
            throw new CypherTypeException("SIZE cannot be used on paths", null);
        }
        if (item instanceof TextValue) {
            return Values.longValue((long)((TextValue)item).length());
        }
        if (item instanceof SequenceValue) {
            return Values.longValue((long)((SequenceValue)item).length());
        }
        return Values.longValue((long)1L);
    }

    public static IntegralValue length(AnyValue item) {
        if (item instanceof PathValue) {
            return Values.longValue((long)((PathValue)item).size());
        }
        if (item instanceof TextValue) {
            return Values.longValue((long)((TextValue)item).length());
        }
        if (item instanceof SequenceValue) {
            return Values.longValue((long)((SequenceValue)item).length());
        }
        return Values.longValue((long)1L);
    }

    public static Value toBoolean(AnyValue in) {
        if (in instanceof BooleanValue) {
            return (BooleanValue)in;
        }
        if (in instanceof TextValue) {
            switch (((TextValue)in).trim().stringValue().toLowerCase()) {
                case "true": {
                    return Values.TRUE;
                }
                case "false": {
                    return Values.FALSE;
                }
            }
            return Values.NO_VALUE;
        }
        throw new ParameterWrongTypeException("Expected a Boolean or String, got: " + in.toString(), null);
    }

    public static Value toFloat(AnyValue in) {
        if (in instanceof DoubleValue) {
            return (DoubleValue)in;
        }
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)((NumberValue)in).doubleValue());
        }
        if (in instanceof TextValue) {
            try {
                return Values.doubleValue((double)Double.parseDouble(((TextValue)in).stringValue()));
            }
            catch (NumberFormatException ignore) {
                return Values.NO_VALUE;
            }
        }
        throw new ParameterWrongTypeException("Expected a String or Number, got: " + in.toString(), null);
    }

    public static Value toInteger(AnyValue in) {
        if (in instanceof IntegralValue) {
            return (IntegralValue)in;
        }
        if (in instanceof NumberValue) {
            return Values.longValue((long)((NumberValue)in).longValue());
        }
        if (in instanceof TextValue) {
            return CypherFunctions.stringToLongValue((TextValue)in);
        }
        throw new ParameterWrongTypeException("Expected a String or Number, got: " + in.toString(), null);
    }

    public static TextValue toString(AnyValue in) {
        if (in instanceof TextValue) {
            return (TextValue)in;
        }
        if (in instanceof NumberValue) {
            return Values.stringValue((String)((NumberValue)in).prettyPrint());
        }
        if (in instanceof BooleanValue) {
            return Values.stringValue((String)((BooleanValue)in).prettyPrint());
        }
        if (in instanceof TemporalValue || in instanceof DurationValue || in instanceof PointValue) {
            return Values.stringValue((String)in.toString());
        }
        throw new ParameterWrongTypeException("Expected a String, Number, Boolean, Temporal or Duration, got: " + in.toString(), null);
    }

    public static ListValue fromSlice(AnyValue collection, AnyValue fromValue) {
        int from = CypherFunctions.asInt(fromValue);
        ListValue list = CypherFunctions.makeTraversable(collection);
        if (from >= 0) {
            return list.drop(from);
        }
        return list.drop(list.size() + from);
    }

    public static ListValue toSlice(AnyValue collection, AnyValue fromValue) {
        int from = CypherFunctions.asInt(fromValue);
        ListValue list = CypherFunctions.makeTraversable(collection);
        if (from >= 0) {
            return list.take(from);
        }
        return list.take(list.size() + from);
    }

    public static ListValue fullSlice(AnyValue collection, AnyValue fromValue, AnyValue toValue) {
        int from = CypherFunctions.asInt(fromValue);
        int to = CypherFunctions.asInt(toValue);
        ListValue list = CypherFunctions.makeTraversable(collection);
        int size = list.size();
        if (from >= 0 && to >= 0) {
            return list.slice(from, to);
        }
        if (from >= 0) {
            return list.slice(from, size + to);
        }
        if (to >= 0) {
            return list.slice(size + from, to);
        }
        return list.slice(size + from, size + to);
    }

    public static ListValue makeTraversable(AnyValue collection) {
        if (collection == Values.NO_VALUE) {
            return VirtualValues.EMPTY_LIST;
        }
        if (collection instanceof ListValue) {
            return (ListValue)collection;
        }
        if (collection instanceof ArrayValue) {
            return VirtualValues.fromArray((ArrayValue)((ArrayValue)collection));
        }
        return VirtualValues.list((AnyValue[])new AnyValue[]{collection});
    }

    private static Value stringToLongValue(TextValue in) {
        try {
            return Values.longValue((long)Long.parseLong(in.stringValue()));
        }
        catch (Exception e) {
            try {
                BigDecimal bigDecimal = new BigDecimal(in.stringValue());
                if (bigDecimal.compareTo(MAX_LONG) <= 0 && bigDecimal.compareTo(MIN_LONG) >= 0) {
                    return Values.longValue((long)bigDecimal.longValue());
                }
                throw new CypherTypeException(String.format("integer, %s, is too large", in.stringValue()), null);
            }
            catch (NumberFormatException ignore) {
                return Values.NO_VALUE;
            }
        }
    }

    private static ListValue extractKeys(DbAccess access, int[] keyIds) {
        String[] keysNames = new String[keyIds.length];
        for (int i = 0; i < keyIds.length; ++i) {
            keysNames[i] = access.getPropertyKeyName(keyIds[i]);
        }
        return VirtualValues.fromArray((ArrayValue)Values.stringArray((String[])keysNames));
    }

    private static Value asPoint(DbAccess access, VirtualNodeValue nodeValue) {
        MapValueBuilder builder = new MapValueBuilder();
        for (String key : POINT_KEYS) {
            Value value = access.nodeProperty(nodeValue.id(), access.propertyKey(key));
            if (value == Values.NO_VALUE) continue;
            builder.add(key, (AnyValue)value);
        }
        return PointValue.fromMap((MapValue)builder.build());
    }

    private static Value asPoint(DbAccess access, VirtualRelationshipValue relationshipValue) {
        MapValueBuilder builder = new MapValueBuilder();
        for (String key : POINT_KEYS) {
            Value value = access.relationshipProperty(relationshipValue.id(), access.propertyKey(key));
            if (value == Values.NO_VALUE) continue;
            builder.add(key, (AnyValue)value);
        }
        return PointValue.fromMap((MapValue)builder.build());
    }

    private static boolean containsNull(MapValue map) {
        boolean[] hasNull = new boolean[]{false};
        map.foreach((s, value) -> {
            if (value == Values.NO_VALUE) {
                hasNull[0] = true;
            }
        });
        return hasNull[0];
    }

    private static AnyValue listAccess(SequenceValue container, AnyValue index) {
        NumberValue number = CypherFunctions.asNumberValue(index);
        if (!(number instanceof IntegralValue)) {
            throw new CypherTypeException(String.format("Cannot index a list using an non-integer number, got %s", number), null);
        }
        long idx = number.longValue();
        if (idx > Integer.MAX_VALUE || idx < Integer.MIN_VALUE) {
            throw new InvalidArgumentException(String.format("Cannot index a list using a value greater than %d or lesser than %d, got %d", Integer.MAX_VALUE, Integer.MIN_VALUE, idx), null);
        }
        if (idx < 0L) {
            idx = (long)container.length() + idx;
        }
        if (idx >= (long)container.length() || idx < 0L) {
            return Values.NO_VALUE;
        }
        return container.value((int)idx);
    }

    private static AnyValue mapAccess(MapValue container, AnyValue index) {
        return container.get(CypherFunctions.asString(index));
    }

    public static TextValue asTextValue(AnyValue value) {
        if (!(value instanceof TextValue)) {
            throw new CypherTypeException(String.format("Expected %s to be a %s, but it was a %s", value, TextValue.class.getName(), value.getClass().getName()), null);
        }
        return (TextValue)value;
    }

    static String asString(AnyValue value) {
        return CypherFunctions.asTextValue(value).stringValue();
    }

    private static NumberValue asNumberValue(AnyValue value) {
        if (!(value instanceof NumberValue)) {
            throw new CypherTypeException(String.format("Expected %s to be a %s, but it was a %s", value, NumberValue.class.getName(), value.getClass().getName()), null);
        }
        return (NumberValue)value;
    }

    private static Value calculateDistance(PointValue p1, PointValue p2) {
        if (p1.getCoordinateReferenceSystem().equals((Object)p2.getCoordinateReferenceSystem())) {
            return Values.doubleValue((double)p1.getCoordinateReferenceSystem().getCalculator().distance(p1, p2));
        }
        return Values.NO_VALUE;
    }

    private static long asLong(AnyValue value) {
        if (value instanceof NumberValue) {
            return ((NumberValue)value).longValue();
        }
        throw new CypherTypeException("Expected a numeric value but got: " + value.toString(), null);
    }

    private static int asInt(AnyValue value) {
        return (int)CypherFunctions.asLong(value);
    }

    private static CypherTypeException needsNumbers(String method) {
        return new CypherTypeException(String.format("%s requires numbers", method), null);
    }

    private static CypherTypeException notAString(String method, AnyValue in) {
        return new CypherTypeException(String.format("Expected a string value for `%s`, but got: %s; consider converting it to a string with toString().", method, in), null);
    }
}

